/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slalom;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.Rotator2;
import pencilbox.slalom.Board;

public class BoardCopier
extends BoardCopierBase {
    public void copyRegion(BoardBase srcBoardBase, BoardBase dstBoardBase, Area region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)dstBoardBase;
        for (Address s : region) {
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            int[] nArray = Direction.DN_RT;
            int n = Direction.DN_RT.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                if (region.contains(Address.nextCell(s, n3))) {
                    int joint = srcBoard.getStateJ(s, n3);
                    int dir = Rotator2.rotateDirection(n3, rotation);
                    if (board.isSideOn(d, dir)) {
                        board.setStateJ(d, dir, joint);
                    }
                }
                ++n2;
            }
            if (!board.isOn(d)) continue;
            if (srcBoard.getNumber(s) == -4) {
                if (Rotator2.isTransposed(rotation)) {
                    board.setNumber(d, -5);
                    continue;
                }
                board.setNumber(d, -4);
                continue;
            }
            if (srcBoard.getNumber(s) == -5) {
                if (Rotator2.isTransposed(rotation)) {
                    board.setNumber(d, -4);
                    continue;
                }
                board.setNumber(d, -5);
                continue;
            }
            board.setNumber(d, srcBoard.getNumber(s));
        }
    }

    public void eraseRegion(BoardBase srcBoardBase, Area region) {
        Board board = (Board)srcBoardBase;
        for (Address s : region) {
            int[] nArray = Direction.DN_RT;
            int n = Direction.DN_RT.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                Address dn = Address.nextCell(s, n3);
                if (region.contains(dn)) {
                    board.setStateJ(s, n3, 0);
                }
                ++n2;
            }
            board.setNumber(s, -3);
        }
    }
}

