/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import pencilbox.common.core.BoardBase;
import pencilbox.common.io.XmlWriterBase;
import pencilbox.kakuro.Board;

public class XmlWriter
extends XmlWriterBase {
    protected void setBoardData(BoardBase theboard) {
        Board board = (Board)theboard;
        int rows = board.rows();
        int cols = board.cols();
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                if (board.isWall(r, c)) {
                    this.outWall(r, c, board.getSumH(r, c), board.getSumV(r, c));
                }
                ++c;
            }
            ++r;
        }
    }

    void outWall(int r, int c, int a, int b) {
        this.writer.println(2, "<wall r=\"" + (r + 1) + "\" c=\"" + (c + 1) + "\" a=\"" + a + "\" b=\"" + b + "\"/>");
    }

    protected void setAnswerData(BoardBase theboard) {
        Board board = (Board)theboard;
        int rows = board.rows();
        int cols = board.cols();
        int r = 0;
        while (r < rows) {
            this.startArow(r);
            int c = 0;
            while (c < cols) {
                this.outN(board.getNumber(r, c));
                ++c;
            }
            this.endArow();
            ++r;
        }
    }
}

