/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Size;
import pencilbox.common.io.PzprReaderBase;
import pencilbox.kakuro.Board;

public class PzprReader
extends PzprReaderBase {
    private Board bd;

    protected BoardBase makeBoard() {
        this.bd = new Board();
        this.bd.setSize(this.rows, this.cols);
        return this.bd;
    }

    protected void pzlimport() {
        this.bd.setSize(new Size(this.rows + 1, this.cols + 1));
        this.decodeKakuro();
    }

    protected void decodeKakuro() {
        char ca;
        int cell = 0;
        int a = 0;
        String bstr = this.outbstr;
        int i = 0;
        while (i < bstr.length()) {
            ca = bstr.charAt(i);
            if (ca >= 'k' && ca <= 'z') {
                cell += PzprReader.parseInt(ca, 36) - 19;
            } else {
                this.sQuC(cell, 51);
                if (ca != '.') {
                    this.sDiC(cell, this.decval(ca));
                    this.sQnC(cell, this.decval(bstr.charAt(i + 1)));
                    ++i;
                }
                ++cell;
            }
            if (cell >= this.rows * this.cols) {
                a = i + 1;
                break;
            }
            ++i;
        }
        cell = 0;
        i = a;
        while (i < bstr.length()) {
            ca = bstr.charAt(i);
            while (cell < this.cols) {
                if (this.QuC(this.cnum(cell, 0)) != 51) {
                    this.sDiE(cell, this.decval(ca));
                    ++cell;
                    ++i;
                    break;
                }
                ++cell;
            }
            if (cell >= this.cols) {
                a = i;
                break;
            }
            --i;
            ++i;
        }
        i = a;
        while (i < bstr.length()) {
            ca = bstr.charAt(i);
            while (cell < this.cols + this.rows) {
                if (this.QuC(this.cnum(0, cell - this.cols)) != 51) {
                    this.sQnE(cell, this.decval(ca));
                    ++cell;
                    ++i;
                    break;
                }
                ++cell;
            }
            if (cell >= this.cols + this.rows) {
                a = i;
                break;
            }
            --i;
            ++i;
        }
        this.outbstr(bstr, a);
    }

    private int decval(char ca) {
        if (ca >= '0' && ca <= '9') {
            return PzprReader.parseInt(ca, 36);
        }
        if (ca >= 'a' && ca <= 'j') {
            return PzprReader.parseInt(ca, 36);
        }
        if (ca >= 'A' && ca <= 'Z') {
            return PzprReader.parseInt(ca, 36) + 10;
        }
        return -1;
    }

    public int cnum(int cx, int cy) {
        return cx >= 0 && cx <= this.cols - 1 && cy >= 0 && cy <= this.rows - 1 ? cx + cy * this.cols : -1;
    }

    public int QuC(int i) {
        if (this.bd.isWall(this.i2aKK(i))) {
            return 51;
        }
        return -1;
    }

    protected void sQuC(int i, int n) {
        if (n == 51) {
            this.bd.setWall(this.i2aKK(i), 0, 0);
        }
    }

    protected void sQnC(int i, int n) {
        this.bd.setSum(this.i2aKK(i), 1, n);
    }

    protected void sDiC(int i, int n) {
        this.bd.setSum(this.i2aKK(i), 0, n);
    }

    public void sQnE(int i, int n) {
        if (i >= 0 && i < this.cols) {
            this.bd.setSum(Address.address(0, i + 1), 1, n);
        } else if (i >= this.cols && i < this.cols + this.rows) {
            this.bd.setSum(Address.address(i - this.cols + 1, 0), 1, n);
        }
    }

    public void sDiE(int i, int n) {
        if (i >= 0 && i < this.cols) {
            this.bd.setSum(Address.address(0, i + 1), 0, n);
        } else if (i >= this.cols && i < this.cols + this.rows) {
            this.bd.setSum(Address.address(i - this.cols + 1, 0), 0, n);
        }
    }

    protected Address i2aKK(int i) {
        return Address.address(i / this.cols + 1, i % this.cols + 1);
    }
}

