/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellNumberEditStep;
import pencilbox.kakuro.DigitPatternHint;
import pencilbox.kakuro.Word;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int HORIZ = 1;
    static final int VERT = 0;
    static final int WALL = -1;
    static final int maxNumber = 9;
    private int[][] number;
    private int[][] sumH;
    private int[][] sumV;
    private Word[][] wordH;
    private Word[][] wordV;
    private int[][] multi;
    private DigitPatternHint hint;

    protected void setup() {
        super.setup();
        this.number = new int[this.rows()][this.cols()];
        this.sumH = new int[this.rows()][this.cols()];
        this.sumV = new int[this.rows()][this.cols()];
        int c = 0;
        while (c < this.cols()) {
            this.number[0][c] = -1;
            this.sumH[0][c] = 0;
            this.sumV[0][c] = 0;
            ++c;
        }
        int r = 1;
        while (r < this.rows()) {
            this.number[r][0] = -1;
            this.sumH[r][0] = 0;
            this.sumV[r][0] = 0;
            ++r;
        }
        this.wordH = new Word[this.rows()][this.cols()];
        this.wordV = new Word[this.rows()][this.cols()];
        this.multi = new int[this.rows()][this.cols()];
        this.hint = new DigitPatternHint();
        this.hint.setupHint(this);
    }

    public void clearBoard() {
        int c;
        super.clearBoard();
        int r = 1;
        while (r < this.rows()) {
            c = 1;
            while (c < this.cols()) {
                if (!this.isWall(r, c)) {
                    this.number[r][c] = 0;
                }
                ++c;
            }
            ++r;
        }
        ArrayUtil.initArrayInt2(this.multi, 0);
        r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.getSumH(r, c) > 0) {
                    this.wordH[r][c].clear();
                }
                if (this.getSumV(r, c) > 0) {
                    this.wordV[r][c].clear();
                }
                ++c;
            }
            ++r;
        }
        this.initHint();
    }

    int[][] getSumH() {
        return this.sumH;
    }

    int[][] getSumV() {
        return this.sumV;
    }

    int[][] getNumber() {
        return this.number;
    }

    int getMaxNumber() {
        return 9;
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public boolean isWall(int r, int c) {
        if (!this.isOn(r, c)) {
            return true;
        }
        return this.number[r][c] == -1;
    }

    public boolean isWall(Address pos) {
        return this.isWall(pos.r(), pos.c());
    }

    public boolean isUnknown(int r, int c) {
        return this.number[r][c] == 0;
    }

    public int getSumV(int r, int c) {
        return this.sumV[r][c];
    }

    public int getSumH(int r, int c) {
        return this.sumH[r][c];
    }

    public int getSum(Address p, int dir) {
        if (dir == 0) {
            return this.sumV[p.r()][p.c()];
        }
        if (dir == 1) {
            return this.sumH[p.r()][p.c()];
        }
        return 0;
    }

    public void setSumV(int r, int c, int n) {
        this.number[r][c] = -1;
        this.sumV[r][c] = n;
    }

    public void setSumH(int r, int c, int n) {
        this.number[r][c] = -1;
        this.sumH[r][c] = n;
    }

    public void setSum(Address pos, int dir, int n) {
        if (dir == 0) {
            this.setSumV(pos.r(), pos.c(), n);
        }
        if (dir == 1) {
            this.setSumH(pos.r(), pos.c(), n);
        }
    }

    public void setWall(int r, int c, int a, int b) {
        this.number[r][c] = -1;
        this.sumH[r][c] = a;
        this.sumV[r][c] = b;
    }

    public void setWall(Address pos, int a, int b) {
        this.setWall(pos.r(), pos.c(), a, b);
    }

    public void removeWall(int r, int c) {
        this.number[r][c] = 0;
        this.sumH[r][c] = 0;
        this.sumV[r][c] = 0;
    }

    public void removeWall(Address pos) {
        this.removeWall(pos.r(), pos.c());
    }

    public void initBoard() {
        this.initWord();
        this.initMulti();
        this.initHint();
    }

    void initWord() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getNumber(r, c) == -1) {
                    Word word;
                    int cc = c + 1;
                    while (this.isOn(r, cc) && this.getNumber(r, cc) != -1) {
                        ++cc;
                    }
                    this.wordH[r][c] = word = new Word(r, c, cc - c - 1, this.getSumH(r, c));
                    cc = c + 1;
                    while (this.isOn(r, cc) && this.getNumber(r, cc) != -1) {
                        this.wordH[r][cc] = word;
                        if (this.getNumber(r, cc) > 0) {
                            word.addNumber(this.getNumber(r, cc));
                        }
                        ++cc;
                    }
                    int rr = r + 1;
                    while (this.isOn(rr, c) && this.getNumber(rr, c) != -1) {
                        ++rr;
                    }
                    this.wordV[r][c] = word = new Word(r, c, rr - r - 1, this.getSumV(r, c));
                    rr = r + 1;
                    while (this.isOn(rr, c) && this.getNumber(rr, c) != -1) {
                        this.wordV[rr][c] = word;
                        if (this.getNumber(rr, c) > 0) {
                            word.addNumber(this.getNumber(rr, c));
                        }
                        ++rr;
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    public boolean isMultipleNumber(int r, int c) {
        return this.multi[r][c] > 1;
    }

    public void changeNumber(int r, int c, int n) {
        this.wordH[r][c].changeNumber(this.getNumber(r, c), n);
        this.wordV[r][c].changeNumber(this.getNumber(r, c), n);
        this.updateMulti(r, c, n);
        this.setNumber(r, c, n);
        this.updateHint(r, c);
    }

    public void changeNumber(Address pos, int n) {
        this.changeNumber(pos.r(), pos.c(), n);
    }

    public void enterNumberA(Address pos, int n) {
        if (n < 0 || n > 9) {
            return;
        }
        if (n == this.getNumber(pos)) {
            return;
        }
        this.fireUndoableEditUpdate(new CellNumberEditStep(pos, this.getNumber(pos), n));
        this.changeNumber(pos, n);
    }

    public void undo(AbstractStep step) {
        CellNumberEditStep s = (CellNumberEditStep)step;
        this.changeNumber(s.getPos(), s.getBefore());
    }

    public void redo(AbstractStep step) {
        CellNumberEditStep s = (CellNumberEditStep)step;
        this.changeNumber(s.getPos(), s.getAfter());
    }

    void initMulti() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getNumber(r, c) > 0) {
                    this.initMulti1(r, c, this.getNumber(r, c));
                }
                ++c;
            }
            ++r;
        }
    }

    private void initMulti1(int r0, int c0, int num) {
        this.multi[r0][c0] = 1;
        int c = this.getWordHead(r0, c0, 1) + 1;
        int i = 0;
        while (i < this.getWordSize(r0, c0, 1)) {
            if (c != c0 && this.getNumber(r0, c) == num) {
                int[] nArray = this.multi[r0];
                int n = c0;
                nArray[n] = nArray[n] + 1;
            }
            ++c;
            ++i;
        }
        int r = this.getWordHead(r0, c0, 0) + 1;
        int j = 0;
        while (j < this.getWordSize(r0, c0, 0)) {
            if (r != r0 && this.getNumber(r, c0) == num) {
                int[] nArray = this.multi[r0];
                int n = c0;
                nArray[n] = nArray[n] + 1;
            }
            ++r;
            ++j;
        }
    }

    void updateMulti(int r0, int c0, int num) {
        int j;
        int r;
        int i;
        int c;
        int prevNum = this.getNumber(r0, c0);
        if (prevNum == num) {
            return;
        }
        if (this.multi[r0][c0] > 1) {
            c = this.getWordHead(r0, c0, 1) + 1;
            i = 0;
            while (i < this.getWordSize(r0, c0, 1)) {
                if (c != c0 && this.getNumber(r0, c) == prevNum) {
                    int[] nArray = this.multi[r0];
                    int n = c;
                    nArray[n] = nArray[n] - 1;
                }
                ++c;
                ++i;
            }
            r = this.getWordHead(r0, c0, 0) + 1;
            j = 0;
            while (j < this.getWordSize(r0, c0, 0)) {
                if (r != r0 && this.getNumber(r, c0) == prevNum) {
                    int[] nArray = this.multi[r];
                    int n = c0;
                    nArray[n] = nArray[n] - 1;
                }
                ++r;
                ++j;
            }
        }
        if (num == 0) {
            this.multi[r0][c0] = 0;
        } else if (num > 0) {
            this.multi[r0][c0] = 1;
            c = this.getWordHead(r0, c0, 1) + 1;
            i = 0;
            while (i < this.getWordSize(r0, c0, 1)) {
                if (c != c0 && this.getNumber(r0, c) == num) {
                    int[] nArray = this.multi[r0];
                    int n = c;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray2 = this.multi[r0];
                    int n2 = c0;
                    nArray2[n2] = nArray2[n2] + 1;
                }
                ++c;
                ++i;
            }
            r = this.getWordHead(r0, c0, 0) + 1;
            j = 0;
            while (j < this.getWordSize(r0, c0, 0)) {
                if (r != r0 && this.getNumber(r, c0) == num) {
                    int[] nArray = this.multi[r];
                    int n = c0;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray3 = this.multi[r0];
                    int n3 = c0;
                    nArray3[n3] = nArray3[n3] + 1;
                }
                ++r;
                ++j;
            }
        }
    }

    public int checkAnswerCode() {
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (!this.isWall(r, c)) {
                    if (this.isUnknown(r, c)) {
                        result |= 1;
                    } else if (this.isMultipleNumber(r, c)) {
                        result |= 2;
                    }
                } else if (this.isWall(r, c)) {
                    if (this.getSumH(r, c) > 0 && this.wordH[r][c].getStatus() == -1) {
                        result |= 4;
                    }
                    if (this.getSumV(r, c) > 0 && this.wordV[r][c].getStatus() == -1) {
                        result |= 4;
                    }
                }
                ++c;
            }
            ++r;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        if (result == 1) {
            return Messages.getString("kakuro.AnswerCheckMessage1");
        }
        StringBuffer message = new StringBuffer();
        if ((result & 2) == 2) {
            message.append(Messages.getString("kakuro.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("kakuro.AnswerCheckMessage3"));
        }
        return message.toString();
    }

    void initHint() {
        this.hint.initHint();
    }

    protected void updateHint(int r, int c) {
        this.hint.updatePattern(r, c);
    }

    int getPattern(int r, int c) {
        return this.hint.getPattern(r, c);
    }

    int getWordSize(int r, int c, int dir) {
        if (dir == 1) {
            return this.wordH[r][c].getSize();
        }
        if (dir == 0) {
            return this.wordV[r][c].getSize();
        }
        return 0;
    }

    int getWordHead(int r, int c, int dir) {
        if (dir == 1) {
            return this.wordH[r][c].getHead().c();
        }
        if (dir == 0) {
            return this.wordV[r][c].getHead().r();
        }
        return 0;
    }

    int getWordSum(int r, int c, int dir) {
        if (dir == 1) {
            return this.wordH[r][c].getSum();
        }
        if (dir == 0) {
            return this.wordV[r][c].getSum();
        }
        return 0;
    }

    int getWordStatus(int r, int c, int dir) {
        if (dir == 1) {
            return this.wordH[r][c].getStatus();
        }
        if (dir == 0) {
            return this.wordV[r][c].getStatus();
        }
        return 0;
    }
}

