/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.masyu;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.masyu.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = -9;

    public PanelEventHandler() {
        this.setMaxInputNumber(2);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftPressedEdge(SideAddress side) {
    }

    protected void rightPressedEdge(SideAddress side) {
        this.toggleState(side, -1);
    }

    protected void leftDragged(Address dragStart, Address dragEnd) {
        this.changeLineState(dragStart, dragEnd, 1);
    }

    protected void leftReleased(Address pos) {
        this.currentState = -9;
    }

    private void toggleState(SideAddress pos, int st) {
        if (st == this.board.getState(pos)) {
            st = 0;
        }
        this.board.changeStateA(pos, st);
    }

    private void changeLineState(Address pos0, Address pos1, int st) {
        int direction = pos0.getDirectionTo(pos1);
        if (direction < 0) {
            return;
        }
        SideAddress side = SideAddress.get(pos0, direction);
        if (this.currentState == -9) {
            this.currentState = this.board.getState(side) == st ? 0 : st;
        }
        Address p = pos0;
        while (!p.equals(pos1)) {
            side = SideAddress.get(p, direction);
            if (this.board.getState(side) != this.currentState) {
                this.board.changeStateA(side, this.currentState);
            }
            p = p.nextCell(direction);
        }
    }

    protected void numberEntered(Address pos, int n) {
        if (this.isProblemEditMode() && (n == 1 || n == 2)) {
            Address posS;
            this.board.setNumber(pos, n);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, 3);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos, 0);
            if (this.isSymmetricPlacementMode() && this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, 0);
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos, 3);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, 3);
            }
        }
    }
}

