/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.goishi;

import pencilbox.common.io.PzprWriterBase;
import pencilbox.goishi.Board;
import pencilbox.goishi.BoardSize;

public class PzprWriter
extends PzprWriterBase {
    private Board bd;
    private boolean fitsize = false;
    private int bdpadding = 1;

    protected String getPzprName() {
        return "goishi";
    }

    protected void pzlexport() {
        this.bd = (Board)this.boardBase;
        this.outSize(this.bd.rows(), this.bd.cols());
        this.encodeGoishi();
    }

    protected void encodeGoishi() {
        BoardSize d = this.fitsize ? this.getSizeOfBoard_goishi() : new BoardSize(0, 0, this.cols - 1, this.rows - 1);
        String cm = "";
        int count = 0;
        int pass = 0;
        int cy = d.y1;
        while (cy <= d.y2) {
            int cx = d.x1;
            while (cx <= d.x2) {
                if (!this.bd.isOn(cy, cx) || this.bd.getState(cy, cx) == 0) {
                    pass += 1 << 4 - count;
                }
                if (++count == 5) {
                    cm = String.valueOf(cm) + PzprWriter.toString(pass, 32);
                    count = 0;
                    pass = 0;
                }
                ++cx;
            }
            ++cy;
        }
        if (count > 0) {
            cm = String.valueOf(cm) + PzprWriter.toString(pass, 32);
        }
        this.outbstr(cm);
        this.outSize(d.y2 - d.y1 + 1, d.x2 - d.x1 + 1);
    }

    protected BoardSize getSizeOfBoard_goishi() {
        int x1 = 9999;
        int x2 = -1;
        int y1 = 9999;
        int y2 = -1;
        int count = 0;
        int c = 0;
        while (c < this.rows * this.cols) {
            if (this.QuC(c) == 7) {
                if (x1 > c % this.cols) {
                    x1 = c % this.cols;
                }
                if (x2 < c % this.cols) {
                    x2 = c % this.cols;
                }
                if (y1 > c / this.cols) {
                    y1 = c / this.cols;
                }
                if (y2 < c / this.cols) {
                    y2 = c / this.cols;
                }
                ++count;
            }
            ++c;
        }
        if (count == 0) {
            return new BoardSize(0, 0, 1, 1);
        }
        int e = this.bdpadding > 0 ? this.bdpadding : 0;
        return new BoardSize(x1 - e, y1 - e, x2 + e, y2 + e);
    }

    protected int QuC(int i) {
        if (i < 0 || this.cols * this.rows <= i) {
            return 0;
        }
        int n = this.bd.getState(this.i2a(i));
        if (n == -1) {
            return 7;
        }
        return 0;
    }
}

