/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hakyukoka;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.hakyukoka.Area;
import pencilbox.hakyukoka.Board;
import pencilbox.hakyukoka.Panel;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(9);
    }

    protected int getMaxInputNumber() {
        Address pos = this.getCellCursor().getPosition();
        Area area = this.board.getArea(pos);
        if (area != null) {
            int n = area.size();
            if (n > 9) {
                return n;
            }
            return 9;
        }
        return 9;
    }

    private void setSelectedNumber(int n) {
        ((Panel)this.getPanel()).setSelectedNumber(n);
    }

    Area getDraggingArea() {
        return ((Panel)this.getPanel()).getDraggingArea();
    }

    void setDraggingArea(Area draggingArea) {
        ((Panel)this.getPanel()).setDraggingArea(draggingArea);
    }

    protected void leftPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Area area = this.board.getArea(pos);
            if (area == null) {
                area = new Area();
                this.board.addCellToArea(pos, area);
            }
            this.setDraggingArea(area);
        } else {
            if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos))) {
                int n = this.board.getNumber(pos);
                if (n >= this.getMaxInputNumber()) {
                    this.board.enterNumberA(pos, 0);
                } else if (n >= 0) {
                    this.board.enterNumberA(pos, n + 1);
                }
            }
            this.setSelectedNumber(this.board.getNumber(pos));
        }
    }

    protected void leftDragged(Address pos) {
        if (this.isProblemEditMode()) {
            Area draggingArea = this.getDraggingArea();
            if (draggingArea == null) {
                return;
            }
            Area oldArea = this.board.getArea(pos);
            if (oldArea != null && oldArea != draggingArea) {
                this.board.removeCellFromArea(pos, oldArea);
                this.board.addCellToArea(pos, draggingArea);
            } else if ((oldArea == null || oldArea != draggingArea) && oldArea == null) {
                this.board.addCellToArea(pos, draggingArea);
            }
        }
    }

    protected void rightPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Area oldArea = this.board.getArea(pos);
            if (oldArea != null) {
                this.board.removeCellFromArea(pos, oldArea);
            }
        } else {
            int n;
            if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos) || (n = this.board.getNumber(pos)) <= 0)) {
                this.board.enterNumberA(pos, n - 1);
            }
            this.setSelectedNumber(this.board.getNumber(pos));
        }
    }

    protected void rightDragged(Address pos) {
        if (this.isProblemEditMode()) {
            this.rightPressed(pos);
        }
    }

    protected void leftReleased(Address dragEnd) {
        this.setDraggingArea(null);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos, num);
            this.board.setState(pos, 1);
            if (this.isSymmetricPlacementMode() && !this.board.isStable(posS = this.getSymmetricPosition(pos))) {
                this.board.setState(posS, 1);
                this.board.changeNumber(posS, 0);
            }
        } else if (this.isCursorOn() && num >= 0 && !this.board.isStable(pos)) {
            this.board.enterNumberA(pos, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos, 0);
            this.board.setState(pos, 0);
            if (this.isSymmetricPlacementMode() && this.board.isStable(posS = this.getSymmetricPosition(pos))) {
                this.board.setState(posS, 0);
                this.board.changeNumber(posS, 0);
            }
        } else if (this.isCursorOn() && !this.board.isStable(pos)) {
            this.board.enterNumberA(pos, 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos, 0);
            this.board.setState(pos, 1);
            if (this.isSymmetricPlacementMode() && !this.board.isStable(posS = this.getSymmetricPosition(pos))) {
                this.board.setState(posS, 1);
                this.board.changeNumber(posS, 0);
            }
        }
    }
}

