/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hakyukoka;

import java.util.ArrayList;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator;
import pencilbox.hakyukoka.Area;
import pencilbox.hakyukoka.Board;

public class BoardCopier
extends BoardCopierBase {
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Board s = (Board)src;
        Board d = (Board)dst;
        Rotator rotator = new Rotator(src.getSize(), n);
        rotator.rotateArrayInt2(s.getState(), d.getState());
        rotator.rotateArrayInt2(s.getNumber(), d.getNumber());
        for (Area srcArea : s.getAreaList()) {
            Area a = new Area();
            rotator.rotateArea(srcArea, a);
            if (!d.isAreaOn(a)) continue;
            d.addArea(a);
        }
    }

    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, pencilbox.common.core.Area region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        ArrayList<Area> srcAreaList = new ArrayList<Area>();
        Area srcArea = null;
        Area dstArea = null;
        for (Address s : region) {
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d)) continue;
            board.setState(d, srcBoard.getState(s));
            board.setNumber(d, srcBoard.getNumber(s));
            srcArea = srcBoard.getArea(s);
            if (srcArea == null || srcAreaList.contains(srcArea) || !region.containsAll(srcArea)) continue;
            srcAreaList.add(srcArea);
            dstArea = new Area();
            for (Address ss : srcArea) {
                Address dd;
                if (!region.contains(ss) || !board.isOn(dd = this.translateAndRotateAddress(ss, from, to, rotation))) continue;
                dstArea.add(dd);
            }
            if (dstArea.size() < srcArea.size()) continue;
            for (Address dd : dstArea) {
                if (board.getArea(dd) == null) continue;
                board.removeArea(board.getArea(dd));
            }
            board.addArea(dstArea);
        }
    }

    public void eraseRegion(BoardBase boardBase, pencilbox.common.core.Area region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            board.setState(s, 0);
            board.setNumber(s, 0);
            Area srcArea = board.getArea(s);
            if (srcArea == null || !region.containsAll(srcArea)) continue;
            board.removeCellFromArea(s, srcArea);
        }
    }
}

