/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hitori;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.hitori.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = 0;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(this.board.getMaxNumber());
    }

    protected void leftPressed(Address pos) {
        this.toggleState(pos, -2);
        this.currentState = this.board.getState(pos);
    }

    protected void rightPressed(Address pos) {
        this.toggleState(pos, -1);
        this.currentState = this.board.getState(pos);
    }

    protected void leftDragged(Address pos) {
        this.sweepState(pos);
    }

    protected void rightDragged(Address pos) {
        this.sweepState(pos);
    }

    private void toggleState(Address pos, int st) {
        if (st == this.board.getState(pos)) {
            st = 0;
        }
        this.board.changeStateA(pos, st);
    }

    private void sweepState(Address pos) {
        int st = this.board.getState(pos);
        if (this.currentState == st) {
            return;
        }
        if (this.currentState == -2 && this.board.isBlock(pos)) {
            return;
        }
        if (this.currentState == -1 && st == -2) {
            return;
        }
        this.board.changeStateA(pos, this.currentState);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num > 0) {
            this.board.setNumber(pos, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.setNumber(pos, 0);
        }
    }
}

