/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hitori;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator;
import pencilbox.hitori.Board;

public class BoardCopier
extends BoardCopierBase {
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Board s = (Board)src;
        Board d = (Board)dst;
        Rotator rotator = new Rotator(src.getSize(), n);
        rotator.rotateArrayInt2(s.getState(), d.getState());
        rotator.rotateArrayInt2(s.getNumber(), d.getNumber());
        int r = 0;
        while (r < d.rows()) {
            int c = 0;
            while (c < d.cols()) {
                if (d.getNumber(r, c) > d.getMaxNumber()) {
                    d.setNumber(r, c, 0);
                }
                ++c;
            }
            ++r;
        }
    }

    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, Area region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        for (Address s : region) {
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d)) continue;
            board.setState(d, srcBoard.getState(s));
            board.setNumber(d, srcBoard.getNumber(s));
        }
    }

    public void eraseRegion(BoardBase boardBase, Area region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            board.setState(s, 0);
            board.setNumber(s, 0);
        }
    }
}

