/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.nurikabe;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.nurikabe.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = 0;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftPressed(Address pos) {
        if (!this.isProblemEditMode()) {
            this.toggleState(pos, -2);
            this.currentState = this.board.isNumber(pos) ? -2 : this.board.getState(pos);
        }
    }

    protected void rightPressed(Address pos) {
        if (!this.isProblemEditMode()) {
            this.toggleState(pos, -1);
            this.currentState = this.board.isNumber(pos) ? -1 : this.board.getState(pos);
        }
    }

    protected void leftDragged(Address dragStart, Address pos) {
        if (this.isProblemEditMode()) {
            int number;
            if (this.isOn(dragStart) && ((number = this.board.getState(dragStart)) > 0 || number == -3)) {
                this.board.changeState(dragStart, 0);
                this.board.changeState(pos, number);
            }
        } else {
            this.sweepState(pos);
        }
    }

    protected void rightDragged(Address dragStart, Address pos) {
        if (!this.isProblemEditMode()) {
            this.sweepState(pos);
        }
    }

    private void toggleState(Address pos, int st) {
        if (this.board.isNumber(pos)) {
            return;
        }
        if (st == this.board.getState(pos)) {
            st = 0;
        }
        this.board.changeStateA(pos, st);
    }

    private void sweepState(Address pos) {
        if (this.board.isNumber(pos)) {
            return;
        }
        if (this.currentState == this.board.getState(pos)) {
            return;
        }
        this.board.changeStateA(pos, this.currentState);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num > 0) {
            Address posS;
            this.board.changeState(pos, num);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.changeState(posS, -3);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos, 0);
            if (this.isSymmetricPlacementMode() && this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.changeState(posS, 0);
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos, -3);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.changeState(posS, -3);
            }
        }
    }
}

