/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.nurikabe;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.nurikabe.Area;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    public static final int SPACE = -1;
    public static final int WALL = -2;
    public static final int UNKNOWN = 0;
    public static final int UNDECIDED_NUMBER = -3;
    private int[][] state;
    private Area[][] area;
    private Area[][] whiteArea;
    private List<Area> wallAreaList;
    private List<Area> spaceAreaList;
    private Area initializingArea;

    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.area = new Area[this.rows()][this.cols()];
        this.whiteArea = new Area[this.rows()][this.cols()];
        this.wallAreaList = new LinkedList<Area>();
        this.spaceAreaList = new LinkedList<Area>();
    }

    public void clearBoard() {
        super.clearBoard();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (!this.isNumber(r, c)) {
                    this.state[r][c] = 0;
                }
                ++c;
            }
            ++r;
        }
        this.initBoard();
    }

    public void trimAnswer() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.state[r][c] == -1) {
                    this.state[r][c] = 0;
                }
                ++c;
            }
            ++r;
        }
        this.initBoard();
    }

    int[][] getState() {
        return this.state;
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public boolean isNumber(int r, int c) {
        return this.isOn(r, c) && (this.state[r][c] > 0 || this.state[r][c] == -3);
    }

    public boolean isNumber(Address pos) {
        return this.isNumber(pos.r(), pos.c());
    }

    public boolean isWall(int r, int c) {
        return this.isOn(r, c) && this.state[r][c] == -2;
    }

    public boolean isUnknown(int r, int c) {
        return this.state[r][c] == 0;
    }

    public int getSpaceOrWall(int r, int c) {
        if (this.state[r][c] > 0) {
            return -1;
        }
        if (this.state[r][c] == -3) {
            return -1;
        }
        return this.state[r][c];
    }

    public boolean isSpaceOrNumber(int r, int c) {
        return this.isOn(r, c) && (this.state[r][c] > 0 || this.state[r][c] == -1 || this.state[r][c] == -3);
    }

    public void initBoard() {
        this.initAreas();
    }

    public void initAreas() {
        ArrayUtil.initArrayObject2(this.area, null);
        this.wallAreaList.clear();
        this.spaceAreaList.clear();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getState(r, c) != 0 && this.area[r][c] == null) {
                    this.initArea(r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    void initArea(int r, int c) {
        this.initializingArea = this.makeNewArea(r, c);
        this.initArea1(r, c);
    }

    private void initArea1(int r, int c) {
        if (!this.isOn(r, c)) {
            return;
        }
        if (this.getArea(r, c) == this.initializingArea) {
            return;
        }
        if (this.getSpaceOrWall(r, c) != this.initializingArea.getAreaType()) {
            return;
        }
        this.initializingArea.add(r, c);
        if (this.isNumber(r, c)) {
            this.initializingArea.addNumber(this.getState(r, c));
        }
        this.setArea(r, c, this.initializingArea);
        this.initArea1(r - 1, c);
        this.initArea1(r, c - 1);
        this.initArea1(r + 1, c);
        this.initArea1(r, c + 1);
    }

    public Area getArea(int r, int c) {
        if (!this.isOn(r, c)) {
            return null;
        }
        return this.area[r][c];
    }

    public void setArea(int r, int c, Area a) {
        this.area[r][c] = a;
    }

    public void changeState(int r, int c, int st) {
        int prevSt = this.getSpaceOrWall(r, c);
        this.setState(r, c, st);
        int type = st > 0 ? -1 : st;
        if (prevSt != 0) {
            this.splitArea(r, c, prevSt);
        }
        if (st != 0) {
            this.mergeArea(r, c, type);
        }
    }

    public void changeState(Address pos, int st) {
        this.changeState(pos.r(), pos.c(), st);
    }

    public void changeStateA(Address pos, int st) {
        this.fireUndoableEditUpdate(new CellEditStep(pos, this.getState(pos), st));
        this.changeState(pos, st);
    }

    public void undo(AbstractStep step) {
        CellEditStep s = (CellEditStep)step;
        this.changeState(s.getPos(), s.getBefore());
    }

    public void redo(AbstractStep step) {
        CellEditStep s = (CellEditStep)step;
        this.changeState(s.getPos(), s.getAfter());
    }

    void mergeArea(int r, int c, int type) {
        Area mergedArea = null;
        mergedArea = this.mergeArea1(this.getArea(r - 1, c), mergedArea, type);
        mergedArea = this.mergeArea1(this.getArea(r, c - 1), mergedArea, type);
        mergedArea = this.mergeArea1(this.getArea(r + 1, c), mergedArea, type);
        mergedArea = this.mergeArea1(this.getArea(r, c + 1), mergedArea, type);
        if (mergedArea == null) {
            mergedArea = this.makeNewArea(r, c);
        }
        mergedArea.add(r, c);
        if (this.isNumber(r, c)) {
            mergedArea.addNumber(this.getState(r, c));
        }
        this.setArea(r, c, mergedArea);
    }

    private Area mergeArea1(Area a, Area mergedArea, int type) {
        if (a != null && a.getAreaType() == type) {
            if (mergedArea == null) {
                mergedArea = a;
            } else if (mergedArea != a) {
                mergedArea.addAll(a);
                for (Address pos : a) {
                    this.setArea(pos.r(), pos.c(), mergedArea);
                    if (!this.isNumber(pos.r(), pos.c())) continue;
                    mergedArea.addNumber(this.getState(pos.r(), pos.c()));
                }
                this.removeAreaFromList(a);
            }
        }
        return mergedArea;
    }

    void splitArea(int r, int c, int type) {
        Area oldArea = this.getArea(r, c);
        Area largerArea = null;
        this.removeAreaFromList(oldArea);
        for (Address pos : oldArea) {
            this.setArea(pos.r(), pos.c(), null);
        }
        if (this.isOn(r - 1, c) && this.getSpaceOrWall(r - 1, c) == type && this.getArea(r - 1, c) == null) {
            this.initArea(r - 1, c);
            if (largerArea == null || this.initializingArea.size() > largerArea.size()) {
                largerArea = this.initializingArea;
            }
        }
        if (this.isOn(r, c - 1) && this.getSpaceOrWall(r, c - 1) == type && this.getArea(r, c - 1) == null) {
            this.initArea(r, c - 1);
            if (largerArea == null || this.initializingArea.size() > largerArea.size()) {
                largerArea = this.initializingArea;
            }
        }
        if (this.isOn(r + 1, c) && this.getSpaceOrWall(r + 1, c) == type && this.getArea(r + 1, c) == null) {
            this.initArea(r + 1, c);
            if (largerArea == null || this.initializingArea.size() > largerArea.size()) {
                largerArea = this.initializingArea;
            }
        }
        if (this.isOn(r, c + 1) && this.getSpaceOrWall(r, c + 1) == type && this.getArea(r, c + 1) == null) {
            this.initArea(r, c + 1);
            if (largerArea == null || this.initializingArea.size() > largerArea.size()) {
                largerArea = this.initializingArea;
            }
        }
        if (largerArea != null) {
            largerArea.setId(oldArea.getId());
        }
    }

    private Area makeNewArea(int r, int c) {
        if (this.isWall(r, c)) {
            Area a = new Area(-2);
            this.wallAreaList.add(a);
            return a;
        }
        if (this.isSpaceOrNumber(r, c)) {
            Area a = new Area(-1);
            this.spaceAreaList.add(a);
            return a;
        }
        return null;
    }

    private void removeAreaFromList(Area a) {
        int type = a.getAreaType();
        if (type == -2) {
            this.wallAreaList.remove(a);
        } else if (type == -1) {
            this.spaceAreaList.remove(a);
        }
    }

    boolean is2x2Block(int r, int c) {
        if (this.isWall(r, c)) {
            if (this.isWall(r - 1, c)) {
                if (this.isWall(r, c - 1) && this.isWall(r - 1, c - 1)) {
                    return true;
                }
                if (this.isWall(r, c + 1) && this.isWall(r - 1, c + 1)) {
                    return true;
                }
            }
            if (this.isWall(r + 1, c)) {
                if (this.isWall(r, c - 1) && this.isWall(r + 1, c - 1)) {
                    return true;
                }
                if (this.isWall(r, c + 1) && this.isWall(r + 1, c + 1)) {
                    return true;
                }
            }
        }
        return false;
    }

    public int checkAnswerCode() {
        int result = 0;
        int r = this.rows() - 1;
        while (r >= 0) {
            int c = this.cols() - 1;
            while (c >= 0) {
                if (this.is2x2Block(r, c)) {
                    result |= 0x40;
                }
                --c;
            }
            --r;
        }
        if (this.wallAreaList.size() > 1) {
            result |= 0x20;
        }
        return result |= this.checkWhiteAreas();
    }

    private int checkWhiteAreas() {
        ArrayUtil.initArrayObject2(this.whiteArea, null);
        int ret = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getState(r, c) != -2 && this.whiteArea[r][c] == null) {
                    this.initializingArea = new Area(-1);
                    this.initWhiteArea1(r, c);
                    ret |= this.checkSpaceArea(this.initializingArea);
                }
                ++c;
            }
            ++r;
        }
        return ret;
    }

    private int checkSpaceArea(Area a) {
        int ret = 0;
        int number = a.getNumber();
        if (number == 0) {
            ret |= 0x10;
        } else if (number == Area.MULTIPLE_NUMBER) {
            ret |= 8;
        } else if (number != -3 && number > 0) {
            if (a.size() < number) {
                ret |= 4;
            } else if (a.size() > number) {
                ret |= 2;
            }
        }
        return ret;
    }

    private void initWhiteArea1(int r, int c) {
        if (!this.isOn(r, c)) {
            return;
        }
        if (this.whiteArea[r][c] == this.initializingArea) {
            return;
        }
        if (this.getState(r, c) == -2) {
            return;
        }
        this.initializingArea.add(r, c);
        if (this.isNumber(r, c)) {
            this.initializingArea.addNumber(this.getState(r, c));
        }
        this.whiteArea[r][c] = this.initializingArea;
        this.initWhiteArea1(r - 1, c);
        this.initWhiteArea1(r, c - 1);
        this.initWhiteArea1(r + 1, c);
        this.initWhiteArea1(r, c + 1);
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        if (result == 1) {
            return Messages.getString("nurikabe.AnswerCheckMessage1");
        }
        StringBuffer message = new StringBuffer();
        if ((result & 2) == 2 || (result & 4) == 4) {
            message.append(Messages.getString("nurikabe.AnswerCheckMessage2"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("nurikabe.AnswerCheckMessage4"));
        }
        if ((result & 0x10) == 16) {
            message.append(Messages.getString("nurikabe.AnswerCheckMessage5"));
        }
        if ((result & 0x20) == 32) {
            message.append(Messages.getString("nurikabe.AnswerCheckMessage6"));
        }
        if ((result & 0x40) == 64) {
            message.append(Messages.getString("nurikabe.AnswerCheckMessage7"));
        }
        return message.toString();
    }
}

