/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator2;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.gui.EventHandlerManager;
import pencilbox.common.gui.PanelBase;

public class RegionEditHandler
implements KeyListener,
MouseListener,
MouseMotionListener {
    private PanelBase panel;
    private BoardBase board;
    private BoardCopierBase boardCopier;
    private EventHandlerManager eventHandlerManager;
    private Address oldPos = Address.address(-1, -1);
    private Area copyRegion;
    private Area pasteRegion;
    private Address copyRegionOrigin;
    private Address pasteRegionOrigin;
    private Address pivot = Address.address();
    private int pasteRotation;

    public void setup(PanelBase panel, BoardBase board, EventHandlerManager eventHandlerManager) {
        this.eventHandlerManager = eventHandlerManager;
        this.panel = panel;
        this.board = board;
        try {
            this.boardCopier = (BoardCopierBase)ClassUtil.createInstance(board.getClass(), "BoardCopier");
        }
        catch (PencilBoxClassException e) {
            this.boardCopier = new BoardCopierBase();
        }
        this.copyRegion = panel.getCopyRegion();
        this.pasteRegion = panel.getPasteRegion();
        this.pasteRotation = 0;
    }

    public void init() {
        this.copyRegion.clear();
        this.pasteRegion.clear();
        this.copyRegionOrigin = Address.nowhere();
        this.pasteRegionOrigin = Address.nowhere();
    }

    private boolean isMovingRegion() {
        return !this.pasteRegionOrigin.isNowhere();
    }

    public void repaint() {
        this.panel.repaint();
    }

    public boolean isOn(Address position) {
        return this.board.isOn(position);
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 47: 
            case 111: {
                this.slashKeyEntered();
                break;
            }
            case 32: 
            case 46: 
            case 110: {
                this.spaceKeyEntered();
                break;
            }
            case 48: 
            case 96: {
                this.numberKeyEntered(0);
                break;
            }
            case 49: 
            case 97: {
                this.numberKeyEntered(1);
                break;
            }
            case 50: 
            case 98: {
                this.numberKeyEntered(2);
                break;
            }
            case 51: 
            case 99: {
                this.numberKeyEntered(3);
                break;
            }
            case 52: 
            case 100: {
                this.numberKeyEntered(4);
                break;
            }
            case 53: 
            case 101: {
                this.numberKeyEntered(5);
                break;
            }
            case 54: 
            case 102: {
                this.numberKeyEntered(6);
                break;
            }
            case 55: 
            case 103: {
                this.numberKeyEntered(7);
            }
        }
        this.repaint();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    protected void numberKeyEntered(int number) {
        if (number >= 8) {
            return;
        }
        if (this.isMovingRegion()) {
            this.pasteRotation = Rotator2.combine(this.pasteRotation, number);
            this.updatePasteRegion();
        }
    }

    protected void spaceKeyEntered() {
        this.boardCopier.eraseRegion(this.board, this.copyRegion);
        this.board.initBoard();
    }

    protected void slashKeyEntered() {
        this.eventHandlerManager.setEditMode(PanelBase.PROBLEM_INPUT_MODE);
    }

    public void mousePressed(MouseEvent e) {
        boolean ctrl;
        Address newPos = this.panel.pointToAddress(e.getX(), e.getY());
        if (!this.isOn(newPos)) {
            return;
        }
        boolean shift = (e.getModifiersEx() & 0x40) != 0;
        boolean bl = ctrl = (e.getModifiersEx() & 0x80) != 0;
        if (e.getButton() == 1) {
            this.leftPressed(newPos, shift, ctrl);
        } else if (e.getButton() == 3) {
            this.rightPressed(newPos, shift, ctrl);
        }
        this.oldPos = newPos;
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        Address newPos = this.panel.pointToAddress(e.getX(), e.getY());
        if (!this.isOn(newPos)) {
            return;
        }
        if (newPos.equals(this.oldPos)) {
            return;
        }
        boolean shift = e.isShiftDown();
        if ((e.getModifiers() & 0x10) != 0) {
            this.leftDragged(newPos, shift);
        } else if ((e.getModifiers() & 4) != 0) {
            this.rightDragged(newPos);
        }
        this.oldPos = newPos;
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        boolean shift = e.isShiftDown();
        boolean ctrl = e.isControlDown();
        if (e.getButton() == 1) {
            this.leftReleased(shift, ctrl);
        }
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    protected void leftPressed(Address position, boolean shift, boolean ctrl) {
        if (this.copyRegion.contains(position)) {
            this.copyArea(this.copyRegion, this.pasteRegion);
            this.copyRegionOrigin = position;
            this.pasteRegionOrigin = position;
        } else {
            if (!ctrl) {
                this.copyRegion.clear();
            }
            this.copyRegion.add(position);
            this.pivot = position;
        }
    }

    protected void leftDragged(Address position, boolean shift) {
        if (this.isMovingRegion()) {
            this.pasteRegionOrigin = position;
            this.updatePasteRegion();
        } else if (shift) {
            this.selectRectangularArea(position);
        } else {
            this.copyRegion.add(position);
            this.pivot = position;
        }
    }

    private void selectRectangularArea(Address position) {
        int r0 = this.pivot.r() < position.r() ? this.pivot.r() : position.r();
        int r1 = this.pivot.r() < position.r() ? position.r() : this.pivot.r();
        int c0 = this.pivot.c() < position.c() ? this.pivot.c() : position.c();
        int c1 = this.pivot.c() < position.c() ? position.c() : this.pivot.c();
        int r = r0;
        while (r <= r1) {
            int c = c0;
            while (c <= c1) {
                this.copyRegion.add(Address.address(r, c));
                ++c;
            }
            ++r;
        }
    }

    protected void leftReleased(boolean shift, boolean ctrl) {
        if (this.isMovingRegion()) {
            if (ctrl) {
                this.boardCopier.copyRegion(this.board, this.copyRegion, this.copyRegionOrigin, this.pasteRegionOrigin, this.pasteRotation);
            } else {
                this.boardCopier.moveRegion(this.board, this.copyRegion, this.copyRegionOrigin, this.pasteRegionOrigin, this.pasteRotation);
            }
            this.board.initBoard();
            this.copyArea(this.pasteRegion, this.copyRegion);
            this.pasteRegion.clear();
            this.copyRegionOrigin = Address.nowhere();
            this.pasteRegionOrigin = Address.nowhere();
            this.pasteRotation = 0;
        }
    }

    protected void rightPressed(Address position, boolean shift, boolean ctrl) {
        if (ctrl) {
            this.copyRegion.remove(position);
        } else {
            this.copyRegion.clear();
            this.pasteRegion.clear();
            this.copyRegionOrigin = Address.nowhere();
            this.pasteRegionOrigin = Address.nowhere();
            this.pasteRotation = 0;
        }
    }

    protected void rightDragged(Address position) {
        this.copyRegion.remove(position);
    }

    private void copyArea(Area src, Area dst) {
        dst.clear();
        for (Address p : src) {
            if (!this.isOn(p)) continue;
            dst.add(p);
        }
    }

    private void updatePasteRegion() {
        this.pasteRegion.clear();
        for (Address p : this.copyRegion) {
            this.pasteRegion.add(Rotator2.translateAndRotateAddress(p, this.copyRegionOrigin, this.pasteRegionOrigin, this.pasteRotation));
        }
    }
}

