/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.gui.PanelBase;

public class HintDot {
    private static int[] DIGIT = new int[26];
    private Color dotColor = new Color(255, 175, 175);
    private int dotSize = 3;
    private int dotPitch = 5;
    private int dotOffset = 1;
    private int unit = 3;
    private int maxNumber = 9;
    private PanelBase panel;

    static {
        int i = 0;
        while (i <= 25) {
            HintDot.DIGIT[i] = 1 << i;
            ++i;
        }
    }

    public void setDot(PanelBase panel, int unit, int cellSize) {
        this.panel = panel;
        this.unit = unit;
        this.maxNumber = unit * unit;
        this.setDotSize(cellSize);
    }

    public void setDotSize(int cellSize) {
        this.dotPitch = cellSize / this.unit;
        this.dotSize = this.dotPitch <= 3 ? 2 : (this.dotPitch + 1) / 2;
        this.dotOffset = (cellSize - this.dotPitch * (this.unit - 1) - this.dotSize) / 2;
    }

    public void placeHintCross(Graphics2D g, int r, int c) {
        g.setColor(Color.RED);
        this.panel.placeCross(g, r, c);
    }

    public void placeHintDot(Graphics2D g, int r, int c, int pattern) {
        g.setColor(this.dotColor);
        int x = this.panel.toX(c);
        int y = this.panel.toY(r);
        int d = 1;
        while (d <= this.maxNumber) {
            if ((pattern & DIGIT[d]) != 0) {
                int dy = (d - 1) / this.unit;
                int dx = (d - 1) % this.unit;
                g.fillRect(x + this.dotOffset + this.dotPitch * dx, y + this.dotOffset + this.dotPitch * dy, this.dotSize, this.dotSize);
            }
            ++d;
        }
    }
}

