/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import java.util.Vector;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.BoardBase;

public class UndoManager {
    private Vector<AbstractStep> edits = new Vector();
    private int indexOfNextAdd;
    private BoardBase board;

    public UndoManager(BoardBase b) {
        this.edits.ensureCapacity(100);
        this.indexOfNextAdd = 0;
        this.board = b;
    }

    public synchronized void discardAllEdits() {
        this.edits.clear();
        this.indexOfNextAdd = 0;
    }

    protected void trimEdits(int from, int to) {
        if (from <= to) {
            int i = to;
            while (from <= i) {
                this.edits.removeElementAt(i);
                --i;
            }
            if (this.indexOfNextAdd > to) {
                this.indexOfNextAdd -= to - from + 1;
            } else if (this.indexOfNextAdd >= from) {
                this.indexOfNextAdd = from;
            }
        }
    }

    public synchronized boolean addEdit(AbstractStep anEdit) {
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
        AbstractStep last = this.lastEdit();
        if (last == null) {
            this.edits.addElement(anEdit);
        } else if (!last.addEdit(anEdit)) {
            this.edits.addElement(anEdit);
        }
        this.indexOfNextAdd = this.edits.size();
        return true;
    }

    protected AbstractStep lastEdit() {
        int count = this.edits.size();
        if (count > 0) {
            return this.edits.elementAt(count - 1);
        }
        return null;
    }

    public synchronized void undo() {
        if (this.indexOfNextAdd > 0) {
            AbstractStep edit = this.edits.elementAt(this.indexOfNextAdd - 1);
            this.board.undo(edit);
            --this.indexOfNextAdd;
        }
    }

    public synchronized boolean canUndo() {
        return this.indexOfNextAdd > 0;
    }

    public synchronized void redo() {
        if (this.indexOfNextAdd < this.edits.size()) {
            AbstractStep edit = this.edits.elementAt(this.indexOfNextAdd);
            this.board.redo(edit);
            ++this.indexOfNextAdd;
        }
    }

    public synchronized boolean canRedo() {
        return this.indexOfNextAdd < this.edits.size();
    }

    public int getEditsSize() {
        return this.edits.size();
    }

    public int getIndexOfNextAdd() {
        return this.indexOfNextAdd;
    }

    public void jumpTo(int n) {
        int i;
        if (n >= 0 && n < this.indexOfNextAdd) {
            i = this.indexOfNextAdd - 1;
            while (i >= n) {
                this.undo();
                --i;
            }
        }
        if (n > this.indexOfNextAdd && n <= this.edits.size()) {
            i = this.indexOfNextAdd;
            while (i < n) {
                this.redo();
                ++i;
            }
        }
    }

    public void copyEdits(UndoManager um) {
        UndoManager src = um;
        UndoManager dst = this;
        dst.edits.clear();
        dst.edits.addAll(src.edits);
        dst.indexOfNextAdd = src.indexOfNextAdd;
    }

    public String toString() {
        return " edits: " + this.edits + " indexOfNextAdd: " + this.indexOfNextAdd;
    }
}

