/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.heyawake;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.common.io.IOController;
import pencilbox.heyawake.Panel;
import pencilbox.resource.Messages;

public class Menu
extends MenuBase {
    private JMenuItem numberColorItem;
    private JMenuItem areaBorderColorItem;
    private JMenuItem paintColorItem;
    private JMenuItem circleColorItem;
    private JMenuItem indicateErrorItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    protected void buildEditMenu() {
        this.addTrimAnswerMenuItem();
        super.buildEditMenu();
    }

    protected void buildExportDataMenu() {
        super.buildExportDataMenu();
        this.makeDataExportItem(Messages.getString("MenuBase.exportItemHeyawake"), 'H', IOController.DataFormat.HEYAWAKE);
    }

    protected void buildViewMenu() {
        this.addNoPaintMarkStyleMenu();
        super.buildViewMenu();
        this.areaBorderColorItem = this.addColorMenuItem(Messages.getString("Menu.areaBorderColorItem"));
        this.numberColorItem = this.addColorMenuItem(Messages.getString("Menu.numberColorItem"));
        this.paintColorItem = this.addColorMenuItem(Messages.getString("Menu.paintColorItem"));
        this.circleColorItem = this.addColorMenuItem(Messages.getString("Menu.noPaintColorItem"));
        this.indicateErrorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.indicateErrorItem"), 'E', false);
        this.addToViewMenu(this.indicateErrorItem);
    }

    public void executeCommand2(JMenuItem target) {
        if (target == this.indicateErrorItem) {
            this.getPanel().setIndicateErrorMode(target.isSelected());
        }
    }

    public Color getColor(JMenuItem target) {
        if (target == this.paintColorItem) {
            return this.getPanel().getPaintColor();
        }
        if (target == this.circleColorItem) {
            return this.getPanel().getCircleColor();
        }
        if (target == this.numberColorItem) {
            return this.getPanel().getNumberColor();
        }
        if (target == this.areaBorderColorItem) {
            return this.getPanel().getAreaBorderColor();
        }
        return super.getColor(target);
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.paintColorItem) {
            this.getPanel().setPaintColor(color);
        } else if (target == this.circleColorItem) {
            this.getPanel().setCircleColor(color);
        } else if (target == this.areaBorderColorItem) {
            this.getPanel().setAreaBorderColor(color);
        } else if (target == this.numberColorItem) {
            this.getPanel().setNumberColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.indicateErrorItem.setSelected(this.getPanel().isIndicateErrorMode());
    }
}

