package pencilbox.tentaisho;

import java.util.LinkedList;
import java.util.List;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.AreaEditStep;
import pencilbox.common.core.BoardBase;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;


/**
 *  uṼV[vՖʃNX
 */
public class Board extends BoardBase {
	
	/** Ȃ */
	static final int NOSTAR = 0;
	/**  */
	static final int WHITESTAR = 1;
	/**  */
	static final int BLACKSTAR = 2;

	private int[][] star;
	private Area[][] area;
	private List<Area> areaList;

	protected void setup () {
		super.setup();
		star = new int[rows()*2-1][cols()*2-1];
		area = new Area[rows()][cols()];
		areaList = new LinkedList<Area>();
	}


	public void clearBoard() {
		super.clearBoard();
		areaList.clear();
		ArrayUtil.initArrayObject2(area, null);
	}

	public void initBoard() {
		initAreas();
	}

	/**
	 * Ֆʏ̗̈̏s
	 */
	public void initAreas() {
		for (Area a : areaList) {
			initArea(a);
		}
	}
	
	/**
	 * @return the star
	 */
	int[][] getStar() {
		return star;
	}
	/**
	 * ̍W̐擾
	 * @param r
	 * @param c
	 * @return 
	 */
	public int getStar(int r, int c) {
		return star[r][c];
	}

	public int getStar(Address pos) {
		return getStar(pos.r(), pos.c());
	}
	/**
	 * ̍Wɐݒ肷
	 * @param r
	 * @param c
	 * @param st
	 */
	public void setStar(int r, int c, int st) {
		star[r][c] = st;
	}
	
	public void setStar(Address pos, int st) {
		setStar(pos.r(), pos.c(), st);
	}
	/**
	 * ̐WՏɂ邩
	 * 0<=r<rows*2-1, 0<=c<cols*2-1 łΔՏł
	 * @param r
	 * @param c
	 * @return@Տɂ true
	 */
	public boolean isOnStar(int r, int c) {
		return (r>=0 && r<rows()*2-1 && c>=0 && c<cols()*2-1);
	}
	
	public boolean isOnStar(Address pos) {
		return isOnStar(pos.r(), pos.c());
	}
	/**
	 * ̃}Xꂩ̗̈Ɋ܂܂Ă邩ǂ
	 * @param r
	 * @param c
	 * @return ܂܂Ă true
	 */
	public boolean isCovered(int r, int c) {
		return area[r][c] != null;
	}
	/**
	 * ɗ^ꂽ}X̏̈擾
	 * @param r
	 * @param c
	 * @return }X̏̈
	 */
	public Area getArea(int r, int c) {
		return area[r][c];
	}

	public Area getArea(Address pos) {
		return getArea(pos.r(), pos.c());
	}
	/**
	 * Տ̃}XɁC̃}X̏̈ݒ肷
	 * @param r Row coordinate of the cell.
	 * @param c Colmun coordinate of the cell.
	 * @param a The area to set.
	 */
	public void setArea(int r, int c, Area a) {
		area[r][c] = a;
	}

	public void setArea(Address pos, Area a) {
		setArea(pos.r(), pos.c(), a);
	}
	/**
	 * ՖʂɐV̈ǉ
	 * @param newArea ǉ̈
	 */
	public void addArea(Area newArea) {
		for (Address pos : newArea) {
			setArea(pos.r(), pos.c(), newArea);
		}
		areaList.add(newArea);
	}

	/**
	 * ̈폜
	 * @param oldArea
	 */
	public void removeArea(Area oldArea) {
		for (Address pos : oldArea) {
			if (getArea(pos.r(), pos.c()) == oldArea)
				setArea(pos.r(), pos.c(), null);
		}
		areaList.remove(oldArea);
	}

	void addCellToAreaA(Address pos, Area area) {
		Address p0 = Address.NOWHERE;
		if (area.size() > 0) {
			p0 = (Address)area.toArray()[0];
		}
		fireUndoableEditUpdate(new AreaEditStep(pos, p0, AreaEditStep.ADDED));
		addCellToArea(pos, area);
	}

	void removeCellFromAreaA(Address pos, Area area) {
		Address p0 = Address.NOWHERE;
		if (area.size() > 1) {
			p0 = (Address)area.toArray()[0];
			if (p0.equals(pos))
				p0 = (Address)area.toArray()[1];
		}
		fireUndoableEditUpdate(new AreaEditStep(pos, p0, AreaEditStep.REMOVED));
		removeCellFromArea(pos, area);
	}

	public void undo(AbstractStep step) {
		AreaEditStep s = (AreaEditStep)step;
		Area a;
		if (s.getOperation() == AreaEditStep.ADDED) {
			a = getArea(s.getPos());
			if (a != null) {
				removeCellFromArea(s.getPos(), a);
			}
		} else if (s.getOperation() == AreaEditStep.REMOVED) {
			if (Address.NOWHERE.equals(s.getP0()))
				a = new Area();
			else
				a = getArea(s.getP0());
			if (a != null) {
				addCellToArea(s.getPos(), a);
			}
		}
	}

	public void redo(AbstractStep step) {
		AreaEditStep s = (AreaEditStep)step;
		Area a;
		if (s.getOperation() == AreaEditStep.ADDED) {
			if (Address.NOWHERE.equals(s.getP0()))
				a = new Area();
			else
				a = getArea(s.getP0());
			if (a != null) {
				addCellToArea(s.getPos(), a);
			}
		} else if (s.getOperation() == AreaEditStep.REMOVED) {
			a = getArea(s.getPos());
			if (a != null) {
				removeCellFromArea(s.getPos(), a);
			}
		}
	}
	/**
	 * }Ẍɒǉ
	 * @param r ǉ}X̍sW
	 * @param c ǉ}X̗W
	 * @param area ǉ̈
	 */
	public void addCellToArea(int r, int c, Area area) {
		if (area.isEmpty()) {
			areaList.add(area);
		}
		setArea(r, c, area);
		area.add(r, c);
		initArea(area);
	}

	public void addCellToArea(Address pos, Area area) {
		addCellToArea(pos.r(), pos.c(), area);
	}
	/**
	 * }Ẍ悩菜
	 * @param r 菜}X̍sW
	 * @param c 菜}X̗W
	 * @param area 菜̈
	 */
	public void removeCellFromArea(int r, int c, Area area) {
		setArea(r, c, null);
		area.remove(r, c);
		if (area.isEmpty()) {
			areaList.remove(area);
		} else {
			initArea(area);
		}
	}

	public void removeCellFromArea(Address pos, Area area) {
		removeCellFromArea(pos.r(), pos.c(), area);
	}
	/**
	 * VK쐬̈Ɋ܂܂鐯ݒ肷
	 * @param newArea
	 */
	void initArea(Area newArea) {
		int nStar = 0;
		StarAddress starPos = StarAddress.NOWHERE;
		for (Address pos : newArea) {
			for (int i=2*pos.r()-1; i<=2*pos.r()+1; i++) {
				for (int j=2*pos.c()-1; j<=2*pos.c()+1; j++) {
					if (isOnStar(i, j) && getStar(i, j) > 0) {
						if (nStar == 0) {
							nStar = getStar(i, j);
							starPos = StarAddress.address(i,j);
						} else if (nStar == 1 || nStar == 2) {
							if (!starPos.equals(i, j)) {
								nStar = -1;
								starPos = StarAddress.NOWHERE;
							}
						} 
					}
				}
			}
		}
		newArea.setStarType(nStar);
		newArea.setStarPos(starPos);
	}
	
	public int checkAnswerCode() {
		int result = 0;
		for (Area a : areaList) {
			if (a.isPointSymmetry() == false) {
				result |= 1;
			} 
		}
		for (int r = 0; r < rows(); r++)
			for (int c = 0; c < cols(); c++)
				if (area[r][c] == null) result |= 2;
	
		return result;
	}

	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result ==0 )
			return COMPLETE_MESSAGE;
		StringBuffer message = new StringBuffer();
		if ((result&1) == 1)
			message.append(Messages.getString("tentaisho.AnswerCheckMessage1")); //$NON-NLS-1$
		else if ((result&2) == 2)
			message.append(Messages.getString("tentaisho.AnswerCheckMessage2")); //$NON-NLS-1$
		return message.toString();
	}
	/**
	 * @return Returns the areaList.
	 */
	List<Area> getAreaList() {
		return areaList;
	}
	/**
	 * @return Returns the domain.
	 */
	Area[][] getArea() {
		return area;
	}
}
