package pencilbox.hitori;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;


/**
 * uЂƂɂĂvՖʃNX
 */
public class Board extends BoardBase {

	static final int WHITE = -1;
	static final int BLACK = -2;
	static final int UNKNOWN = 0;
	static final int UNDECIDED_NUMBER = -1;

	private int[][] state;
	private int[][] number;
	private int[][] multiH; // ̏d
	private int[][] multiV; // c̏d
	private boolean[][] single; // ŏЂƂ肩
	private int[][] chain; // }X΂ߘA
	private int maxNumber; // gp\
	private int maxChain = 1; // ݎgpĂőchainԍ

	protected void setup() {
		super.setup();
		int rows = rows();
		int cols = cols();
		number = new int[rows][cols];
		state = new int[rows][cols];
		single = new boolean[rows][cols];
		multiH = new int[rows][cols];
		multiV = new int[rows][cols];
		chain = new int[rows][cols];
		maxNumber = (rows > cols) ? rows : cols;
	}

	public void clearBoard() {
		super.clearBoard();
		ArrayUtil.initArrayInt2(state, UNKNOWN);
		initBoard();
	}

	public void trimAnswer() {
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (getState(r, c) == WHITE)
					setState(r, c, UNKNOWN);
				}
		}
	}

	public void initBoard() {
		initSingle();
		initMulti();
		initChain();
	}
	
	/**
	 * }X̏Ԃ擾
	 * @param r }X̍sW
	 * @param c }X̗W
	 * @return }X̏Ԃ\ state[r][c] ̒l
	 */
	public int getState(int r, int c) {
		return state[r][c];
	}
	
	public int getState(Address pos) {
		return getState(pos.r(), pos.c());
	}
	/**
	 * }X̏Ԃݒ肷
	 * @param r }X̍sW
	 * @param c }X̗W
	 * @param st state[r][c] ɐݒ肷l
	 */
	public void setState(int r, int c, int st) {
		state[r][c] = st;
	}
	
	public void setState(Address pos, int st) {
		setState(pos.r(), pos.c(), st);
	}
	/**
	 * }X̐擾
	 * @param r row coordinate of the cell.
	 * @param c columun coordinate of the cell.
	 * @return Returns the number of the cell.
	 */
	public int getNumber(int r, int c) {
		return number[r][c];
	}
	
	public int getNumber(Address pos) {
		return getNumber(pos.r(), pos.c());
	}
	/**
	 * }Xɐݒ肷
	 * @param r row coordinate of the cell.
	 * @param c columun coordinate of the cell.
	 * @param n the number to set.
	 */
	public void setNumber(int r, int c, int n) {
		number[r][c] = n;
	}
	
	public void setNumber(Address pos, int n) {
		setNumber(pos.r(), pos.c(), n);
	}
	/**
	 * ̍W}XǂB
	 * @param r sW
	 * @param c W
	 * @return }XȂ true ԂB
	 */
	public boolean isBlack(int r, int c) {
		return isOn(r, c) && state[r][c] == BLACK;
	}
	/**
	 * ̃}XƏc܂͉̓ɁC}XŏĂȂ邩
	 * @param r sW
	 * @param c W
	 * @return }XŏĂȂ true, Ȃ false
	 */
	public boolean isRedundantNumber(int r, int c) {
		return multiH[r][c] > 1 || multiV[r][c] > 1;
	}
	/**
	 * ̃}X̐ŏЂƂ肩ǂC
	 * ܂c̓ɓ݂̐ȂǂԂ
	 * @param r sW 
	 * @param c W
	 * @return ŏЂƂȂ true, łȂ false
	 */
	public boolean isSingle(int r, int c) {
		return single[r][c];
	}
	int getChain(int r, int c) {
		return chain[r][c];
	}
	
	/**
	 *  }X}XɊm肷
	 *  ȑȌԂ}XmłȂƂ͑OƂ
	 *  hmulit, vmulti, chain XV
	 * @param r sW
	 * @param c W
	 */
	void setBlack(int r, int c) {
		state[r][c] = BLACK;
		decreseMulti(r, c);
		connectChain(r,c);
	}
	/**
	 *  }X𔒃}XɊm肷
	 *  ȑȌԂV}XmłȂƂOƂ
	 *  hmulit, vmulti, chain XV
	 * @param r sW
	 * @param c W
	 */
	void setWhite(int r, int c) {
		int before = state[r][c];
		state[r][c] = WHITE;
		if (before == BLACK) {
			increaseMulti(r, c);
			cutChain(r, c);
		}
	}

	/**
	 *  }X̊mԂƂ
	 *  ȑȌԂԂłȂƂOƂ
	 *  hmulit, vmulti, chain XV
	 * @param r sW
	 * @param c W
	 */
	public void erase(int r, int c) {
		int before = getState(r,c);
		state[r][c] = UNKNOWN;
		if (before == BLACK) {
			increaseMulti(r, c);
			cutChain(r, c);
		}
	}
	/**
	 * }X̏Ԃݒ肷
	 * @param r }X̍sW
	 * @param c }X̗W
	 * @param st state[r][c] ɐݒ肷l
	 */
	public void changeState(int r, int c, int st) {
//		state[row][col] = st;
		if (st == BLACK) setBlack(r,c);
		else if (st == WHITE) setWhite(r,c);
		else if (st == UNKNOWN) erase(r,c);
//		initChain();
//		checkContinuousBlack();
	}
	
	public void changeState(Address pos, int st) {
		changeState(pos.r(), pos.c(), st);
	}
	/**
	 * }X̏Ԃw肵ԂɕύXCύXAhDXi[ɒʒm
	 * @param pos }XW
	 * @param st ύX̏
	 */
	public void changeStateA(Address pos, int st) {
		fireUndoableEditUpdate(new CellEditStep(pos, getState(pos), st));
		changeState(pos, st);
	}
	
	public void undo(AbstractStep step) {
		CellEditStep s = (CellEditStep) step;
		changeState(s.getPos(), s.getBefore());
	}

	public void redo(AbstractStep step) {
		CellEditStep s = (CellEditStep) step;
		changeState(s.getPos(), s.getAfter());
	}

	/**
	 * ̃}X̏㉺E̗אڂS}Xɍ}X邩ǂ𒲂ׂ
	 * @param r
	 * @param c
	 * @return ㉺Eɍ}XЂƂł true
	 */
	boolean isBlock(int r, int c) {
		if (isBlack(r-1, c) || isBlack(r+1, c) || isBlack(r, c-1) || isBlack(r, c+1))
			return true;
		return false;
	}
	
	boolean isBlock(Address pos) {
		return isBlock(pos.r(), pos.c());
	}

	/**
	 * 	chainz
	 */
	void initChain() {
		maxChain = 1;
		ArrayUtil.initArrayInt2(chain,0);
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				if (isOnPeriphery(r, c)) {
					if (isBlack(r, c) && chain[r][c] == 0) {
						if (initChain1(r, c, 0, 0, 1) == -1) {
							updateChain(r, c, -1);
						}
					}
					
				}
			}
		}
		for (int r = 1; r < rows() - 1; r++) {
			for (int c = 1; c < cols() - 1; c++) {
				if (isBlack(r, c) && chain[r][c] == 0) {
					if (initChain1(r, c, 0, 0, ++maxChain) == -1) {
						updateChain(r, c, -1);
					}
				}
			}
		}
	}
	/**
	 * ΂߂ɂȂ鍕}XǂCchain ɔԍ n ݒ肷
	 * f𔭌C̎_ -1 ԂĖ߂
	 * @param r
	 * @param c
	 * @param uu
	 * @param vv
	 * @param n
	 * @return Ֆʂ̕f𔭌 -1 , łȂ n Ɠl
	 */
	int initChain1(int r, int c, int uu, int vv, int n) {
		if (n == 1 && uu != 0 && isOnPeriphery(r, c)) { // ւOɒB
			return -1;
		}
		if (n >= 0 && isOnPeriphery(r, c)) {
			chain[r][c] = 1;
		} else {
			chain[r][c] = n;
		}
		for (int u = -1; u < 2; u += 2) {
			for (int v = -1; v < 2; v += 2) {
				if ((u == -uu) && (v == -vv))
					continue; // Ƃ͂Ƃ΂
				if (!isBlack(r + u, c + v))
					continue; // }XȊO͂Ƃ΂
				if (chain[r + u][c + v] == n) // ւ
					return -1;
				if (initChain1(r + u, c + v, u, v, n) == -1)
					return -1;
			}
		}
		return n;
	}
	private int[] adjacentChain = new int[4];
	/**
	 * 	Ŋm肵ƂɁC̃}X_ƂchainXVD
	 * 	̃}Xm肵ƂɂCVKɕf邩𒲂ׁC
	 * 	Ȃ chain Ŝ -1 ōXVD
	 * 	ȂȂC΂ߗא4}X̍ŏlɂ킹D
	 * 	΂ߗׂɍ}XȂ΁CVԍD
	 * @param r
	 * @param c
	 */
	void connectChain(int r, int c) {
		int[] adjacent = adjacentChain;
		int k = 0;
		int newChain = Integer.MAX_VALUE;
		if (isOnPeriphery(r,c)) newChain = 1;
		for (int u = -1; u < 2; u += 2) {
			for (int v = -1; v < 2; v += 2) {
				if (!isBlack(r + u, c + v))
					continue; // }XȊO͂Ƃ΂
				if (isOnPeriphery(r, c) && chain[r + u][c + v] == 1) {
					newChain = -1; // [̃}XɂƂԍ1
				} 
				adjacent[k] = chain[r + u][c + v];
				for (int l = 0; l < k; l++) {
					if (adjacent[k] == adjacent[l]) // ԍ
						newChain = -1;
				}
				k++;
				if (chain[r + u][c + v] < newChain)
					newChain = chain[r + u][c + v];
			}
		}
		if (newChain == Integer.MAX_VALUE)
			chain[r][c] = ++maxChain; // ͂ɍ}XȂƂCVԍ
		else
			updateChain(r, c, newChain); // ͂ɍ}XƂC̍ŏԍ
	}
	/**
	 * }XƂɁC΂ߗׂchainXVD
	 * @param r
	 * @param c
	 */
	void cutChain(int r, int c) {
		initChain();
	}
	/**
	 * 	}X chainԍݒ肷
	 * 	΂ߗׂɍ}XΓԍݒ肷
	 * @param r
	 * @param c
	 * @param n
	 */
	 void updateChain(int r, int c, int n) {
		chain[r][c] = n;
		for (int u = -1; u < 2; u += 2) {
			for (int v = -1; v < 2; v += 2) {
				if (!isBlack(r + u, c + v))
					continue; // }XȊO͂Ƃ΂
				if (chain[r + u][c + v] == n)
					continue; // ԍ炻̂܂
				updateChain(r + u, c + v, n);
			}
		}
	}

	/**
	 * }XɂՖʂfĂȂǂ𒲍
	 * @return }XɂՖʂfĂȂ true fĂ false Ԃ
	 */
	boolean checkDivision() {
		boolean ret = true;
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols() - 1; c++) {
				if (chain[r][c] == -1) {
						ret = false;
				}
			}
		}
		return ret;
	}
	/**
	 * ՖʑŜŁCcɘA鍕}XȂǂ𒲍
	 * @return@A鍕}XȂ true,  false Ԃ@
	 */
	boolean checkContinuousBlack() {
		boolean ret = true;
		for (int r = 0; r < rows() - 1; r++) {
			for (int c = 0; c < cols(); c++) {
				if (isBlack(r ,c)) {
					if (isBlock(r, c)) {
						ret = false;
					}
				}
			}
		}
		return ret;
	}
	/**
	 * ՖʑŜŁCcɍ}Xŏꂸɏd鐔Ȃ𒲍
	 * @return dȂ true  false
	 */
	boolean checkMulti() {
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				if (isRedundantNumber(r, c))
					return false;
			}
		}
		return true;
	}
	
	public int checkAnswerCode() {
		int result = 0;
		if (!checkContinuousBlack())
			result |= 1;
		if (!checkDivision())
			result |= 2;
		if (!checkMulti())
			result |= 4;
		return result;
	}

	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result == 0)
			return BoardBase.COMPLETE_MESSAGE;
		StringBuffer message = new StringBuffer();
		if ((result & 1) == 1)
			message.append ( Messages.getString("hitori.AnswerCheckMessage1")); //$NON-NLS-1$
		if ((result & 2) == 2)
			message.append (Messages.getString("hitori.AnswerCheckMessage2")) ; //$NON-NLS-1$
		if ((result & 4) == 4)
			message.append (Messages.getString("hitori.AnswerCheckMessage3")) ; //$NON-NLS-1$
		return message.toString();
	}

	/**
	 *  singlez
	 */
	void initSingle() {
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				single[r][c] = true;
			}
		}
		int[] used = new int[maxNumber + 1];
		for (int r = 0; r < rows(); r++) {
			for (int i = 1; i <= maxNumber; i++)
				used[i] = 0;
			for (int c = 0; c < cols(); c++) {
				used[number[r][c]]++;
			}
			for (int c = 0; c < cols(); c++) {
				if (used[number[r][c]] > 1)
					single[r][c] = false;
			}
		}
		for (int c = 0; c < cols(); c++) {
			for (int i = 1; i <= maxNumber; i++)
				used[i] = 0;
			for (int r = 0; r < rows(); r++) {
				used[number[r][c]]++;
			}
			for (int r = 0; r < rows(); r++) {
				if (used[number[r][c]] > 1)
					single[r][c] = false;
			}
		}
	}
	/**
	 * 	hmulti, vmulti z
	 */
	void initMulti() {
		int[] used = new int[maxNumber + 1];
		for (int r = 0; r < rows(); r++) {
			for (int i = 0; i <= maxNumber; i++)
				used[i] = 0;
			for (int c = 0; c < cols(); c++) {
				if (state[r][c] != BLACK && number[r][c] > 0)
					used[number[r][c]]++;
			}
			for (int c = 0; c < cols(); c++) {
				multiH[r][c] = used[number[r][c]];
			}
		}
		for (int c = 0; c < cols(); c++) {
			for (int i = 0; i <= maxNumber; i++)
				used[i] = 0;
			for (int r = 0; r < rows(); r++) {
				if (state[r][c] != BLACK && number[r][c] > 0)
					used[number[r][c]]++;
			}
			for (int r = 0; r < rows(); r++) {
				multiV[r][c] = used[number[r][c]];
			}
		}
	}
	/**
	 * 	}X(rr,cc)Ŋm肵ƂɁCsC hmulti, vmulti 1炷
	 * @param r0 ԂύX}X̍sW
	 * @param c0 ԂύX}X̗W
	 */
	private void decreseMulti(int r0, int c0) {
		for (int c = 0; c < cols(); c++) {
			if (number[r0][c] == number[r0][c0]) {
				multiH[r0][c]--;
			}
		}
		for (int r = 0; r < rows(); r++) {
			if (number[r][c0] == number[r0][c0]) {
				multiV[r][c0]--;
			}
		}
	}
	/**
	 * }X(rr,cc)ƂɁCsC hmulti, vmulti 1₷
	 * @param r0 ԂύX}X̍sW
	 * @param c0 ԂύX}X̗W
	 */
	private void increaseMulti(int r0, int c0) {
		for (int c = 0; c < cols(); c++) {
			if (number[r0][c] == number[r0][c0]) {
				multiH[r0][c]++;
			}
		}
		for (int r = 0; r < rows(); r++) {
			if (number[r][c0] == number[r0][c0]) {
				multiV[r][c0]++;
			}
		}
	}

	/**
	 * @return Returns the maxNumber.
	 */
	int getMaxNumber() {
		return maxNumber;
	}
	/**
	 * @return Returns the chain.
	 */
	int[][] getChain() {
		return chain;
	}
	/**
	 * @return Returns the number.
	 */
	int[][] getNumber() {
		return number;
	}
	/**
	 * @return Returns the state.
	 */
	int[][] getState() {
		return state;
	}
}
