package pencilbox.hashi;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.resource.Messages;


/**
 * uvՖʃNX
 */
public class Board extends BoardBase {

	static final int UNDECIDED_NUMBER = 9;

	private Pier[][] pier;
	private Bridge[][] bridgeV;
	private Bridge[][] bridgeH;
	private int maxChain;
	private int nPier;
	private int nBridge;

	protected void setup() {
		super.setup();
		bridgeV = new Bridge[rows()][cols()];
		bridgeH = new Bridge[rows()][cols()];
		pier = new Pier[rows()][cols()];
		maxChain = 1;
		nPier = 0;
		nBridge = 0;
	}

	public void clearBoard() {
		super.clearBoard();
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				if (isPier(r, c))
					pier[r][c].clear();
			}
		}
	}

	public void initBoard() {
		initChain();
	}
	/**
	 * }Xɐݒ肷
	 * @param r ݒ肷}X̍sW
	 * @param c ݒ肷}X̗W
	 * @param n ݒ肷鐔
	 */
	public void setNumber(int r, int c, int n) {
		if (n == 0) {
			if (isPier(r, c)) {
				removePier(r, c);
			}
		} else if (n > 0) {
			if (isPier(r, c))
				pier[r][c].setNumber(n);
			else
				addPier(r, c, n);
		}
	}
	
	public void setNumber(Address pos, int n) {
		setNumber(pos.r(), pos.c(), n);
	}
	/**
	 * }X̐擾
	 * @param r ݒ肷}X̍sW
	 * @param c ݒ肷}X̗W
	 * @return }X̐
	 */
	public int getNumber(int r, int c) {
		if (pier[r][c] == null)
			return 0;
		else
			return pier[r][c].getNumber();
	}
	
	public int getNumber(Address pos) {
		return getNumber(pos.r(), pos.c());
	}
	/**
	 * ̃}X}Xirjǂ
	 * @param r sW
	 * @param c W
	 * @return }XȂ true
	 */
	public boolean isPier(int r, int c) {
		return pier[r][c] != null;
	}
	/**
	 * ̃}X}Xirjǂ
	 * @param pos W
	 * @return }XȂ true
	 */
	public boolean isPier(Address pos) {
		return isPier(pos.r(), pos.c());
	}
	
	/**
	 * }X̏Ԃ擾
	 * @param r sW
	 * @param c W
	 * @return }X̏
	 */
	public int getState(int r, int c) {
		int ret = 0;
		if (bridgeV[r][c] != null)
			ret += bridgeV[r][c].getBridge();
		if (bridgeH[r][c] != null)
			ret += (bridgeH[r][c].getBridge() << 2);
		return ret;
	}
	
	public int getState(Address pos) {
		return getState(pos.r(), pos.c());
	}
	/**
	 * }X̏Ԃݒ肷
	 * @param r sW
	 * @param c W
	 * @param n }X̏
	 */
	public void setState(int r, int c, int n) {
		if (bridgeV[r][c] != null)
			bridgeV[r][c].setBridge(n & 0x3);
		if (bridgeH[r][c] != null)
			bridgeH[r][c].setBridge((n>>2) & 0x3);
	}
	
	public void setState(Address pos, int n) {
		setState(pos.r(), pos.c(), n);
	}
	/**
	 * ̃}Xʉ߂c̋̐Ԃ
	 * @param r sW
	 * @param c W
	 * @return@̃}Xʉ߂c̋̐
	 */
	public int getVertBridge(int r, int c) {
		if (bridgeV[r][c] == null)
			return -1;
		else
			return bridgeV[r][c].getBridge();
	}
	/**
	 * ̃}Xʉ߂鉡̋̐Ԃ
	 * @param r sW
	 * @param c W
	 * @return@̃}Xʉ߂鉡̋̐
	 */
	public int getHorizBridge(int r, int c) {
		if (bridgeH[r][c] == null)
			return -1;
		else
			return bridgeH[r][c].getBridge();
	}
	/**
	 * ̃}X̏ŋĂ邩Ă邩ǂ
	 * @param r sW
	 * @param c W
	 * @return ̃}X̏ŋĂ true
	 */
	public boolean hasCrossedBridge(int r, int c) {
		return getHorizBridge(r, c) > 0 && getVertBridge(r, c) > 0;
	}
	
	/**
	 * @param r sW
	 * @param c W
	 * @return Returns the pier.
	 */
	public Pier getPier(int r, int c) {
		return pier[r][c];
	}
	/**
	 * ̃}X̋擾
	 * @param r sW
	 * @param c W
	 * @param dir c̋̋
	 * @return@̃}X̏̋
	 */
	public Bridge getBridge(int r, int c, int dir) {
		if (dir == Direction.HORIZ) {
			return bridgeH[r][c];
		} else if (dir == Direction.VERT) {
			return bridgeV[r][c];
		}
		return null;
	}
	/**
	 * }Xɂ̃}Xʂ鋴ݒ肷
	 * @param r sW
	 * @param c W
	 * @param dir c̋̋
	 * @param b ݒ肷Bridge
	 */
	public void setBridge(int r, int c, int dir, Bridge b) {
		if (dir == Direction.HORIZ) {
			bridgeH[r][c] = b;
		} else if (dir == Direction.VERT) {
			bridgeV[r][c] = b;
		}
	}
	/**
	 * ̒ʂՏ̊e}XɁC̋ݒ肷
	 * @param pos0 n_}X
	 * @param pos1 I_}X
	 * @param d n_I_
	 * @param b Bridge
	 */
	void setBridge(Address pos0, Address pos1, int d, Bridge b) {
		Address pos = Address.address(pos0);
		while(true) {
			pos = pos.nextCell(d);
			if (pos.equals(pos1)) break;
			setBridge(pos.r(), pos.c(), d&1, b);
		}
	}
	/**
	 * w肵WɋrVKɍ쐬
	 * ̃}XɂƂƂĂ͏
	 * @param r sW
	 * @param c W
	 * @param n 
	 */
	void addPier(int r, int c, int n) {
		Pier p = new Pier(r, c, n);
		pier[r][c] = p;
		for (int d = 0; d < 4; d++) {
			Pier next = findPier(r, c, d);
			if (next != null) {
				next.setNextPier(d^2,p);
				p.setNextPier(d,next);
				Bridge b = new Bridge(p, next);
				next.setBridge(d^2, b);
				p.setBridge(d, b);
				setBridge(p.getPos(), next.getPos(), d, b);
				nBridge ++;
			}
		}
		nPier ++;
	}
	/**
	 * w肵Wɂ鋴r
	 * ̋oĂ͏
	 * @param r sW
	 * @param c W
	 */
	void removePier(int r, int c) {
		
		Pier p = pier[r][c];
		
		for (int d=0; d<4; d++) {
			Pier p1 = p.getNextPier(d);
			Pier p2 = p.getNextPier(d^2);
			if (p1 != null) {
				if (p2 != null)
					p1.setNextPier(d^2, p2);
				else 
					p1.setNextPier(d^2, null);
			}
		}
		for (int d=0; d<2; d++) {
			Pier p1 = p.getNextPier(d);
			Pier p2 = p.getNextPier(d^2);
			if (p1 != null) {
				if (p2 != null) {
					Bridge b = new Bridge(p1, p2);
					setBridge(p2.getPos(), p1.getPos(), d, b);
					p1.setBridge(d^2, b);
					p2.setBridge(d, b);
					nBridge --;
				} else {
					setBridge(p.getPos(), p1.getPos(), d, null);
					p1.setBridge(d^2, null);
					nBridge --;
				}
			} else {
				if (p2 != null) {
					setBridge(p.getPos(), p2.getPos(), d^2, null);
					p2.setBridge(d, null);
					nBridge --;
				} else {
				}
			}
		}

		pier[r][c] = null;
		nPier --;
	}

	/**
	 * @param nBridge The nBridge to set.
	 */
	void setNBridge(int nBridge) {
		this.nBridge = nBridge;
	}

	/**
	 * @return Returns the nBridge.
	 */
	int getNBridge() {
		return nBridge;
	}

	/**
	 * @param nPier The nPier to set.
	 */
	void setNPier(int nPier) {
		this.nPier = nPier;
	}

	/**
	 * @return Returns the nPier.
	 */
	int getNPier() {
		return nPier;
	}

	/**
	 * @return Returns the maxChain.
	 */
	int getMaxChain() {
		return maxChain;
	}

	/**
	 * N_w肵ɂŏ̋rԂ
	 * @param r N_̍sW
	 * @param c N_̗W
	 * @param direction rT
	 * @return N_w肵ɂŏ̋r
	 */
	Pier findPier(int r, int c, int direction) {
		Address pos = Address.address(r, c);
		pos = pos.nextCell(direction);
		while (isOn(pos)) {
			if (isPier(pos)) {
				return pier[pos.r()][pos.c()];
			}
			pos = pos.nextCell(direction);
		}
		return null;
	}
	/**
	 * 
	 * @param r N_̍sW
	 * @param c N_̗W
	 * @param direction i㉺Ej
	 */
	public void addBridge(int r, int c, int direction) {
		if (!isPier(r, c))
			return;
		if (pier[r][c].getNextPier(direction) == null)
			return;
		if (pier[r][c].getNBridge(direction) == 2)
			return;
		pier[r][c].increaseBridge(direction);
		if (pier[r][c].getNBridge(direction) == 1)
			connectChain(pier[r][c], pier[r][c].getNextPier(direction));
	}

	public void addBridge(Address p, int d) {
		addBridge(p.r(), p.c(), d);
	}
	/**
	 * 
	 * @param r N_̍sW
	 * @param c N_̗W
	 * @param direction i㉺Ej
	 */
	public void removeBridge(int r, int c, int direction) {
		if (!isPier(r, c))
			return;
		if (pier[r][c].getNextPier(direction) == null)
			return;
		if (pier[r][c].getNBridge(direction) == 0)
			return;
		pier[r][c].decreaseBridge(direction);
		if (pier[r][c].getNBridge(direction) == 0)
			cutChain(pier[r][c], pier[r][c].getNextPier(direction));
	}

	public void removeBridge(Address p, int d) {
		removeBridge(p.r(), p.c(), d);
	}
	/**
	 * CAhDXi[ɒʒm
	 * @param pos N_̍W
	 * @param direction i㉺Ej
	 */
	public void addBridgeA(Address pos, int direction) {
		addBridge(pos.r(), pos.c(), direction);
		fireUndoableEditUpdate(new BridgeEditStep(pos, direction, BridgeEditStep.ADDED));
	}
	/**
	 * CAhDXi[ɒʒm
	 * @param pos N_̍W
	 * @param direction i㉺Ej
	 */
	public void removeBridgeA(Address pos, int direction) {
		removeBridge(pos.r(), pos.c(), direction);
		fireUndoableEditUpdate(new BridgeEditStep(pos, direction, BridgeEditStep.REMOVED));
	}

	public void undo(AbstractStep step) {
		BridgeEditStep s = (BridgeEditStep) step;
		if (s.getChange() == BridgeEditStep.ADDED) {
			removeBridge(s.getPos(), s.getDirection());
		} else if (s.getChange() == BridgeEditStep.REMOVED) {
			addBridge(s.getPos(), s.getDirection());
		}
	}

	public void redo(AbstractStep step) {
		BridgeEditStep s = (BridgeEditStep) step;
		if (s.getChange() == BridgeEditStep.ADDED) {
			addBridge(s.getPos(), s.getDirection());
		} else if (s.getChange() == BridgeEditStep.REMOVED) {
			removeBridge(s.getPos(), s.getDirection());
		}
	}

	/**
	 * ̘Aԍ
	 */
	void initChain() {
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				if (isPier(r, c)) {
					pier[r][c].setChain(0);
				}
			}
		}
		maxChain = 1;
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				if (isPier(r, c)) {
					if (pier[r][c].totalBridges() == 0)
						pier[r][c].setChain(0);
					else if (pier[r][c].getChain() == 0) {
						initChain1(pier[r][c], maxChain++);
					}
				}
			}
		}
	}

	/**
	 * }Xn_Ƃ chainԍ̏
	 * @param p n_ƂȂ鋴r
	 * @param chain ԍ
	 */
	void initChain1(Pier p, int chain) {
		if (p.getChain() == chain)
			return;
		p.setChain(chain);
		for (int d = 0; d < 4; d++) {
			if (p.getNBridge(d) > 0)
				initChain1(p.getNextPier(d), chain);
		}
	}
	/**
	 * chain 
	 * hbOɍ킹
	 * @param pierA
	 * @param pierB
	 */
	void connectChain(Pier pierA, Pier pierB) {

		int a = pierA.getChain();
		int b = pierB.getChain();

		if (a == 0) {
			if (b == 0) {
				pierA.setChain(maxChain);
				pierB.setChain(maxChain++);
			} else if (b > 0) {
				pierA.setChain(b);
			}
		} else if (a > 0) {
			if (b == 0) {
				pierB.setChain(a);
			} else if (b > 0) {
				initChain1(pierB, a);
			}
		}
	}

	/**
	 * chain ؒf
	 * hbOԍ̔ԍɎc
	 * @param pierA
	 * @param pierB
	 */
	void cutChain(Pier pierA, Pier pierB) {

		int a = pierA.totalBridges();
		int b = pierB.totalBridges();

		if (a == 0) {
			pierA.setChain(0);
			if (b == 0) {
				pierB.setChain(0);
			} else if (b > 0) {
			}
		} else if (a > 0) {
			if (b == 0) {
				pierB.setChain(0);
			} else if (b > 0) {
				initChain1(pierB, maxChain++);
			}
		}
	}

	/**
	 * ̃}Xo鋴̐ɒBĂ邩ǂׂ
	 * @param r sW
	 * @param c W
	 * @return >0: Ȃ, =0: 傤, <0 
	 */
	public int checkPier(int r, int c) {
		int number = pier[r][c].getNumber();
		int bridges = pier[r][c].totalBridges();
		if (number == UNDECIDED_NUMBER)
			return 1;
		return number - bridges;
	}

	public int checkAnswerCode() {
		int result = 0;
		if (checkCross() == false)
			result |= 1;
		if (checkConnection() == false)
			result |= 2;
		if (checkNumbers() == false)
			result |= 4;
		return result;
	}

	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result == 0)
			return BoardBase.COMPLETE_MESSAGE;
		StringBuffer message = new StringBuffer();
		if ((result & 1) == 1)
			message.append(ERR_CROSS_BRIDGE);
		if ((result & 2) == 2)
			message.append(YET_MULTIPLE_LINE);
		if ((result & 4) == 4)
			message.append(ERR_WRONG_NUMBER);
		return message.toString();
	}
	private boolean checkNumbers() {
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				if (isPier(r, c)) {
					if (pier[r][c].getNumber() == UNDECIDED_NUMBER)
						continue;
					if (pier[r][c].totalBridges() != pier[r][c].getNumber())
						return false;
				}
			}
		}
		return true;
	}
	
	private boolean checkConnection() {
		int n = 0;
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				if (isPier(r, c)) {
					int m = pier[r][c].getChain();
					if (m == 0)
						return false;
					else if (n == 0)
						n = m;
					else if (n != m)
						return false;
				}
			}
		}
		return true;
	}
	
	private boolean checkCross() {
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				if (hasCrossedBridge(r, c))
					return false;
			}
		}
		return true;
	}
	
	static final String ERR_CROSS_BRIDGE = Messages.getString("hashi.AnswerCheckMessage1"); //$NON-NLS-1$
	static final String YET_MULTIPLE_LINE = Messages.getString("hashi.AnswerCheckMessage2"); //$NON-NLS-1$
	static final String ERR_WRONG_NUMBER = Messages.getString("hashi.AnswerCheckMessage3"); //$NON-NLS-1$
//	static final String ERR_TOO_MANY_LINE = "̐鐔\n";
//	static final String YET_TOO_FEW_LINE= "̐Ȃ\n";
	
	int sumAllNumbers() {
		int ret = 0;
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				if (isPier(r,c))
					ret += pier[r][c].getNumber(); 
			}
		}
		return ret/2;
	}
}
