package pencilbox.hakyukoka;

import java.util.LinkedList;
import java.util.List;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellNumberEditStep;
import pencilbox.resource.Messages;


/**
 * ugyʁvՖʃNX
 * qg@\
 */
public class Board extends BoardBase {
	
	static final int UNSTABLE = 0;
	static final int STABLE = 1;
	static final int UNKNOWN = 0;
	
	private List<Area> areaList;
//	private int maxNumber = 9; // ő吔9Ƃ
	private int[][] state; // ̐:1, 𓚂ׂ:0,
	private int[][] number;
	private Area[][] area;
	
	private int[][] multi;  // sł̏dL^
	private int[][] multi2;  // ̈ł̏dL^
	private DigitPatternHint hint;       // gp\p^[

	protected void setup() {
		super.setup();
		state = new int[rows()][cols()];
		number = new int[rows()][cols()];
		area = new Area[rows()][cols()];
		areaList = new LinkedList<Area>();
		multi = new int[rows()][cols()];
		multi2 = new int[rows()][cols()];
		hint = new DigitPatternHint();
		hint.setupHint(this);
	}

	public void clearBoard() {
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (!isStable(r,c))
					number[r][c] = 0;
			}
		}
		initBoard();
	}
	/**
	 * ̃}X͖ƂĐ^ꂽ}Xǂ
	 * @param r }X̍sW
	 * @param c }X̗W
	 * @return 萔̃}XȂ true, 𓚂ׂ}XȂ false
	 */
	public boolean isStable(int r, int c) {
		return state[r][c] == STABLE;
	}
	
	public boolean isStable(Address pos) {
		return isStable(pos.r(), pos.c());
	}
	/**
	 * Get state of a cell.
	 * @param r Row coordinate of the cell.
	 * @param c Colmun coordinate of the cell.
	 * @return Returns the state.
	 */
	public int getState(int r, int c) {
		return state[r][c];
	}
	
	public int getState(Address pos) {
		return getState(pos.r(), pos.c());
	}
	/**
	 * Set state to a cell.
	 * @param r Row coordinate of the cell.
	 * @param c Colmun coordinate of the cell.
	 * @param st The state to set.
	 */
	public void setState(int r, int c, int st) {
		state[r][c] = st;
	}
	
	public void setState(Address pos, int st) {
		setState(pos.r(), pos.c(), st);
	}
	/**
	 * Get number of a cell.
	 * @param r Row coordinate of the cell.
	 * @param c Colmun coordinate of the cell.
	 * @return Returns the number.
	 */
	public int getNumber(int r, int c ) {
		return number[r][c];
	}
	public int getNumber(Address pos) {
		return getNumber(pos.r(), pos.c());
	}
	/**
	 * Set number to  a cell.
	 * @param r Row coordinate of the cell.
	 * @param c Colmun coordinate of the cell.
	 * @param n The number to set.
	 */
	public void setNumber(int r, int c, int n) {
		number[r][c] = n;
	}
	
	public void setNumber(Address pos, int n) {
		setNumber(pos.r(), pos.c(), n);
	}
	/**
	 * ̃}X̏̈擾
	 * ̃}ẌɑĂȂꍇ null Ԃ
	 * @param r Row coordinate of the cell.
	 * @param c Colmun coordinate of the cell.
	 * @return Returns the area.
	 */
	public Area getArea(int r, int c ) {
		return area[r][c];
	}
	
	public Area getArea(Address pos) {
		return getArea(pos.r(), pos.c());
	}
	/**
	 * Տ̃}XɁC̃}X̏̈ݒ肷
	 * @param r Row coordinate of the cell.
	 * @param c Colmun coordinate of the cell.
	 * @param a The area to set.
	 */
	public void setArea(int r, int c,  Area a) {
		area[r][c] = a;
	}

	public void setArea(Address pos,  Area a) {
		setArea(pos.r(), pos.c(), a);
	}
	/**
	 * zȕꍇ true Ԃ
	 * ̐̋ȓɓ邩C
	 * ̈ɓ邩C
	 * ̈̃}X傫ł΁CtrueԂ
	 * @param r }X̍sW
	 * @param c }X̗W
	 * @return ̃}X̐ł true Ԃ
	 */
	public boolean isError(int r, int c) {
		return isTooClose(r,c) || isMultipleNumber(r,c) || isTooLarge(r,c);
	}
	/**
	 * ̃}XC}X̐ȓɓ邩ǂ𒲂ׂ
	 * @param r }X̍sW
	 * @param c }X̗W
	 * @return }X̐ȓɓꍇ true Ԃ
	 */
	public boolean isTooClose(int r, int c) {
		return multi[r][c] > 1;
	}
	/**
	 * ̃}XƓ̈ɓ邩ǂ𒲂ׂ
	 * @param r }X̍sW
	 * @param c }X̗W
	 * @return ̈ɓꍇ true Ԃ
	 */
	public boolean isMultipleNumber(int r, int c) {
		return multi2[r][c] > 1;
	}
	/**
	 * ̃}X̐C̈ʐς𒴂ĂȂǂ𒲂ׂ
	 * @param r }X̍sW
	 * @param c }X̗W
	 * @return ̈ʐς𒴂̏ꍇ true Ԃ
	 */
	public boolean isTooLarge(int r, int c) {
		return getArea(r,c)!=null && getNumber(r,c) > getArea(r,c).size() ;
	}
	/**
	 * ̍W̉\̃rbgp^[擾
	 * @param r row coordinate
	 * @param c colmun coordinate
	 * @return Returns the pattern.
	 */
	int getPattern(int r, int c){
		return hint.getPattern(r,c);
	}
	/**
	 * ̏ꏊɂ鐔[Ɉᔽɔzu\ǂ𒲂ׂ
	 * @param r }X̍sW
	 * @param c }X̗W
	 * @param n zuł邩ǂ𒲂ׂ鐔
	 * @return zu\Ȃ true@Ԃ
	 */
	boolean canPlace(int r, int c, int n) {
		return hint.canPlace(r, c, n);
	}
	
	/**
	 * Set number to  a cell.
	 * @param r Row coordinate of the cell.
	 * @param c Colmun coordinate of the cell.
	 * @param n The number to set.
	 */
	public void changeNumber(int r, int c, int n) {
		if (getNumber(r,c) == n)
			return;
		int prevNum = getNumber(r,c);
		updateMulti(r, c, n);
		if (getArea(r,c) != null)
			updateMulti2(r, c, n);
		setNumber(r,c,n);
		if (prevNum == 0 && n > 0)
			hint.checkUsedNumber(r, c, n);
		else
			hint.initHint();
	}
	
	public void changeNumber(Address pos, int n) {
		changeNumber(pos.r(), pos.c(), n);
	}
	/**
	 * }Xɐ͂CAhDXi[ɒʒm
	 * @param pos }XW
	 * @param n ͂鐔
	 */
	public void enterNumberA(Address pos, int n) {
		if (n < 0) 
			return;
		if (n == getNumber(pos)) 
			return;
		fireUndoableEditUpdate(
			new CellNumberEditStep(pos, getNumber(pos), n));
		changeNumber(pos, n);
	}

	public void undo(AbstractStep step) {
		CellNumberEditStep s = (CellNumberEditStep) step;
		if (isStable(s.getPos()))
			return;
		changeNumber(s.getPos(), s.getBefore());
	}

	public void redo(AbstractStep step) {
		CellNumberEditStep s = (CellNumberEditStep) step;
		if (isStable(s.getPos()))
			return;
		changeNumber(s.getPos(), s.getAfter());
	}

	/**
	 * V̈ǉ
	 * @param newArea
	 */
	public void addArea(Area newArea) {
		for (Address pos : newArea) {
			area[pos.r()][pos.c()] = newArea;
		}
		areaList.add(newArea);
	}

	/**
	 * ̈폜
	 * @param oldArea
	 */
	public void removeArea(Area oldArea) {
		for (Address pos : oldArea) {
			if (area[pos.r()][pos.c()] == oldArea)
				area[pos.r()][pos.c()] = null;
		}
		areaList.remove(oldArea);
	}
	/**
	 * }Ẍɒǉ
	 * @param r ǉ}X̍sW
	 * @param c ǉ}X̗W
	 * @param area ǉ̈
	 */
	public void addCellToArea(int r, int c, Area area) {
		if (area.isEmpty()) {
			areaList.add(area);
		}
		setArea(r, c, area);
		area.add(r, c);
//		initArea(area);
	}

	public void addCellToArea(Address pos, Area area) {
		addCellToArea(pos.r(), pos.c(), area);
	}
	/**
	 * }Ẍ悩菜
	 * @param r 菜}X̍sW
	 * @param c 菜}X̗W
	 * @param area 菜̈
	 */
	public void removeCellFromArea(int r, int c, Area area) {
		setArea(r, c, null);
		area.remove(r, c);
		if (area.isEmpty()) {
			areaList.remove(area);
		} else {
//			initArea(area);
		}
	}

	public void removeCellFromArea(Address pos, Area area) {
		removeCellFromArea(pos.r(), pos.c(), area);
	}
	/**
	 * @return Returns the areaList.
	 */
	List<Area> getAreaList() {
		return areaList;
	}

	/**
	 * @return Returns the number.
	 */
	int[][] getNumber() {
		return number;
	}
	/**
	 * @return Returns the state.
	 */
	int[][] getState() {
		return state;
	}
	
	public void initBoard() {
		initMulti();
		initMulti2();
		hint.initHint();
	}
	/**
	 * multi[][] 
	 */
	void initMulti() {
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				if(getNumber(r,c)>0)
					initMulti1(r,c,getNumber(r,c));
			}
		}
	}

	private void initMulti1(int r0, int c0, int num) {
		multi[r0][c0] = 1;
		for (int c = c0-num; c <= c0+num; c++) {
			if (c==c0 || !isOn(r0,c)) continue;
			if (getNumber(r0,c) == num) {
				multi[r0][c0]++;
			}
		}
		for (int r = r0-num; r <= r0+num; r++) {
			if (r==r0 || !isOn(r,c0)) continue;
			if (getNumber(r,c0) == num) {
				multi[r0][c0]++;
			}
		}
	}

	/**
	 * }X̐ύXꂽƂɁCɉċ̏d\multizXV
	 * @param r0 ̕ύXꂽ}X̍sW
	 * @param c0 ̕ύXꂽ}X̗W
	 * @param num ύX̐
	 */
	void updateMulti(int r0, int c0, int num) {
		int prevNum = getNumber(r0, c0);
		if (multi[r0][c0]>1) {
			for (int c = c0-prevNum; c <= c0+prevNum; c++) {
				if (c==c0 || !isOn(r0,c))
					continue;
				if (getNumber(r0,c) == prevNum) {
					multi[r0][c]--;
				}
			}
			for (int r = r0-prevNum; r <= r0+prevNum; r++) {
				if (r==r0 || !isOn(r,c0))
					continue;
				if (getNumber(r,c0) == prevNum) {
					multi[r][c0]--;
				}
			}
		}
		if (num==0)
			multi[r0][c0]=0;
		else if (num>0) {
			multi[r0][c0] = 1;
			for (int c = c0-num; c <= c0+num; c++) {
				if (c==c0 || !isOn(r0,c))
					continue;
				if (getNumber(r0,c) == num) {
					multi[r0][c]++;
					multi[r0][c0]++;
				}
			}
			for (int r = r0-num; r <= r0+num; r++) {
				if (r==r0 || !isOn(r,c0))
					continue;
				if (getNumber(r,c0) == num) {
					multi[r][c0]++;
					multi[r0][c0]++;
				}
			}
		}
//			printMulti();
	}
	void initMulti2() {
		for (int r = rows() - 1; r >= 0; r--) {
			for (int c = cols() - 1; c >= 0; c--) {
				if(getNumber(r,c)>0 && getArea(r,c)!=null)
					initMulti21(r,c,getNumber(r,c));
			}
		}
	}
	private void initMulti21(int r0, int c0, int num) {
		multi2[r0][c0] = 1;
		for (Address pos : getArea(r0,c0)) {
			if (pos.equals(r0,c0))
				continue;
			if (getNumber(pos.r(),pos.c()) == num) {
				multi2[r0][c0]++;
			}
		}
	}
	/**
	 * }X̐ύXꂽƂɁCɉė̈̏d\multi2zXV
	 * @param r0 ̕ύXꂽ}X̍sW
	 * @param c0 ̕ύXꂽ}X̗W
	 * @param num ύX̐
	 */
	void updateMulti2(int r0, int c0, int num) {
		int prevNum = getNumber(r0, c0);
		if (multi2[r0][c0]>1) {
			for (Address pos : getArea(r0,c0)) {
				if (pos.equals(r0,c0))
					continue;
				if (getNumber(pos.r(),pos.c()) == prevNum) {
					multi2[pos.r()][pos.c()]--;
				}
			}
		}
		if (num==0)
			multi2[r0][c0]=0;
		else if (num>0) {
			multi2[r0][c0] = 1;
			for (Address pos : getArea(r0,c0)) {
				if (pos.equals(r0,c0))
					continue;
				if (getNumber(pos.r(),pos.c()) == num) {
					multi2[pos.r()][pos.c()]++;
					multi2[r0][c0]++;
				}
			}
		}
	}
	
	public int checkAnswerCode() {
		int result = 0;
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (getNumber(r,c) > 0 && isMultipleNumber(r,c))
					result |= 2;
				if (isTooLarge(r,c))
					result |= 4;
				if (isTooClose(r,c))
					result |= 8;
				if (getNumber(r,c) == 0)
					result |= 1;
			}
		}
		return result;
	}

	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result==0)
			return COMPLETE_MESSAGE;
		if (result==1)
			return Messages.getString("hakyukoka.AnswerCheckMessage1"); //$NON-NLS-1$
		StringBuffer message = new StringBuffer();
		if ((result&2) == 2)
			message.append(Messages.getString("hakyukoka.AnswerCheckMessage2")); //$NON-NLS-1$
		if ((result&4) == 4)
			message.append(Messages.getString("hakyukoka.AnswerCheckMessage3")); //$NON-NLS-1$
		if ((result&8) == 8)
			message.append(Messages.getString("hakyukoka.AnswerCheckMessage4")); //$NON-NLS-1$
		return message.toString();
	}
}
