package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

import javax.swing.JPanel;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SideAddress;
import pencilbox.common.core.Size;


/**
 * yVpYt[[ÑplNX
 * ʃpỸplNX̃X[p[NXƂȂ
 * ̃pYŋʂŗp郁\bhLqĂ
 * epYŌŗL̑̓TuNXŋLq
 */

public class PanelBase extends JPanel implements Printable {

	public static int ANSWER_INPUT_MODE = 0;
	public static int PROBLEM_INPUT_MODE = 1;
	public static int REGION_EDIT_MODE = 3;

	private Size size;

	private int cellSize = 26;
	private int circleSize = 18;
	private int smallCrossSize = 3; // БTCY
	private int linkWidth = 3;

	private int offsetx = 10;
	private int offsety = 10;

	private Color backgroundColor = Color.WHITE;
	private Color boardBorderColor = Color.BLACK;
	private Color gridColor = Color.BLACK;
	private Color numberColor = Color.BLACK;
	private Color indexColor = Color.BLACK;
	private Color errorColor = Color.RED;

	private Color cursorColor = new Color(0xFF0000);
	private Color answerCursorColor = new Color(0x0000FF);

	private Font indexFont = new Font("SansSerif", Font.ITALIC, 13);
	private Font numberFont = new Font("SansSerif", Font.PLAIN, 20);

	private int gridStyle = 1;   // 0:\@PF\
	private int markStyle = 1;
	private boolean indexMode = false;
	private boolean cursorMode = false;
	private CellCursor cellCursor;

	private Area copyRegion = new Area();
	private Area pasteRegion = new Area();
	private Color copyRegionColor = new Color(0xFF0000);
	private Color pasteRegionColor = new Color(0xFFAAAA);
	
	/**
	 * ҏW[h	 
	 */
	private int editMode = 0;

	/**
	 * plRXgN^
	 */
	public PanelBase() {
		setFocusable(true);
	}
	/**
	 * pl̏ݒs
	 * Board Ɗ֘At
	 * @param board Ֆ
	 */
	public void setup(BoardBase board) {
		size = board.getSize();
		updatePreferredSize();
		setBoard(board);
		cellCursor = createCursor();
	}
	/**
	 *  J[\𐶐
	 * @return J[\
	 */
	public CellCursor createCursor() {
		return new CellCursor();
	}
	/**
	 * ʃNX̃plɌʃNX̔Ֆʂݒ肷邽߂̃\bh
	 * eʃNXŃI[o[Ch
	 * @param board Ֆ
	 */
	protected void setBoard(BoardBase board) {
	}

	/**
	 * \TCYύX
	 * @param cellSize }X̃TCY
	 */
	public void setDisplaySize(int cellSize) {
		this.cellSize = cellSize;
		if (indexMode) {
			offsetx = cellSize;
			offsety = cellSize;
		}
		circleSize = (int) (cellSize * 0.7);
		smallCrossSize = (int) (cellSize * 0.15);
		numberFont = new Font("SansSerif", Font.PLAIN, cellSize * 4 / 5);
		indexFont = new Font("SansSerif", Font.ITALIC, cellSize / 2);
		updatePreferredSize();
		repaint();
	}
	/**
	 * r\X^C擾
	 * @return ݂̔ԍ
	 */
	protected int getGridStyle() {
		return gridStyle;
	}
	/**
	 * r\X^Cݒ
	 * @param i ݒ肷ԍ
	 */
	protected void setGridStyle(int i) {
		gridStyle = i;
	}
	/**
	 * @return the markStyle
	 */
	public int getMarkStyle() {
		return markStyle;
	}
	/**
	 * @param markStyle the markStyle to set
	 */
	public void setMarkStyle(int markStyle) {
		this.markStyle = markStyle;
	}
	/**
	 * ݂̔Ֆʂ̏Ԃɍ킹āCsetPreferredSize() s
	 */
	protected void updatePreferredSize() {
		setPreferredSize(getBoardRegionSize());
		revalidate();
	}
	/**
	 * Panel̔Ֆʗ̈敔̃TCY擾
	 */
	public Dimension getBoardRegionSize() {
		return new Dimension(
				offsetx * 2 + cellSize * cols() + 1,
				offsety * 2 + cellSize * rows() + 1);
	}

	/**
	 * @return Returns the problemEditMode.
	 */
	public boolean isProblemEditMode() {
		return editMode == PROBLEM_INPUT_MODE;
	}
	/**
	 * @return the editMode
	 */
	public int getEditMode() {
		return editMode;
	}
	/**
	 * @param editMode the editMode to set
	 */
	public void setEditMode(int editMode) {
		this.editMode = editMode;
	}
	/**
	 * ݂̉]Ԃɉs擾
	 * @return pl̔Ֆʂ̍s 
	 */
	public int rows() {
		return size.getRows();
	}
	/**
	 * ݂̉]Ԃɉ񐔂擾
	 * @return pl̔Ֆʂ̗
	 */
	public int cols() {
		return size.getCols();
	}

	/*
	 * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
	 */
	protected void paintComponent(Graphics g) {
		super.paintComponent(g);
		drawPanel((Graphics2D) g);
	}
	/**
	 * pl`悷B
	 * ʕ\pCpC摜쐬pŋʂɎgpB
	 * @param g
	 */
	public void drawPanel(Graphics2D g) {
		g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
		paintBackground(g);
		drawBoard(g);
		if (editMode == REGION_EDIT_MODE)
			drawCopyPasteRegion(g);
		else 
			drawCursor(g);
		drawIndex(g);
	}
	
	/**
	 * plɔՖʂ`悷
	 * X̃TuNXŎB
	 * @param g
	 */
	public void drawBoard(Graphics2D g) {
	}

	/**
	 * Panel̗WsNZxWɕϊ
	 * @param c Panel̗W
	 * @return ϊ̃sNZW
	 */
	public final int toX(int c) {
		return getOffsetx() + getCellSize() * c;
	}
	/**
	 * Panel̗WsNZyWɕϊ
	 * @param r Panel̍sW
	 * @return ϊ̃sNZW
	 */
	public final int toY(int r) {
		return getOffsety() + getCellSize() * r;
	}

	/**
	 * PanelxsNZW}XWɕϊ
	 * @param x Panel̃sNZWx
	 * @return Wɕϊl
	 */
	private final int toC(int x) {
		return (x + getCellSize() - getOffsetx()) / getCellSize() - 1;
	}
	/**
	 * Panel̂sNZWs}XWɕϊ
	 * @param y Panel̃sNZWy
	 * @return }XWɕϊl
	 */
	private final int toR(int y) {
		return (y + getCellSize() - getOffsety()) / getCellSize() - 1;
	}

	/**
	 * ̃sNZẄʒũ}XW擾B
	 * @param x
	 * @param y
	 * @return
	 */
	public Address pointToAddress(int x, int y) {
		int r = toR(y);
		int c = toC(x);
		return Address.address(r, c);
	}

	/**
	 * ̃sNZWɍł߂ӍW擾B
	 *                [H, r-1, c]
	 *              @@
	 *                _@^@
	 * [V, r, c-1]  b@E@b [V, r, c] 
	 *                ^@_@
	 *              @@
	 *                [H, r, c]
	 * @param x
	 * @param y
	 * @return
	 */
	public SideAddress pointToSideAddress(int x, int y) {
		int r = toR(y);
		int c = toC(x);
		int resx = x - getOffsetx() - getCellSize() * c;
		int resy = y - getOffsety() - getCellSize() * r;
		if (resx + resy < getCellSize()) {
			if (resx < resy)
				return SideAddress.sideAddress(Direction.VERT, r, c-1);
			else
				return SideAddress.sideAddress(Direction.HORIZ, r-1, c);
		} else {
			if (resy < resx)
				return SideAddress.sideAddress(Direction.VERT, r, c);
			else
				return SideAddress.sideAddress(Direction.HORIZ, r, c);
		}
	}

	/*
	 * Ֆʈꕔ`p\bhQ
	 */
	/**
	 * Ֆʂ̔wi backgraoundColor œhԂ
	 * @param g
	 */
	public void paintBackground(Graphics2D g) {
		g.setColor(backgroundColor);
		g.fillRect(offsetx, offsety, cellSize * cols(), cellSize * rows());
	}
	/**
	 * Ֆʂ̊Og`
	 * @param g
	 */
	public void drawBoardBorder(Graphics2D g) {
		g.setColor(boardBorderColor);
		for (int i=0; i<=1; i++)
			g.drawRect(offsetx - i, offsety - i, cellSize * cols() + i + i,	cellSize * rows() + i + i);
	}
	/**
	 * r`
	 * @param g
	 */
	public void drawGrid(Graphics2D g) {
		if (getGridStyle() == 0)
			return;
		g.setColor(gridColor);
		for (int r = 1; r < rows(); r++) {
			g.drawLine(toX(0), toY(r), toX(cols()), toY(r));
		}
		for (int c = 1; c < cols(); c++) {
			g.drawLine(toX(c), toY(0), toX(c), toY(rows()));
		}
	}
	/**
	 * Ֆʂ̏ƍ̒[ɍW`
	 * @param g
	 */
	public void drawIndex(Graphics2D g) {
		int firstIndex = 1;
		g.setFont(indexFont);
		g.setColor(indexColor);
		if (isIndexMode() == false)
			return;
		for (int r = 0; r < rows(); r++) {
			placeIndexNumber(g, r, -1, r + firstIndex);
		}
		for (int c = 0; c < cols(); c++) {
			placeIndexNumber(g, -1, c, c + firstIndex);
		}
	}
	/**
	 * J[\`
	 * @param g
	 */
	public void drawCursor(Graphics2D g) {
		if (isProblemEditMode()) {
			g.setColor(cursorColor);
		} else if (cursorMode) {
			g.setColor(answerCursorColor);
		} else {
			return;
		}
		for (int i = 0; i <= 2; i++)
			g.drawRect(toX(cellCursor.c())+i, toY(cellCursor.r())+i, cellSize-i-i, cellSize-i-i);
	}
	/*
	 * }``̂߂̃\bhQ
	 */
	/**
	 * ̍W܂͏̒[_ƂāCẐPӂ̒Ɠ̉܂͏c̐`B
	 * @param g
	 * @param x [_xW
	 * @param y [_yW
	 * @param direction c Ȃ c̐C  Ȃ ̐ 
	 * @param w 
	 */
	public void drawLineSegment(Graphics g, int x, int y, int direction, int w) {
		if (w == 1) {
			if (direction == Direction.HORIZ)
				g.fillRect(x - w/2, y - w/2, cellSize + w, w);
			else if (direction == Direction.VERT)
				g.fillRect(x - w/2, y - w/2, w, cellSize + w);
		} else if (w > 1) { // pPsNZƂ
			if (direction == Direction.HORIZ)
				g.fillRect(x - (w-2)/2, y - w/2, cellSize + w-2, w);
			else if (direction == Direction.VERT)
				g.fillRect(x - w/2, y - (w-2)/2, w, cellSize + w-2);
		}
	}
	/**
	 * ̍W܂͏̒[_ƂāCẐPӂ̒̉܂͏c̐`
	 * @param g
	 * @param x SxW
	 * @param y SyW
	 * @param direction c Ȃ c̐C  Ȃ ̐ 
	 */
	public void drawLineSegment(Graphics g, int x, int y, int direction) {
		drawLineSegment(g, x, y, direction, 3);
	}
	/**
	 * ̓_𒆐SɁC̑傫̎lp` i傫@halfSize*2+1j
	 * @param g
	 * @param x   SxW
	 * @param y   SyW
	 * @param halfSize  傫iБj
	 */
	public void fillSquare(Graphics g, int x, int y, int halfSize) {
		g.fillRect(x - halfSize, y - halfSize, halfSize + halfSize + 1, halfSize + halfSize + 1);
	}
	/**
	 * ̓_𒆐SɁC̑傫̃oc`
	 * @param g
	 * @param x    SxW
	 * @param y    SyW
	 * @param halfSize 傫iБj
	 */
	public void drawCross(Graphics g, int x, int y, int halfSize) {
		g.drawLine(x - halfSize, y - halfSize, x + halfSize, y + halfSize);
		g.drawLine(x - halfSize, y + halfSize, x + halfSize, y - halfSize);
	}
	/**
	 * S̍WƔa^āC~`
	 * @param g
	 * @param x SxW
	 * @param y SyW
	 * @param radius a
	 */
	public void drawCircle(Graphics g, int x, int y, int radius) {
		g.drawOval(x-radius, y-radius, radius+radius, radius+radius);
	}
	/**
	 * S̍WƔa^āChԂ~`B
	 * @param g
	 * @param x SxW
	 * @param y SyW
	 * @param radius a
	 */
	public void fillCircle(Graphics g, int x, int y, int radius) {
		g.fillOval(x-radius, y-radius, radius+radius+1, radius+radius+1);		
	}
	/**
	 * ̍W𒆐SƂĕ`
	 * @param g
	 * @param x SxW
	 * @param y SyW
	 * @param str `
	 */
	public void drawString(Graphics g, int x, int y, String str) {
		FontMetrics metrics = g.getFontMetrics();
		g.drawString(
				str,
				x - metrics.stringWidth(str) / 2,
				y - metrics.getHeight() / 2 + metrics.getAscent());
	}

	/*
	 * }X̓e`悷邽߂̃\bhQ
	 * }X̍W^ƁC̃Z̓e`悷D
	 * ȉ̃\bhpӂĂ
	 * `
	 * hԂ
	 * `
	 * `
	 * ~`
	 * ܂͏c`
	 */
	/**
	 * }X̒ɕzu
	 * @param g
	 * @param r Ֆʏ̍sW
	 * @param c Ֆʏ̗W
	 * @param string `
	 */
	public void placeString(Graphics2D g, int r, int c, String string) {
		drawString(g, toX(c) + getHalfCellSize(), toY(r) + getHalfCellSize(), string);
	}
	/**
	 * }Xɕzu
	 * @param g
	 * @param r Ֆʏ̍sW
	 * @param c Ֆʏ̗W
	 * @param letter `
	 */
	public void placeLetter(Graphics2D g, int r, int c, char letter) {
		placeString(g, r, c, Character.toString(letter));
	}
	/**
	 * }Xɐzu
	 * @param g
	 * @param r Ֆʏ̍sW
	 * @param c Ֆʏ̗W
	 * @param number `
	 */
	public void placeNumber(Graphics2D g, int r, int c, int number) {
		placeString(g, r, c, Integer.toString(number));
	}
	/**
	 * }Xɐzu
	 * @param g
	 * @param r Ֆʏ̍sW
	 * @param c Ֆʏ̗W
	 * @param number `
	 */
	public void placeIndexNumber(Graphics2D g, int r, int c, int number) {
		placeString(g, r, c, Integer.toString(number));
	}
	/**
	 * }XhԂ
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 */
	public void paintCell(Graphics2D g, int r, int c) {
		g.fillRect(toX(c), toY(r), getCellSize(), getCellSize());
	}

	/**
	 * }XɁzu
	 * 傫̓NXŒ߂Wl
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 */
	public void placeCircle(Graphics2D g, int r, int c) {
		placeCircle(g, r, c, getCircleSize());
	}
	/**
	 * }XɁzu
	 * 傫Ŏw肷
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 * @param circleSize zu遛̒a
	 */
	public void placeCircle(Graphics2D g, int r, int c, int circleSize) {
		drawCircle(g, toX(c) + getHalfCellSize(), toY(r) + getHalfCellSize(),
				circleSize / 2);
	}
	/**
	 * }Xɐ2́zu
	 * 傫̓NXŒ߂Wl
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 */
	public void placeBoldCircle(Graphics2D g, int r, int c) {
		placeBoldCircle(g, r, c, getCircleSize());
	}
	/**
	 * }Xɐ2́zu
	 * 傫Ŏw肷
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 * @param circleSize zu遛̒a
	 */
	public void placeBoldCircle(Graphics2D g, int r, int c, int circleSize) {
		int x = toX(c) + getHalfCellSize();
		int y = toY(r) + getHalfCellSize();
		drawCircle(g, x, y, circleSize / 2);
		drawCircle(g, x, y, circleSize / 2 - 1);
	}
	/**
	 * }XɓhԂzu
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 */
	public void placeFilledCircle(Graphics2D g, int r, int c) {
		placeFilledCircle(g, r, c, getCircleSize());
	}
	/**
	 * }XɓhԂzu
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 * @param circleSize zu遜̒a
	 */
	public void placeFilledCircle(Graphics2D g, int r, int c, int circleSize) {
		fillCircle(g, toX(c) + getHalfCellSize(), toY(r) + getHalfCellSize(),
				circleSize / 2);
	}
	/**
	 * }X̒Ɂzu
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 */
	public void placeFilledSquare(Graphics2D g, int r, int c) {
		fillSquare(g, toX(c) + getHalfCellSize(), toY(r) + getHalfCellSize(), getSmallCrossSize());
	}
	/**
	 * }XɁ~zu
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 */
	public void placeCross(Graphics2D g, int r, int c) {
		drawCross(g, toX(c) + getHalfCellSize(), toY(r) + getHalfCellSize(),
				getSmallCrossSize());
	}
	/**
	 * ӏɐzu
	 * @param g
	 * @param d ӍW
	 * @param r ӍW
	 * @param c ӍW
	 * @param w 
	 */
	public void placeSideLine(Graphics2D g, int d, int r, int c, int w) {
		if (d == Direction.VERT)
			drawLineSegment(g, toX(c + 1), toY(r), d, w);
		else if (d == Direction.HORIZ)
			drawLineSegment(g, toX(c), toY(r + 1), d, w);
	}

	public void placeSideLine(Graphics2D g, int d, int r, int c) {
		placeSideLine(g, d, r, c, 3);
	}
	/**
	 * ӏɐzuB}XƂ̃}X猩ӂ̌Ŏw肷B
	 * @param g
	 * @param pos }X
	 * @param dir }X̂ǂ̌̕ӂ
	 */
	public void placeSideLineJ(Graphics2D g, Address pos, int dir, int w) {
		if (dir == Direction.UP)
			placeSideLine(g, Direction.HORIZ, pos.r()-1, pos.c(), w);		
		else if (dir == Direction.LT)
			placeSideLine(g, Direction.VERT, pos.r(), pos.c()-1, w);		
		else if (dir == Direction.DN)
			placeSideLine(g, Direction.HORIZ, pos.r(), pos.c(), w);		
		else if (dir == Direction.RT)
			placeSideLine(g, Direction.VERT, pos.r(), pos.c(), w);		
	}
	
	/**
	 * ӂƌzu
	 * @param g
	 * @param d ӍW
	 * @param r ӍW
	 * @param c ӍW
	 */
	public void placeLink(Graphics2D g, int d, int r, int c) {
		drawLineSegment(g, toX(c) + getHalfCellSize(), toY(r) + getHalfCellSize(), d ^ 1, getLinkWidth());
	}
	/**
	 * ӏɁ~zu
	 * @param g
	 * @param d ӍW
	 * @param r ӍW
	 * @param c ӍW
	 */
	public void placeSideCross(Graphics2D g, int d, int r, int c) {
		if (d == Direction.VERT)
			drawCross(g, toX(c + 1), toY(r) + getHalfCellSize(), smallCrossSize);
		else if (d == Direction.HORIZ)
			drawCross(g, toX(c) + getHalfCellSize(), toY(r + 1), smallCrossSize);
	}
	/**
	 * }X̒Sɉ܂͏c̐zu
	 * @param g
	 * @param r
	 * @param c
	 * @param dir
	 */
	public void placeCenterLine(Graphics2D g, int r, int c, int dir) {
		if (dir == Direction.HORIZ)
			drawLineSegment(g, toX(c), toY(r) + getHalfCellSize(), dir, 1);
		else if (dir == Direction.VERT)
			drawLineSegment(g, toX(c) + getHalfCellSize(), toY(r), dir, 1);
	}
	/**
	 * lpzu 
	 * @param g 
	 * @param r0 ՖʍsW
	 * @param c0 ՖʗW
	 * @param r1 ՖʍsW
	 * @param c1 ՖʗW
	 */
	public void placeSquare(Graphics2D g, int r0, int c0, int r1, int c1) {
		for (int i = 0; i <= 1; i++)
			g.drawRect(
				toX((c0 < c1) ? c0 : c1) + i,
				toY((r0 < r1) ? r0 : r1) + i,
				getCellSize() * ((c0 < c1) ? c1-c0+1 : c0-c1+1) - i*2,
				getCellSize() * ((r0 < r1) ? r1-r0+1 : r0-r1+1) - i*2);
	}

	/**
	 * }X̉ 
	 * @param g 
	 * @param r0 ՖʍsW
	 * @param c0 ՖʗW
	 */
	public void edgeCell(Graphics2D g, int r0, int c0) {
		g.drawRect(toX(c0), toY(r0), getCellSize(), getCellSize());
	}

	/**
	 * }X̉ 
	 * @param g
	 * @param r0 ՖʍsW
	 * @param c0 ՖʗW
	 * @param w@
	 */
	public void edgeCell(Graphics2D g, int r0, int c0, int w) {
		for (int i = 0; i < w; i++) {
			g.drawRect(toX(c0)+i, toY(r0)+i, getCellSize()-i-i, getCellSize()-i-i);
		}
	}

	/**
	 * }Xɔ}XmiȂǁjLzu 傫̓NXŒ߂Wl
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 */
	public void placeMark(Graphics2D g, int r, int c) {
		switch (getMarkStyle()) {
		case 1:
			placeCircle(g, r, c);
			break;
		case 2:
			placeFilledCircle(g, r, c);
			break;
		case 3:
			placeFilledSquare(g, r, c);
			break;
		case 4:
			placeCross(g, r, c);
			break;
		case 5:
			paintCell(g, r, c);
			break;
		}
	}

	/* 
	 * Ֆʈp\bh
	 * ͎gpȂ
	 * @see java.awt.print.Printable#print(java.awt.Graphics, java.awt.print.PageFormat, int)
	 */
	public int print(Graphics g, PageFormat pf, int page)
		throws PrinterException {
		if (page >= 1)
			return Printable.NO_SUCH_PAGE;
		Graphics2D g2 = (Graphics2D) g;
		drawPanel(g2);
		return Printable.PAGE_EXISTS;
	}
	/**
	 * @param cellSize The cellSize to set.
	 */
	public void setCellSize(int cellSize) {
		this.cellSize = cellSize;
	}
	/**
	 * @return Returns the cellSize.
	 */
	public int getCellSize() {
		return cellSize;
	}
	/**
	 * @return Returns the halfCellSize.
	 */
	public int getHalfCellSize() {
		return cellSize / 2;
	}
	/**
	 * @param circleSize The circleSize to set.
	 */
	public void setCircleSize(int circleSize) {
		this.circleSize = circleSize;
	}
	/**
	 * @return Returns the circleSize.
	 */
	public int getCircleSize() {
		return circleSize;
	}
	/**
	 * @param smallCrossSize The smallCrossSize to set.
	 */
	public void setSmallCrossSize(int smallCrossSize) {
		this.smallCrossSize = smallCrossSize;
	}
	/**
	 * @return Returns the smallCrossSize.
	 */
	public int getSmallCrossSize() {
		return smallCrossSize;
	}

	public void setLinkWidth(int linkWidth) {
		this.linkWidth = linkWidth;
	}

	public int getLinkWidth() {
		return linkWidth;
	}
	/**
	 * @param offsetx The offsetx to set.
	 */
	public void setOffsetx(int offsetx) {
		this.offsetx = offsetx;
	}
	/**
	 * @return Returns the offsetx.
	 */
	public int getOffsetx() {
		return offsetx;
	}
	/**
	 * @param offsety The offsety to set.
	 */
	public void setOffsety(int offsety) {
		this.offsety = offsety;
	}
	/**
	 * @return Returns the offsety.
	 */
	public int getOffsety() {
		return offsety;
	}
	/**
	 * @param backgroundColor The backgroundColor to set.
	 */
	public void setBackgroundColor(Color backgroundColor) {
		this.backgroundColor = backgroundColor;
	}
	/**
	 * @return Returns the backgroundColor.
	 */
	public Color getBackgroundColor() {
		return backgroundColor;
	}
	/**
	 * @param boardBorderColor The boardBorderColor to set.
	 */
	public void setBoardBorderColor(Color boardBorderColor) {
		this.boardBorderColor = boardBorderColor;
	}
	/**
	 * @return Returns the boardBorderColor.
	 */
	public Color getBoardBorderColor() {
		return boardBorderColor;
	}
	/**
	 * @param gridColor The gridColor to set.
	 */
	public void setGridColor(Color gridColor) {
		this.gridColor = gridColor;
	}
	/**
	 * @return Returns the gridColor.
	 */
	public Color getGridColor() {
		return gridColor;
	}
	/**
	 * @param numberColor The numberColor to set.
	 */
	public void setNumberColor(Color numberColor) {
		this.numberColor = numberColor;
	}
	/**
	 * @return Returns the numberColor.
	 */
	public Color getNumberColor() {
		return numberColor;
	}
	/**
	 * @return Returns the errorColor.
	 */
	public Color getErrorColor() {
		return errorColor;
	}
	/**
	 * @param cursorColor The cursorColor to set.
	 */
	public void setCursorColor(Color cursorColor) {
		this.cursorColor = cursorColor;
	}
	/**
	 * @return Returns the cursorColor.
	 */
	public Color getCursorColor() {
		return cursorColor;
	}
	/**
	 * @param cursorMode The cursorMode to set.
	 */
	public void setCursorMode(boolean cursorMode) {
		this.cursorMode = cursorMode;
	}
	/**
	 * @return Returns the cursorMode.
	 */
	public boolean isCursorMode() {
		return cursorMode;
	}
	/**
	 * @param numberFont The numberFont to set.
	 */
	protected void setNumberFont(Font numberFont) {
		this.numberFont = numberFont;
	}
	/**
	 * @return Returns the numberFont.
	 */
	protected Font getNumberFont() {
		return numberFont;
	}
	/**
	 * @param cellCursor The cellCursor to set.
	 */
	protected void setCellCursor(CellCursor cellCursor) {
		this.cellCursor = cellCursor;
	}
	/**
	 * @return Returns the cellCursor.
	 */
	protected CellCursor getCellCursor() {
		return cellCursor;
	}
	/**
	 * @return the indexMode
	 */
	public boolean isIndexMode() {
		return indexMode;
	}
	/**
	 * @param indexMode the indexMode to set
	 */
	public void setIndexMode(boolean indexMode) {
		this.indexMode = indexMode;
	}

	/**
	 * @param b the indexMode to set
	 */
	public void changeIndexMode(boolean b) {
		this.indexMode = b;
		if (b == true) {
			setOffsetx(this.getCellSize());
			setOffsety(this.getCellSize());
		} else {
			setOffsetx(10);
			setOffsety(10);
		}
		updatePreferredSize();
	}
	
	/**
	 * @return the copyRegion
	 */
	Area getCopyRegion() {
		return copyRegion;
	}
	/**
	 * @return the pasteRegion
	 */
	Area getPasteRegion() {
		return pasteRegion;
	}
	
	/**
	 * üҏW[hvł̕ҏẄ\B
	 * @param g
	 */
	protected void drawCopyPasteRegion(Graphics2D g) {
		g.setColor(copyRegionColor);
		edgeArea(g, copyRegion);
		g.setColor(pasteRegionColor);
		edgeArea(g, pasteRegion);
	}

	/**
	 * ̈̉ 
	 * ̈̊O𑾐ŁC̈̃}Xאŕ`悷
	 * @param g
	 * @param area ̈
	 */
	public void edgeArea(Graphics2D g, Area area) {
		for (Address pos : area) {
			for (int dir = 0; dir < 4; dir++) {
				Address neighbor = Address.nextCell(pos, dir);
				if (area.contains(neighbor)) {
					if (dir >=2)
						placeSideLineJ(g, pos, dir, 1);
				} else {
					placeSideLineJ(g, pos, dir, 3);
				}
			}
		}
	}
}

