package pencilbox.bijutsukan;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;


/**
 * upفvՖʃNX
 */
public class Board extends BoardBase {

	static final int NONUMBER_WALL = 5;
	static final int BULB = -2;
	static final int NOBULB = -3;
	static final int UNKNOWN = -1;
	static final int OUTER = 6;

	private int[][] state;
	private int[][] illuminatedH;
	private int[][] illuminatedV;

	protected void setup() {
		super.setup();
		state = new int[rows()][cols()]; 
		illuminatedV = new int[rows()][cols()];
		illuminatedH = new int[rows()][cols()];
		ArrayUtil.initArrayInt2(state, UNKNOWN);
	}
	
	public void clearBoard() {
		super.clearBoard();
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (isFloor(r, c)) {
					setState(r,c,UNKNOWN);
				}
			}
		}
		initBoard();
	}

	public void trimAnswer() {
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (getState(r, c) == NOBULB)
					setState(r, c, UNKNOWN);
				}
		}
	}

	public void initBoard() {
		initIlluminations();
	}
	/**
	 * ݂̏ƖzuƂɁCilluminatedV illuminatedHĐݒ肷
	 */
	void initIlluminations() {
		ArrayUtil.initArrayInt2(illuminatedV, 0);
		ArrayUtil.initArrayInt2(illuminatedH, 0);
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (isBulb(r,c)) {
					illuminate(r, c, true);
				}
			}
		}
	}
	/**
	 * @return Returns the state.
	 */
	int[][] getState() {
		return state;
	}
	/**
	 * }X̏Ԃ擾 
	 * @param r sW
	 * @param c W
	 * @return 
	 */
	public int getState(int r, int c) {
		if (isOn(r,c)) return state[r][c];
		else return OUTER;
	}
	
	public int getState(Address pos) {
		return getState(pos.r(), pos.c());
	}
	/**
	 * }X̏Ԃ݂̂ݒ肷
	 * @param r sW
	 * @param c W
	 * @param st 
	 */
	public void setState(int r, int c, int st) {
		state[r][c] = st;
	}
	
	public void setState(Address pos, int st) {
		setState(pos.r(), pos.c(), st);
	}
	/**
	 * ̃}Xǂǂ
	 * @param r sW
	 * @param c W
	 * @return ǂȂ true
	 */
	public boolean isWall(int r, int c){
		return state[r][c]>=0 && state[r][c]<=4 || state[r][c]==NONUMBER_WALL;
	}
	
	public boolean isWall(Address pos) {
		return isWall(pos.r(), pos.c());
	}
	/**
	 * ̃}X̕ǂǂ
	 * @param r sW
	 * @param c W
	 * @return ǂȂ true
	 */
	public boolean isNumberedWall(int r, int c){
		return state[r][c]>=0 && state[r][c]<=4;
	}
	/**
	 * ̃}Xǂ̂Ȃ}Xǂ
	 * @param r sW
	 * @param c W
	 * @return ՓłǂłȂȂ true
	 */
	public boolean isFloor(int r, int c){
		return isOn(r,c) && (state[r][c] == UNKNOWN || state[r][c] == NOBULB || state[r][c] == BULB);
	}
	/**
	 * ̃}XɏƖuĂ邩ǂ
	 * @param r sW
	 * @param c W
	 * @return ƖuĂȂ true
	 */
	public boolean isBulb(int r, int c){
		return isOn(r,c) && state[r][c] == BULB;
	}
	/**
	 * ̃}X̏Ɩzu肩ǂ
	 * @param r sW
	 * @param c W
	 * @return Ȃ true
	 */
	public boolean isUnknown(int r, int c) {
		return state[r][c] == UNKNOWN;
	}
	/**
	 * ̃}XƂ炳Ă邩
	 * @param r sW
	 * @param c W
	 * @return Ȃ true
	 */
	public int getHorizIlluminated(int r, int c) {
		return illuminatedH[r][c];
	}
	/**
	 * ̃}XcƂ炳Ă邩
	 * @param r sW
	 * @param c W
	 * @return Ȃ true
	 */
	public int getVertIlluminated(int r, int c) {
		return illuminatedV[r][c];
	}
	/**
	 * ̃}X̏̕ƖɂƂ炳Ă邩HHH
	 * @param r sW
	 * @param c W
	 * @return Ȃ true
	 */
	public boolean isMultiIlluminated(int r, int c) {
		return illuminatedV[r][c]>1 || illuminatedH[r][c] > 1;
	}
	/**
	 * }XƂ炳Ă邩C܂肻̃}X̏㉺EɏƖ邩𒲂ׂ
	 * @param r sW
	 * @param c W
	 * @return Ƃ炳Ă true
	 */
	public boolean isIlluminated(int r, int c) {
			return (illuminatedV[r][c] > 0 || illuminatedH[r][c] > 0);
	}
	/**
	 * }X̏ƖzuύXꂽꍇɁC㉺ĚXV
	 * @param r0 ƖzuύXꂽ}X̍sW
	 * @param c0 ƖzuύXꂽ}X̗W
	 * @param on ƖzuꂽƂɂ true, 菜ꂽƂ false 
	 */
	private void illuminate(int r0, int c0, boolean on) {
		int k = on ? 1 : -1;
		int r = r0;
		int c = c0;
		while (isFloor(r, c)) {
			r--;
		}
		r++;
		while (isFloor(r, c)) {
			illuminatedV[r][c] += k;
			r++;
		}
		r = r0;
		while(isFloor(r,c)) {
			c--;
		}
		c++;
		while(isFloor(r,c)) {
			illuminatedH[r][c] += k;
			c++;
		}
	}

	/**
	 * }X̏㉺S̖肩̏ƖԂׂčXV
	 * @param r0 S}X̍sW
	 * @param c0 S}X̗W
	 * @param on Ƃ true, Ƃ false 
	 */
	private void illuminate4(int r0, int c0, boolean on) {
		for (int d = 0; d < 4; d++) {
			Address p = Address.address(r0, c0);
			p = p.nextCell(d);
			while (isFloor(p.r(), p.c())) {
				if (isBulb(p.r(), p.c()))
					illuminate(p.r(), p.c(), on);
				p = p.nextCell(d);
			}
		}
	}

	/**
	 * }X̏Ԃݒ肷
	 * }X̌XV
	 * }X𑀍삵Ƃ́A㉺S̖肩̏ƖԂׂčXV
	 * @param r sW
	 * @param c W
	 * @param st 
	 */
	public void changeState(int r, int c, int st) {
		int prev = getState(r, c);
		if ((st >= 0 && st <= 4 || st == NONUMBER_WALL)
				|| (prev >= 0 && prev <= 4 || prev == NONUMBER_WALL)) {
			illuminate4(r, c, false);
		}
		if (st == BULB && prev != BULB)
			illuminate(r, c, true);
		else if (prev == BULB && st != BULB)
			illuminate(r, c, false);
		setState(r, c, st);
		if ((st>=0 && st<=4 || st == NONUMBER_WALL)
				|| (prev>=0 && prev<=4 || prev == NONUMBER_WALL)) {
			illuminate4(r, c, true);
		}
	}

	public void changeState(Address pos, int st) {
		changeState(pos.r(), pos.c(), st);
	}
	/**
	 * }X̏Ԃw肵ԂɕύXCύXAhDXi[ɒʒm
	 * @param pos }XW
	 * @param st ύX̏
	 */
	public void changeStateA(Address pos, int st) {
		fireUndoableEditUpdate(new CellEditStep(pos, getState(pos), st));
		changeState(pos, st);
	}

	public void undo(AbstractStep step) {
		CellEditStep s = (CellEditStep) step;
		changeState(s.getPos(), s.getBefore());
	}

	public void redo(AbstractStep step) {
		CellEditStep s = (CellEditStep) step;
		changeState(s.getPos(), s.getAfter());
	}

	 /**
	 * אڂS}X̏Ɩ𒲂ׂ
	 * @param r sW
	 * @param c W
	 * @return אڂS}X̏Ɩ
	 */
	public int countAdjacentBulbs(int r, int c) {
		int count = 0;
		if (isBulb(r-1,c)) count++;
		if (isBulb(r+1,c)) count++;
		if (isBulb(r,c-1)) count++;
		if (isBulb(r,c+1)) count++;
		return count;
	}
	/**
	 * ǂɗאڂ4}X̏Ɩǂ𒲍
	 * @param r sW
	 * @param c W
	 * @return ƖƓȂC1, 
	 * ƖȂ -1, 
	 * Ɩ菬Ȃ 0
	 */
	public int checkAdjacentBulbs(int r, int c) {
		int nBulb = countAdjacentBulbs(r,c);
		int number = getState(r,c);
		if (nBulb > number) {
			return -1;
		} else if (nBulb == number) {
			return 1;
		} else if (nBulb < number) {
			return 0;
		}
		return 0;
	}

	public int checkAnswerCode() {
		int result = 0;
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (!isWall(r,c)) {
					if (isMultiIlluminated(r,c)) {
						result |= 1;
					}
					else if (!isIlluminated(r,c)) {
						result |= 2;
					}
				}
				else if (isNumberedWall(r,c)) {
					if (countAdjacentBulbs(r,c) > getState(r,c)) {
						result |= 4;
					}
					else if (countAdjacentBulbs(r,c) < getState(r,c)) {
						result |= 8;
					}
				}
			}
		}
		return result;
	}
	
	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result==0)
			return BoardBase.COMPLETE_MESSAGE;
		StringBuffer message = new StringBuffer();
		if ((result&1) == 1)
			message.append(ERR_MULTI_ILLUMINATION);
		if ((result&2) == 2)
			message.append(YET_NOT_ILLUMINATED);
		if ((result&4) == 4 || (result&8) == 8)
			message.append(ERR_WRONG_NUMBER);
		return message.toString();
	}

	static final String ERR_MULTI_ILLUMINATION = Messages.getString("bijutsukan.AnswerCheckMessage1"); //$NON-NLS-1$
	static final String YET_NOT_ILLUMINATED = Messages.getString("bijutsukan.AnswerCheckMessage2"); //$NON-NLS-1$
	static final String ERR_WRONG_NUMBER =  Messages.getString("bijutsukan.AnswerCheckMessage3"); //$NON-NLS-1$
}
