/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.shikaku.Board;
import pencilbox.shikaku.Square;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private Color areaBorderColor = new Color(153);
    private Color smallSizeColor = new Color(0xFFFF99);
    private Color areaPaintColor = new Color(0xAAFFFF);
    private Color draggingAreaColor = new Color(0xCCFFFF);
    private Square draggingSquare;
    private boolean separateAreaColorMode = false;
    private boolean indicateErrorMode = false;

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getAreaPaintColor() {
        return this.areaPaintColor;
    }

    public void setAreaPaintColor(Color areaPaintColor) {
        this.areaPaintColor = areaPaintColor;
    }

    public boolean isSeparateAreaColorMode() {
        return this.separateAreaColorMode;
    }

    public void setSeparateAreaColorMode(boolean separateAreaColorMode) {
        this.separateAreaColorMode = separateAreaColorMode;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public void drawBoard(Graphics2D g) {
        this.paintAreas(g);
        this.drawNumbers(g);
        this.drawGrid(g);
        this.drawAreaBorders(g);
        this.drawBoardBorder(g);
    }

    private void paintAreas(Graphics2D g) {
        Square square;
        int c;
        int r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                square = this.board.getSquare(r, c);
                if (square != null) {
                    g.setColor(this.areaPaintColor);
                    if (this.isIndicateErrorMode()) {
                        int number = square.getNumber();
                        if (number == -2) {
                            g.setColor(this.getErrorColor());
                        } else if (number == 0) {
                            g.setColor(this.smallSizeColor);
                        } else if (number == -1) {
                            g.setColor(this.areaPaintColor);
                        } else if (number < square.getSquareSize()) {
                            g.setColor(this.getErrorColor());
                        } else if (number == square.getSquareSize()) {
                            g.setColor(this.areaPaintColor);
                        } else if (number > square.getSquareSize()) {
                            g.setColor(this.smallSizeColor);
                        }
                    } else if (this.isSeparateAreaColorMode()) {
                        g.setColor(Colors.getBrightColor(this.board.getSquare(r, c).getId()));
                    }
                    this.paintCell(g, r, c);
                }
                ++c;
            }
            ++r;
        }
        square = this.getDraggingSquare();
        if (square != null) {
            r = square.r0();
            while (r <= square.r1()) {
                c = square.c0();
                while (c <= square.c1()) {
                    g.setColor(this.draggingAreaColor);
                    this.paintCell(g, r, c);
                    ++c;
                }
                ++r;
            }
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int number = this.board.getNumber(r, c);
                if (number > 0 || number == -1) {
                    g.setColor(this.getNumberColor());
                    super.placeFilledCircle(g, r, c, (int)((double)this.getCellSize() * 0.85));
                }
                if (number > 0) {
                    g.setColor(this.getBackgroundColor());
                    super.placeNumber(g, r, c, number);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawAreaBorders(Graphics2D g) {
        Square square2;
        g.setColor(this.getAreaBorderColor());
        for (Square square2 : this.board.getSquareList()) {
            this.placeSquare(g, square2.r0(), square2.c0(), square2.r1(), square2.c1());
        }
        square2 = this.getDraggingSquare();
        if (square2 != null) {
            this.placeSquare(g, square2.r0(), square2.c0(), square2.r1(), square2.c1());
        }
    }

    void setDraggingSquare(Square draggingSquare) {
        this.draggingSquare = draggingSquare;
    }

    Square getDraggingSquare() {
        return this.draggingSquare;
    }
}

