/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.kakuro.Board;
import pencilbox.kakuro.KakuroCursor;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(9);
    }

    protected int getMaxInputNumber() {
        if (this.isProblemEditMode()) {
            return 45;
        }
        return 9;
    }

    protected void leftPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isWall(pos))) {
            int n = this.board.getNumber(pos);
            if (n >= this.board.getMaxNumber()) {
                this.board.enterNumberA(pos, 0);
            } else if (n >= 0) {
                this.board.enterNumberA(pos, n + 1);
            }
        }
    }

    protected void rightPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isWall(pos))) {
            int n = this.board.getNumber(pos);
            if (n == 0) {
                this.board.enterNumberA(pos, this.board.getMaxNumber());
            } else if (n > 0) {
                this.board.enterNumberA(pos, n - 1);
            }
        }
    }

    protected void arrowKeyEntered(int direction) {
        super.arrowKeyEntered(direction);
        if (direction == 1) {
            this.getKKCursor().setStair(1);
        } else if (direction == 0) {
            this.getKKCursor().setStair(0);
        }
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            Address posS;
            if (this.getKKCursor().getStair() == 0) {
                this.board.setSum(pos, 0, num);
            } else if (this.getKKCursor().getStair() == 1) {
                this.board.setSum(pos, 1, num);
            }
            if (this.isSymmetricPlacementMode() && this.isOn(posS = this.getSymmetricPosition(pos)) && !this.board.isWall(posS)) {
                this.board.setWall(posS, 0, 0);
            }
        } else if (this.isCursorOn() && !this.board.isWall(pos)) {
            this.board.enterNumberA(pos, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            if (pos.r() == 0 || pos.c() == 0) {
                return;
            }
            this.board.removeWall(pos);
            if (this.isSymmetricPlacementMode() && this.isOn(posS = this.getSymmetricPosition(pos)) && this.board.isWall(posS)) {
                this.board.removeWall(posS);
            }
        } else if (this.isCursorOn() && !this.board.isWall(pos)) {
            this.board.enterNumberA(pos, 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            if (this.getKKCursor().getStair() == 0) {
                this.board.setSum(pos, 0, 0);
            } else if (this.getKKCursor().getStair() == 1) {
                this.board.setSum(pos, 1, 0);
            }
            if (this.isSymmetricPlacementMode() && this.isOn(posS = this.getSymmetricPosition(pos)) && !posS.equals(pos) && !this.board.isWall(posS)) {
                this.board.setWall(posS, 0, 0);
            }
        }
    }

    KakuroCursor getKKCursor() {
        return (KakuroCursor)this.getCellCursor();
    }

    public Address getSymmetricPosition(Address pos) {
        return new Address(this.board.rows() - pos.r(), this.board.cols() - pos.c());
    }
}

