/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hashi;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.hashi.Messages;
import pencilbox.hashi.Panel;

public class Menu
extends MenuBase {
    private JMenuItem numberColorItem;
    private JMenuItem lineColorItem;
    private JMenuItem indicateErrorItem;
    private JMenuItem separateLinkColorItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    protected void buildEditMenu() {
        this.addSymmetricPlacementMenuItem();
        super.buildEditMenu();
    }

    protected void buildViewMenu() {
        super.buildViewMenu();
        this.numberColorItem = this.addColorMenuItem(Messages.getString("Menu.numberColorItem"));
        this.lineColorItem = this.addColorMenuItem(Messages.getString("Menu.lineColorItem"));
        this.indicateErrorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.indicateErrorItem"), 'E', false);
        this.addToViewMenu(this.indicateErrorItem);
        this.separateLinkColorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.separateLinkColorItem"), 'R', false);
        this.addToViewMenu(this.separateLinkColorItem);
        this.addRenewColorMenuItem();
    }

    public void executeCommand2(JMenuItem target) {
        if (target == this.indicateErrorItem) {
            this.getPanel().setIndicateErrorMode(target.isSelected());
        } else if (target == this.separateLinkColorItem) {
            this.getPanel().setSeparateLinkColorMode(target.isSelected());
        }
    }

    public Color getColor(JMenuItem target) {
        if (target == this.lineColorItem) {
            return this.getPanel().getLineColor();
        }
        if (target == this.numberColorItem) {
            return this.getPanel().getNumberColor();
        }
        return super.getColor(target);
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.lineColorItem) {
            this.getPanel().setLineColor(color);
        } else if (target == this.numberColorItem) {
            this.getPanel().setNumberColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.indicateErrorItem.setSelected(this.getPanel().isIndicateErrorMode());
        this.separateLinkColorItem.setSelected(this.getPanel().isSeparateLinkColorMode());
    }
}

