/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.lits;

import java.util.Arrays;
import java.util.Collection;
import pencilbox.common.core.BoardBase;
import pencilbox.common.io.XmlReaderBase;
import pencilbox.lits.Area;
import pencilbox.lits.Board;

public class XmlReader
extends XmlReaderBase {
    private Board board;
    private Area[] areas;

    protected BoardBase makeBoard() {
        this.board = new Board();
        return this.board;
    }

    protected void start() {
        if (this.node == "areas") {
            int nArea = Integer.parseInt(this.attributes.getValue("N"));
            this.areas = new Area[nArea];
            int i = 0;
            while (i < nArea) {
                this.areas[i] = new Area();
                ++i;
            }
        }
    }

    protected void setBN(int r, int c, int n) {
        this.areas[n].add(r, c);
        this.board.setArea(r, c, this.areas[n]);
    }

    protected void onBoardEnd() {
        super.onBoardEnd();
        this.board.getAreaList().addAll((Collection<Area>)Arrays.asList(this.areas));
    }

    protected void setAType(int r, int c, String t) {
        if (t == "w") {
            this.board.setState(r, c, -2);
        } else if (t == "s") {
            this.board.setState(r, c, -1);
        }
    }
}

