/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tentaisho;

import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.tentaisho.Area;
import pencilbox.tentaisho.Messages;
import pencilbox.tentaisho.StarAddress;
import pencilbox.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Board
extends BoardBase {
    static final int NOSTAR = 0;
    static final int WHITESTAR = 1;
    static final int BLACKSTAR = 2;
    private int[][] star;
    private Area[][] area;
    private List<Area> areaList;

    @Override
    protected void setup() {
        super.setup();
        this.star = new int[this.rows() * 2 - 1][this.cols() * 2 - 1];
        this.area = new Area[this.rows()][this.cols()];
        this.areaList = new LinkedList<Area>();
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        this.areaList.clear();
        ArrayUtil.initArrayObject2(this.area, null);
    }

    @Override
    public void initBoard() {
        this.initAreas();
    }

    public void initAreas() {
        for (Area a : this.areaList) {
            this.initArea(a);
        }
    }

    int[][] getStar() {
        return this.star;
    }

    public int getStar(int r, int c) {
        return this.star[r][c];
    }

    public int getStar(Address pos) {
        return this.getStar(pos.r(), pos.c());
    }

    public void setStar(int r, int c, int st) {
        this.star[r][c] = st;
    }

    public void setStar(Address pos, int st) {
        this.setStar(pos.r(), pos.c(), st);
    }

    public boolean isOnStar(int r, int c) {
        return r >= 0 && r < this.rows() * 2 - 1 && c >= 0 && c < this.cols() * 2 - 1;
    }

    public boolean isOnStar(Address pos) {
        return this.isOnStar(pos.r(), pos.c());
    }

    public boolean isCovered(int r, int c) {
        return this.area[r][c] != null;
    }

    public Area getArea(int r, int c) {
        return this.area[r][c];
    }

    public Area getArea(Address pos) {
        return this.getArea(pos.r(), pos.c());
    }

    public void setArea(int r, int c, Area a) {
        this.area[r][c] = a;
    }

    public void setArea(Address pos, Area a) {
        this.setArea(pos.r(), pos.c(), a);
    }

    public void addArea(Area newArea) {
        for (Address pos : newArea) {
            this.setArea(pos.r(), pos.c(), newArea);
        }
        this.areaList.add(newArea);
    }

    public void removeArea(Area oldArea) {
        for (Address pos : oldArea) {
            if (this.getArea(pos.r(), pos.c()) != oldArea) continue;
            this.setArea(pos.r(), pos.c(), null);
        }
        this.areaList.remove(oldArea);
    }

    void addCellToAreaA(Address pos, Area area) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(pos.r(), pos.c(), area, 1)));
        this.addCellToArea(pos, area);
    }

    void removeCellFromAreaA(Address pos, Area area) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(pos.r(), pos.c(), area, 0)));
        this.removeCellFromArea(pos, area);
    }

    public void addCellToArea(int r, int c, Area area) {
        if (area.isEmpty()) {
            this.areaList.add(area);
        }
        this.setArea(r, c, area);
        area.add(r, c);
        this.initArea(area);
    }

    public void addCellToArea(Address pos, Area area) {
        this.addCellToArea(pos.r(), pos.c(), area);
    }

    public void removeCellFromArea(int r, int c, Area area) {
        this.setArea(r, c, null);
        area.remove(r, c);
        if (area.isEmpty()) {
            this.areaList.remove(area);
        } else {
            this.initArea(area);
        }
    }

    public void removeCellFromArea(Address pos, Area area) {
        this.removeCellFromArea(pos.r(), pos.c(), area);
    }

    void initArea(Area newArea) {
        int nStar = 0;
        StarAddress starPos = new StarAddress();
        for (Address pos : newArea) {
            int i = 2 * pos.r() - 1;
            while (i <= 2 * pos.r() + 1) {
                int j = 2 * pos.c() - 1;
                while (j <= 2 * pos.c() + 1) {
                    if (this.isOnStar(i, j) && this.getStar(i, j) > 0) {
                        if (nStar == 0) {
                            nStar = this.getStar(i, j);
                            starPos.set(i, j);
                        } else if (!(nStar != 1 && nStar != 2 || starPos.equals(i, j))) {
                            nStar = -1;
                            starPos.setNowhere();
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        newArea.setStarType(nStar);
        newArea.setStarPos(starPos);
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        for (Area a : this.areaList) {
            if (a.isPointSymmetry()) continue;
            result |= 1;
        }
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.area[r][c] == null) {
                    result |= 2;
                }
                ++c;
            }
            ++r;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("Board.AnswerCheckMessage1"));
        } else if ((result & 2) == 2) {
            message.append(Messages.getString("Board.AnswerCheckMessage2"));
        }
        return message.toString();
    }

    List<Area> getAreaList() {
        return this.areaList;
    }

    Area[][] getArea() {
        return this.area;
    }

    class Step
    extends AbstractUndoableEdit {
        static final int ADDED = 1;
        static final int REMOVED = 0;
        static final int CHANGED = 2;
        private int r;
        private int c;
        private Area area;
        private int operation;

        public Step(int r, int c, Area area, int operation) {
            this.r = r;
            this.c = c;
            this.area = area;
            this.operation = operation;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.operation == 1) {
                Board.this.removeCellFromArea(this.r, this.c, this.area);
            } else if (this.operation == 0) {
                Board.this.addCellToArea(this.r, this.c, this.area);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (this.operation == 1) {
                Board.this.addCellToArea(this.r, this.c, this.area);
            } else if (this.operation == 0) {
                Board.this.removeCellFromArea(this.r, this.c, this.area);
            }
        }
    }
}

