/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slitherlink;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator;
import pencilbox.common.core.Rotator2;
import pencilbox.slitherlink.Board;

public class BoardCopier
extends BoardCopierBase {
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Board s = (Board)src;
        Board d = (Board)dst;
        Rotator rotator = new Rotator(src.getSize(), n);
        rotator.rotateArrayInt3(s.getState(), d.getState());
        Rotator rotator2 = new Rotator(src.rows() - 1, src.cols() - 1, n);
        rotator2.rotateArrayInt2(s.getNumber(), d.getNumber());
    }

    public void copyRegion(BoardBase srcBoardBase, BoardBase dstBoardBase, Area region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)dstBoardBase;
        Address d = new Address();
        Address dn = new Address();
        Address rt = new Address();
        Address dnrt = new Address();
        Rotator2 rotator = new Rotator2(to, rotation);
        for (Address s : region) {
            int dir;
            int joint;
            d.set(s.r() + to.r() - from.r(), s.c() + to.c() - from.c());
            d.set(rotator.rotateAddress(d));
            dn.set(s.r() + 1, s.c());
            rt.set(s.r(), s.c() + 1);
            dnrt.set(s.r() + 1, s.c() + 1);
            if (region.contains(dn)) {
                joint = srcBoard.getStateJ(s, 2);
                dir = rotator.rotateDirection(2);
                if (board.isSideOn(d, dir)) {
                    board.setStateJ(d, dir, joint);
                }
            }
            if (region.contains(rt)) {
                joint = srcBoard.getStateJ(s, 3);
                dir = rotator.rotateDirection(3);
                if (board.isSideOn(d, dir)) {
                    board.setStateJ(d, dir, joint);
                }
            }
            if (!region.containsAll(dn, rt, dnrt)) continue;
            int grid = srcBoard.getNumber(s);
            if (rotation == 0 || rotation == 4) {
                d.set(d.r(), d.c());
            } else if (rotation == 1 || rotation == 7) {
                d.set(d.r() - 1, d.c());
            } else if (rotation == 2 || rotation == 6) {
                d.set(d.r() - 1, d.c() - 1);
            } else if (rotation == 3 || rotation == 5) {
                d.set(d.r(), d.c() - 1);
            }
            if (!board.isNumberOn(d)) continue;
            board.setNumber(d, grid);
        }
    }

    public void eraseRegion(BoardBase boardBase, Area region) {
        Board board = (Board)boardBase;
        Address dn = new Address();
        Address rt = new Address();
        Address dnrt = new Address();
        for (Address s : region) {
            dn.set(s.r() + 1, s.c());
            rt.set(s.r(), s.c() + 1);
            dnrt.set(s.r() + 1, s.c() + 1);
            if (region.contains(dn)) {
                board.setStateJ(s, 2, 0);
            }
            if (region.contains(rt)) {
                board.setStateJ(s, 3, 0);
            }
            if (!region.containsAll(dn, rt, dnrt)) continue;
            board.setNumber(s, -1);
        }
    }
}

