/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.bijutsukan;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.bijutsukan.Messages;
import pencilbox.bijutsukan.Panel;
import pencilbox.common.gui.MenuBase;

public class Menu
extends MenuBase {
    private JMenuItem bulbColorItem;
    private JMenuItem noBulbColorItem;
    private JMenuItem lluminatedCellColorItem;
    private JMenuItem wallColorItem;
    private JMenuItem numberColorItem;
    private JMenuItem indicateErrorItem;
    private JMenuItem paintIlluminatedCellItem;
    private JMenuItem showBeamItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    protected void buildEditMenu() {
        this.addSymmetricPlacementMenuItem();
        this.addTrimAnswerMenuItem();
        super.buildEditMenu();
    }

    protected void buildViewMenu() {
        this.buildMarkStyleMenu(Messages.getString("Menu.markStyleMenu"), 'N', new int[]{3, 4});
        super.buildViewMenu();
        this.wallColorItem = this.addColorMenuItem(Messages.getString("Menu.wallColoritem"));
        this.numberColorItem = this.addColorMenuItem(Messages.getString("Menu.numberColorItem"));
        this.bulbColorItem = this.addColorMenuItem(Messages.getString("Menu.bulbColorItem"));
        this.noBulbColorItem = this.addColorMenuItem(Messages.getString("Menu.noBulbColorItem"));
        this.lluminatedCellColorItem = this.addColorMenuItem(Messages.getString("Menu.illuminatedCellColorItem"));
        this.indicateErrorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.indicateErrorItem"), 'E', false);
        this.addToViewMenu(this.indicateErrorItem);
        this.paintIlluminatedCellItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.paintIlluminatedCellItem"), 'P', true);
        this.addToViewMenu(this.paintIlluminatedCellItem);
        this.showBeamItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.showBeamItem"), 'B', false);
        this.addToViewMenu(this.showBeamItem);
    }

    public void executeCommand2(JMenuItem target) {
        if (target == this.indicateErrorItem) {
            this.getPanel().setIndicateErrorMode(target.isSelected());
        } else if (target == this.paintIlluminatedCellItem) {
            this.getPanel().setPaintIlluminatedCellMode(target.isSelected());
        } else if (target == this.showBeamItem) {
            this.getPanel().setShowBeamMode(target.isSelected());
        }
    }

    public Color getColor(JMenuItem target) {
        if (target == this.bulbColorItem) {
            return this.getPanel().getBulbColor();
        }
        if (target == this.noBulbColorItem) {
            return this.getPanel().getNoBulbColor();
        }
        if (target == this.lluminatedCellColorItem) {
            return this.getPanel().getIlluminatedCellColor();
        }
        if (target == this.wallColorItem) {
            return this.getPanel().getWallColor();
        }
        if (target == this.numberColorItem) {
            return this.getPanel().getNumberColor();
        }
        return super.getColor(target);
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.bulbColorItem) {
            this.getPanel().setBulbColor(color);
        } else if (target == this.noBulbColorItem) {
            this.getPanel().setNoBulbColor(color);
        } else if (target == this.lluminatedCellColorItem) {
            this.getPanel().setIlluminatedCellColor(color);
        } else if (target == this.wallColorItem) {
            this.getPanel().setWallColor(color);
        } else if (target == this.numberColorItem) {
            this.getPanel().setNumberColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.indicateErrorItem.setSelected(this.getPanel().isIndicateErrorMode());
        this.paintIlluminatedCellItem.setSelected(this.getPanel().isPaintIlluminatedCellMode());
        this.showBeamItem.setSelected(this.getPanel().isShowBeamMode());
    }
}

