/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.bijutsukan;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.bijutsukan.Messages;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int NONUMBER_WALL = 5;
    static final int BULB = -2;
    static final int NOBULB = -3;
    static final int UNKNOWN = -1;
    static final int OUTER = 6;
    private int[][] state;
    private int[][] illuminatedH;
    private int[][] illuminatedV;
    static final String ERR_MULTI_ILLUMINATION = Messages.getString("Board.AnswerCheckMessage1");
    static final String YET_NOT_ILLUMINATED = Messages.getString("Board.AnswerCheckMessage2");
    static final String ERR_WRONG_NUMBER = Messages.getString("Board.AnswerCheckMessage3");

    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.illuminatedV = new int[this.rows()][this.cols()];
        this.illuminatedH = new int[this.rows()][this.cols()];
        ArrayUtil.initArrayInt2(this.state, -1);
    }

    public void clearBoard() {
        super.clearBoard();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isFloor(r, c)) {
                    this.setState(r, c, -1);
                }
                ++c;
            }
            ++r;
        }
        this.initBoard();
    }

    public void trimAnswer() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getState(r, c) == -3) {
                    this.setState(r, c, -1);
                }
                ++c;
            }
            ++r;
        }
    }

    public void initBoard() {
        this.initIlluminations();
    }

    void initIlluminations() {
        ArrayUtil.initArrayInt2(this.illuminatedV, 0);
        ArrayUtil.initArrayInt2(this.illuminatedH, 0);
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isBulb(r, c)) {
                    this.illuminate(r, c, true);
                }
                ++c;
            }
            ++r;
        }
    }

    int[][] getState() {
        return this.state;
    }

    public int getState(int r, int c) {
        if (this.isOn(r, c)) {
            return this.state[r][c];
        }
        return 6;
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public boolean isWall(int r, int c) {
        return this.state[r][c] >= 0 && this.state[r][c] <= 4 || this.state[r][c] == 5;
    }

    public boolean isWall(Address pos) {
        return this.isWall(pos.r(), pos.c());
    }

    public boolean isNumberedWall(int r, int c) {
        return this.state[r][c] >= 0 && this.state[r][c] <= 4;
    }

    public boolean isFloor(int r, int c) {
        return this.isOn(r, c) && (this.state[r][c] == -1 || this.state[r][c] == -3 || this.state[r][c] == -2);
    }

    public boolean isBulb(int r, int c) {
        return this.isOn(r, c) && this.state[r][c] == -2;
    }

    public boolean isUnknown(int r, int c) {
        return this.state[r][c] == -1;
    }

    public int getHorizIlluminated(int r, int c) {
        return this.illuminatedH[r][c];
    }

    public int getVertIlluminated(int r, int c) {
        return this.illuminatedV[r][c];
    }

    public boolean isMultiIlluminated(int r, int c) {
        return this.illuminatedV[r][c] > 1 || this.illuminatedH[r][c] > 1;
    }

    public boolean isIlluminated(int r, int c) {
        return this.illuminatedV[r][c] > 0 || this.illuminatedH[r][c] > 0;
    }

    private void illuminate(int r0, int c0, boolean on) {
        int k = on ? 1 : -1;
        int r = r0;
        int c = c0;
        while (this.isFloor(r, c)) {
            --r;
        }
        ++r;
        while (this.isFloor(r, c)) {
            int[] nArray = this.illuminatedV[r];
            int n = c;
            nArray[n] = nArray[n] + k;
            ++r;
        }
        r = r0;
        while (this.isFloor(r, c)) {
            --c;
        }
        ++c;
        while (this.isFloor(r, c)) {
            int[] nArray = this.illuminatedH[r];
            int n = c++;
            nArray[n] = nArray[n] + k;
        }
    }

    private void illuminate4(int r0, int c0, boolean on) {
        Address p = new Address(r0, c0);
        int d = 0;
        while (d < 4) {
            p.set(r0, c0);
            p.move(d);
            while (this.isFloor(p.r(), p.c())) {
                if (this.isBulb(p.r(), p.c())) {
                    this.illuminate(p.r(), p.c(), on);
                }
                p.move(d);
            }
            ++d;
        }
    }

    public void changeState(int r, int c, int st) {
        int prev = this.getState(r, c);
        if (st >= 0 && st <= 4 || st == 5 || prev >= 0 && prev <= 4 || prev == 5) {
            this.illuminate4(r, c, false);
        }
        if (st == -2 && prev != -2) {
            this.illuminate(r, c, true);
        } else if (prev == -2 && st != -2) {
            this.illuminate(r, c, false);
        }
        this.setState(r, c, st);
        if (st >= 0 && st <= 4 || st == 5 || prev >= 0 && prev <= 4 || prev == 5) {
            this.illuminate4(r, c, true);
        }
    }

    public void changeState(Address pos, int st) {
        this.changeState(pos.r(), pos.c(), st);
    }

    public void changeStateA(Address pos, int st) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(pos.r(), pos.c(), this.getState(pos), st)));
        this.changeState(pos, st);
    }

    public int countAdjacentBulbs(int r, int c) {
        int count = 0;
        if (this.isBulb(r - 1, c)) {
            ++count;
        }
        if (this.isBulb(r + 1, c)) {
            ++count;
        }
        if (this.isBulb(r, c - 1)) {
            ++count;
        }
        if (this.isBulb(r, c + 1)) {
            ++count;
        }
        return count;
    }

    public int checkAdjacentBulbs(int r, int c) {
        int number;
        int nBulb = this.countAdjacentBulbs(r, c);
        if (nBulb > (number = this.getState(r, c))) {
            return -1;
        }
        if (nBulb == number) {
            return 1;
        }
        if (nBulb < number) {
            return 0;
        }
        return 0;
    }

    public int checkAnswerCode() {
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (!this.isWall(r, c)) {
                    if (this.isMultiIlluminated(r, c)) {
                        result |= 1;
                    } else if (!this.isIlluminated(r, c)) {
                        result |= 2;
                    }
                } else if (this.isNumberedWall(r, c)) {
                    if (this.countAdjacentBulbs(r, c) > this.getState(r, c)) {
                        result |= 4;
                    } else if (this.countAdjacentBulbs(r, c) < this.getState(r, c)) {
                        result |= 8;
                    }
                }
                ++c;
            }
            ++r;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(ERR_MULTI_ILLUMINATION);
        }
        if ((result & 2) == 2) {
            message.append(YET_NOT_ILLUMINATED);
        }
        if ((result & 4) == 4 || (result & 8) == 8) {
            message.append(ERR_WRONG_NUMBER);
        }
        return message.toString();
    }

    class Step
    extends AbstractUndoableEdit {
        private int row;
        private int col;
        private int before;
        private int after;

        public Step(int r, int c, int b, int a) {
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            Board.this.changeState(this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Board.this.changeState(this.row, this.col, this.after);
        }
    }
}

