/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.goishi;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator;
import pencilbox.common.core.Rotator2;
import pencilbox.goishi.Board;

public class BoardCopier
extends BoardCopierBase {
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Board srcBoard = (Board)src;
        Board board = (Board)dst;
        Rotator rotator = new Rotator(src.getSize(), n);
        Address s = new Address();
        int r = 0;
        while (r < board.rows()) {
            int c = 0;
            while (c < board.cols()) {
                s.set(r, c);
                Address d = rotator.rotateAddress(s);
                if (board.isOn(d)) {
                    board.setState(d, srcBoard.getState(s));
                }
                ++c;
            }
            ++r;
        }
        int i = 0;
        while (i < srcBoard.pickedList.size()) {
            board.pickedList.add(rotator.rotateAddress(srcBoard.pickedList.get(i)));
            ++i;
        }
    }

    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, Area region, Address from, Address to, int rotation) {
        Address s;
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        Address d = new Address();
        Rotator2 rotator = new Rotator2(to, rotation);
        for (Address s2 : region) {
            d.set(s2.r() + to.r() - from.r(), s2.c() + to.c() - from.c());
            d = rotator.rotateAddress(d);
            if (!board.isOn(d)) continue;
            board.setState(d, srcBoard.getState(s2));
        }
        int i = board.pickedList.size() - 1;
        while (i >= 0) {
            s = board.pickedList.get(i);
            if (region.contains(s)) {
                board.pickedList.remove(i);
            }
            --i;
        }
        board.rePickUpAll();
        i = 0;
        while (i < srcBoard.pickedList.size()) {
            s = srcBoard.pickedList.get(i);
            if (region.contains(s)) {
                d.set(s.r() + to.r() - from.r(), s.c() + to.c() - from.c());
                d = rotator.rotateAddress(d);
                if (board.isOn(d)) {
                    board.pickUp(d);
                }
            }
            ++i;
        }
    }

    public void eraseRegion(BoardBase boardBase, Area region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            board.setState(s, 0);
        }
    }
}

