/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.goishi;

import java.util.ArrayList;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.goishi.Messages;

public class Board
extends BoardBase {
    public static final int BLANK = 0;
    public static final int STONE = -1;
    private int[][] state;
    private int[][] number;
    ArrayList<Address> pickedList;

    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.number = new int[this.rows()][this.cols()];
        this.pickedList = new ArrayList();
    }

    public void clearBoard() {
        super.clearBoard();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                this.setNumber(r, c, 0);
                ++c;
            }
            ++r;
        }
        this.pickedList.clear();
    }

    public boolean isStone(Address pos) {
        return this.getState(pos) == -1;
    }

    public int getState(int r, int c) {
        if (!this.isOn(r, c)) {
            return 0;
        }
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        if (!this.isOn(r, c)) {
            return;
        }
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.number[pos.r()][pos.c()];
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.number[pos.r()][pos.c()] = n;
    }

    public void addStone(Address pos) {
        if (this.getState(pos) == -1) {
            return;
        }
        this.setState(pos, -1);
        this.rePickUpAll();
    }

    public void removeStone(Address pos) {
        if (this.getState(pos) == 0) {
            return;
        }
        this.setState(pos, 0);
        if (this.getNumber(pos) > 0) {
            this.setNumber(pos, 0);
            this.pickedList.remove(pos);
            this.rePickUpAll();
        }
    }

    public void initBoard() {
        this.rePickUpAll();
    }

    public void pickUp(Address p) {
        this.pickedList.add(new Address(p));
        this.setNumber(p, this.pickedList.size());
    }

    public void placeBack() {
        Address p = this.pickedList.get(this.pickedList.size() - 1);
        this.setNumber(p, 0);
        this.pickedList.remove(this.pickedList.size() - 1);
    }

    public boolean canPick(Address pos) {
        if (this.getState(pos) != -1) {
            return false;
        }
        if (this.getNumber(pos) > 0) {
            return false;
        }
        if (this.pickedList.size() == 0) {
            return true;
        }
        Address prev = this.pickedList.get(this.pickedList.size() - 1);
        int direction = Address.getDirectionTo(prev, pos);
        if (direction < 0) {
            return false;
        }
        Address p = new Address(prev);
        while (!p.equals(pos)) {
            if (this.isStone(p) && this.getNumber(p) == 0) {
                return false;
            }
            p.move(direction);
        }
        if (this.pickedList.size() == 1) {
            return true;
        }
        Address prev2 = this.pickedList.get(this.pickedList.size() - 2);
        int direction2 = Address.getDirectionTo(prev, prev2);
        return direction != direction2;
    }

    public void rePickUpAll() {
        ArrayList copy = (ArrayList)this.pickedList.clone();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getState(r, c) == -1) {
                    this.setNumber(r, c, 0);
                }
                ++c;
            }
            ++r;
        }
        this.pickedList.clear();
        int i = 0;
        while (i < copy.size()) {
            Address p = (Address)copy.get(i);
            if (!this.canPick(p)) break;
            this.pickUp(p);
            ++i;
        }
    }

    public int checkAnswerCode() {
        int nStone = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getState(r, c) == -1) {
                    ++nStone;
                    if (this.getNumber(r, c) == 0) {
                        return 1;
                    }
                }
                ++c;
            }
            ++r;
        }
        if (nStone == 0) {
            return 2;
        }
        return 0;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        if (result == 2) {
            return Messages.getString("Board.AnswerCheckMessage0");
        }
        if (result == 1) {
            return Messages.getString("Board.AnswerCheckMessage1");
        }
        return "";
    }
}

