/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import pencilbox.common.gui.Frame;
import pencilbox.common.gui.Messages;

public class PencilBoxDialog
extends JPanel {
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int CLOSED_OPTION = -1;
    public static final int OK_ONLY = 0;
    public static final int OK_CANCEL = 1;
    private int dialogType = 1;
    private JPanel buttonPanel;
    private JButton buttonOk;
    private JButton buttonCancel;
    private JDialog dialog;
    private int ret = -1;

    public PencilBoxDialog() {
        this.makeDialog();
    }

    protected void makeDialog() {
        this.setLayout(new BorderLayout());
        this.makeButtonPanel();
        this.assignKeys();
    }

    private void makeButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.buttonOk = new JButton(Messages.getString("PencilBoxDialog.buttonOK"));
        this.buttonCancel = new JButton(Messages.getString("PencilBoxDialog.buttonCancel"));
        ActionListener buttonAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source == PencilBoxDialog.this.buttonOk) {
                    PencilBoxDialog.this.accept();
                } else if (source == PencilBoxDialog.this.buttonCancel) {
                    PencilBoxDialog.this.cancel();
                }
            }
        };
        this.buttonOk.addActionListener(buttonAction);
        this.buttonCancel.addActionListener(buttonAction);
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add(this.buttonOk);
        if (this.dialogType == 1) {
            this.buttonPanel.add(this.buttonCancel);
        }
        this.add((Component)this.buttonPanel, "South");
    }

    public void setDialogType(int dialogType) {
        this.dialogType = dialogType;
    }

    private void assignKeys() {
        InputMap imap = this.getInputMap(1);
        imap.put(KeyStroke.getKeyStroke(27, 0), "close");
        ActionMap amap = this.getActionMap();
        amap.put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (PencilBoxDialog.this.dialog != null) {
                    PencilBoxDialog.this.ret = -1;
                    PencilBoxDialog.this.dialog.setVisible(false);
                }
            }
        });
    }

    protected void accept() {
        this.ret = 0;
        this.dialog.setVisible(false);
    }

    protected void cancel() {
        this.ret = 2;
        this.dialog.setVisible(false);
    }

    public int showDialog(Component parent, String title) {
        Frame owner = null;
        owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        this.dialog = new JDialog((java.awt.Frame)owner, true);
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.getRootPane().setDefaultButton(this.buttonOk);
        this.dialog.setTitle(title);
        this.dialog.setLocationRelativeTo(owner);
        this.setInitialFocus();
        this.dialog.setVisible(true);
        return this.ret;
    }

    protected void setInitialFocus() {
    }
}

