/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JOptionPane;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.CellCursor;
import pencilbox.common.gui.Messages;
import pencilbox.common.gui.PanelBase;

public class PanelEventHandlerBase
implements KeyListener,
MouseListener,
MouseMotionListener {
    private PanelBase panel;
    private BoardBase board;
    private int maxInputNumber = 99;
    private int previousInput = 0;
    private int symmetricPlacementMode = 0;
    private int immediateAnswerCheckMode = -1;
    private Address oldPos = new Address(-1, -1);
    private Address newPos = new Address(-1, -1);
    private SideAddress sidePos = new SideAddress();

    public void setup(PanelBase panel, BoardBase board) {
        this.panel = panel;
        this.board = board;
        this.setBoard(board);
        this.resetPreviousInput();
        this.resetImmediateAnswerCheckMode();
    }

    protected void setBoard(BoardBase board) {
    }

    public PanelBase getPanel() {
        return this.panel;
    }

    public boolean isSymmetricPlacementMode() {
        return this.symmetricPlacementMode == 1;
    }

    public void setSymmetricPlacementMode(boolean b) {
        this.symmetricPlacementMode = b ? 1 : 0;
    }

    public boolean isImmediateAnswerCheckMode() {
        return this.immediateAnswerCheckMode >= 0;
    }

    public void setImmediateAnswerCheckMode(boolean b) {
        this.immediateAnswerCheckMode = b ? 0 : -1;
    }

    public void resetImmediateAnswerCheckMode() {
        if (this.immediateAnswerCheckMode == 1) {
            this.immediateAnswerCheckMode = 0;
        }
    }

    protected int getMaxInputNumber() {
        return this.maxInputNumber;
    }

    protected void setMaxInputNumber(int number) {
        this.maxInputNumber = number;
    }

    public void resetPreviousInput() {
        this.previousInput = 0;
    }

    public boolean isProblemEditMode() {
        return this.panel.getEditMode() == PanelBase.PROBLEM_INPUT_MODE;
    }

    public CellCursor getCellCursor() {
        return this.panel.getCellCursor();
    }

    public boolean isCursorOn() {
        return this.panel.isCursorMode();
    }

    public void repaint() {
        this.panel.repaint();
    }

    public boolean isOn(Address position) {
        return this.board.isOn(position);
    }

    public boolean isSideOn(SideAddress position) {
        return this.board.isSideOn(position);
    }

    public boolean isCursorOnBoard(Address position) {
        return this.board.isOn(position);
    }

    public Address getSymmetricPosition(Address pos) {
        return new Address(this.board.rows() - 1 - pos.r(), this.board.cols() - 1 - pos.c());
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 47: 
            case 111: {
                this.slashKeyEntered();
                break;
            }
            case 37: {
                this.arrowKeyEntered(1);
                break;
            }
            case 38: {
                this.arrowKeyEntered(0);
                break;
            }
            case 39: {
                this.arrowKeyEntered(3);
                break;
            }
            case 40: {
                this.arrowKeyEntered(2);
                break;
            }
            case 32: 
            case 46: 
            case 110: {
                this.spaceKeyEntered();
                break;
            }
            case 45: 
            case 109: {
                this.minusKeyEntered();
                break;
            }
            case 59: 
            case 107: {
                this.plusKeyEntered();
                break;
            }
            case 106: 
            case 513: {
                this.starKeyEntered();
                break;
            }
            case 48: 
            case 96: {
                this.numberKeyEntered(0);
                break;
            }
            case 49: 
            case 97: {
                this.numberKeyEntered(1);
                break;
            }
            case 50: 
            case 98: {
                this.numberKeyEntered(2);
                break;
            }
            case 51: 
            case 99: {
                this.numberKeyEntered(3);
                break;
            }
            case 52: 
            case 100: {
                this.numberKeyEntered(4);
                break;
            }
            case 53: 
            case 101: {
                this.numberKeyEntered(5);
                break;
            }
            case 54: 
            case 102: {
                this.numberKeyEntered(6);
                break;
            }
            case 55: 
            case 103: {
                this.numberKeyEntered(7);
                break;
            }
            case 56: 
            case 104: {
                this.numberKeyEntered(8);
                break;
            }
            case 57: 
            case 105: {
                this.numberKeyEntered(9);
            }
        }
        this.repaint();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.checkAnswer();
    }

    protected void arrowKeyEntered(int direction) {
        if (!this.isProblemEditMode() && !this.isCursorOn()) {
            return;
        }
        Address pos = this.getCellCursor().getPosition();
        pos.move(direction);
        if (this.isCursorOnBoard(pos)) {
            this.getCellCursor().setPosition(pos);
            this.resetPreviousInput();
        }
    }

    protected void numberKeyEntered(int number) {
        int maxInput = this.getMaxInputNumber();
        if (this.previousInput * 10 + number <= maxInput) {
            number = this.previousInput * 10 + number;
        }
        if (number <= maxInput) {
            Address pos = this.getCellCursor().getPosition();
            this.numberEntered(pos, number);
            this.previousInput = number;
        }
    }

    protected void numberEntered(Address pos, int num) {
    }

    protected void spaceEntered(Address pos) {
    }

    protected void spaceKeyEntered() {
        Address pos = this.getCellCursor().getPosition();
        this.spaceEntered(pos);
        this.resetPreviousInput();
    }

    protected void minusEntered(Address pos) {
    }

    protected void minusKeyEntered() {
        Address pos = this.getCellCursor().getPosition();
        this.minusEntered(pos);
    }

    protected void plusEntered(Address pos) {
    }

    protected void plusKeyEntered() {
        Address pos = this.getCellCursor().getPosition();
        this.plusEntered(pos);
    }

    protected void starEntered(Address pos) {
    }

    protected void starKeyEntered() {
        Address pos = this.getCellCursor().getPosition();
        this.starEntered(pos);
    }

    protected void slashKeyEntered() {
        if (this.isProblemEditMode()) {
            this.board.initBoard();
            this.panel.setEditMode(PanelBase.ANSWER_INPUT_MODE);
        } else {
            this.panel.setEditMode(PanelBase.PROBLEM_INPUT_MODE);
        }
        this.resetPreviousInput();
        this.resetImmediateAnswerCheckMode();
    }

    public int getMouseButton(MouseEvent e) {
        int modifier = e.getModifiers();
        if ((modifier & 0x10) == 16) {
            if (e.isShiftDown()) {
                return 3;
            }
            return 1;
        }
        if ((modifier & 4) == 4) {
            if (e.isShiftDown()) {
                return 1;
            }
            return 3;
        }
        if ((modifier & 8) == 8) {
            return 2;
        }
        return -1;
    }

    public void mousePressed(MouseEvent e) {
        this.mousePressed2(e);
        this.newPos.set(this.panel.pointToAddress(e.getX(), e.getY()));
        if (!this.isOn(this.newPos)) {
            return;
        }
        int button = this.getMouseButton(e);
        if (button == 1) {
            this.leftPressed(this.newPos);
        } else if (button == 3) {
            this.rightPressed(this.newPos);
        }
        this.moveCursor(this.newPos);
        this.oldPos.set(this.newPos);
        this.repaint();
    }

    private void mousePressed2(MouseEvent e) {
        this.sidePos.set(this.panel.pointToSideAddress(e.getX(), e.getY()));
        if (!this.isSideOn(this.sidePos)) {
            return;
        }
        int button = this.getMouseButton(e);
        if (button == 1) {
            this.leftPressedEdge(this.sidePos);
        } else if (button == 3) {
            this.rightPressedEdge(this.sidePos);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.newPos.set(this.panel.pointToAddress(e.getX(), e.getY()));
        if (!this.isOn(this.newPos)) {
            this.oldPos.setNowhere();
            return;
        }
        if (this.newPos.equals(this.oldPos)) {
            return;
        }
        int button = this.getMouseButton(e);
        if (button == 1) {
            this.leftDragged(this.oldPos, this.newPos);
        } else if (button == 3) {
            this.rightDragged(this.oldPos, this.newPos);
        }
        this.moveCursor(this.newPos);
        this.oldPos.set(this.newPos);
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        int button = this.getMouseButton(e);
        if (button == 1) {
            this.leftReleased(this.oldPos);
        } else if (button == 3) {
            this.rightReleased(this.oldPos);
        }
        this.repaint();
        this.checkAnswer();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this.mouseClicked1(e);
        this.repaint();
        this.checkAnswer();
    }

    public void mouseClicked1(MouseEvent e) {
        if (!this.isOn(this.newPos)) {
            return;
        }
        int button = this.getMouseButton(e);
        if (button == 1) {
            this.leftClicked(this.newPos);
        } else if (button == 3) {
            this.rightClicked(this.newPos);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    protected void leftPressed(Address position) {
    }

    protected void leftClicked(Address position) {
    }

    protected void leftDragged(Address position) {
    }

    protected void leftDragged(Address oldPos, Address position) {
        this.leftDragged(position);
    }

    protected void leftReleased(Address position) {
    }

    protected void rightPressed(Address position) {
    }

    protected void rightClicked(Address position) {
    }

    protected void rightDragged(Address position) {
    }

    protected void rightDragged(Address oldPos, Address position) {
        this.rightDragged(position);
    }

    protected void rightReleased(Address position) {
    }

    protected void moveCursor(Address position) {
        this.getCellCursor().setPosition(position);
        this.resetPreviousInput();
    }

    protected void leftPressedEdge(SideAddress position) {
    }

    protected void rightPressedEdge(SideAddress position) {
    }

    public void checkAnswer() {
        if (this.isProblemEditMode()) {
            return;
        }
        if (this.immediateAnswerCheckMode == 0 && this.board.checkAnswerCode() == 0) {
            JOptionPane.showMessageDialog(this.panel, BoardBase.COMPLETE_MESSAGE, Messages.getString("PanelEventHandlerBase.checkAnswerDialog"), 1);
            this.immediateAnswerCheckMode = 1;
        }
    }
}

