/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import pencilbox.common.gui.ColorIcon;
import pencilbox.common.gui.EventHandlerManager;
import pencilbox.common.gui.Frame;
import pencilbox.common.gui.MenuCommand;
import pencilbox.common.gui.Messages;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.io.IOController;

public class MenuBase {
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu viewMenu;
    private JMenu helpMenu;
    private JMenuItem newBoardItem;
    private JMenuItem openItem;
    private JMenuItem closeAndOpenItem;
    private JMenuItem saveItem;
    private JMenuItem duplicateItem;
    private JMenuItem changeBoardSizeItem;
    private JMenuItem saveImageItem;
    private JMenuItem copyImageItem;
    private JMenuItem printItem;
    private JMenuItem propertyItem;
    private JMenuItem closeItem;
    private JMenuItem quitItem;
    private JMenuItem aboutItem;
    private JMenuItem clearItem;
    private JMenuItem trimAnswerItem;
    private JMenuItem symmetricPlacementItem;
    private JMenuItem undoItem;
    private JMenuItem redoItem;
    private JMenuItem playbackItem;
    private JMenuItem checkAnswerItem;
    private JMenuItem immediateAnswerCheckItem;
    private JMenuItem cellSizeItem;
    private JMenuItem indexItem;
    private JMenuItem gridStyleItem;
    private JMenuItem renewColorItem;
    private JMenuItem cursorItem;
    private ButtonGroup modeGroup;
    private JMenuItem problemEditModeItem;
    private JMenuItem answerModeItem;
    private JMenuItem regionEditModeItem;
    private JMenuItem loadPreferencesItem;
    private JMenuItem storePreferencesItem;
    private JMenu colorMenu;
    private JMenu rotationMenu;
    private JMenu markStyleMenu;
    private JMenu exportDataMenu;
    private ButtonGroup markStyleGroup;
    private JMenuItem backgroundColorItem;
    private JMenuItem gridColorItem;
    private Frame frame;
    private MenuCommand command;
    private PanelBase panel;
    private ActionListener rotationCommandAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JMenuItem target = (JMenuItem)e.getSource();
            MenuBase.this.command.rotateBoard(Integer.parseInt(target.getActionCommand()));
            MenuBase.this.panel.repaint();
        }
    };
    private ActionListener exportCommandAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JMenuItem target = (JMenuItem)e.getSource();
            IOController.DataFormat f = IOController.DataFormat.valueOf(target.getActionCommand());
            MenuBase.this.command.exportProblemData(f);
        }
    };
    private ActionListener markStyleAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JMenuItem target = (JMenuItem)e.getSource();
            MenuBase.this.panel.setMarkStyle(Integer.parseInt(target.getActionCommand()));
            MenuBase.this.panel.repaint();
        }
    };
    private ActionListener changeColorAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            Color color = JColorChooser.showDialog(MenuBase.this.panel, e.getActionCommand(), MenuBase.this.getColor(item));
            if (color != null) {
                MenuBase.this.setColor(item, color);
                MenuBase.this.setColorIcon(item, color);
            }
            MenuBase.this.panel.repaint();
        }
    };
    private ActionListener commandAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            MenuBase.this.executeCommand((JMenuItem)e.getSource());
        }
    };

    public void setup(MenuCommand command, Frame frame, PanelBase panel) {
        this.frame = frame;
        this.command = command;
        this.panel = panel;
        this.buildCommonMenu();
        this.setAccelerators();
    }

    protected PanelBase getPanelBase() {
        return this.panel;
    }

    protected EventHandlerManager getEventHandlerManager() {
        return this.command.getEventHandlerManager();
    }

    protected void buildCommonMenu() {
        this.buildFileMenu();
        this.buildEditMenu();
        this.buildViewMenu();
        this.buildHelpMenu();
        this.buildColorMenuIcon();
        JMenuBar jMenuBar = this.frame.getJMenuBar();
        jMenuBar.add(this.fileMenu);
        jMenuBar.add(this.editMenu);
        jMenuBar.add(this.viewMenu);
        jMenuBar.add(this.helpMenu);
    }

    protected void buildFileMenu() {
        this.fileMenu = this.makeJMenu(Messages.getString("MenuBase.fileMenu"), 'F');
        this.newBoardItem = this.makeCommandMenuItem(Messages.getString("MenuBase.newBoardItem"), 'N');
        this.fileMenu.add(this.newBoardItem);
        this.openItem = this.makeCommandMenuItem(Messages.getString("MenuBase.openItem"), 'O');
        this.fileMenu.add(this.openItem);
        this.closeAndOpenItem = this.makeCommandMenuItem(Messages.getString("MenuBase.closeAndOpenItem"), 'L');
        this.fileMenu.add(this.closeAndOpenItem);
        this.saveItem = this.makeCommandMenuItem(Messages.getString("MenuBase.saveItem"), 'S');
        this.fileMenu.add(this.saveItem);
        this.fileMenu.addSeparator();
        this.duplicateItem = this.makeCommandMenuItem(Messages.getString("MenuBase.duplicateItem"), 'D');
        this.fileMenu.add(this.duplicateItem);
        this.rotationMenu = this.makeJMenu(Messages.getString("MenuBase.rotationMenu"), 'R');
        this.fileMenu.add(this.rotationMenu);
        this.changeBoardSizeItem = this.makeCommandMenuItem(Messages.getString("MenuBase.changeBoardSizeItem"), 'Z');
        this.fileMenu.add(this.changeBoardSizeItem);
        this.buildRotationMenu();
        this.fileMenu.addSeparator();
        this.exportDataMenu = this.makeJMenu(Messages.getString("MenuBase.exportMenu"), 'X');
        this.fileMenu.add(this.exportDataMenu);
        this.buildExportDataMenu();
        this.saveImageItem = this.makeCommandMenuItem(Messages.getString("MenuBase.saveImageItem"), 'G');
        this.fileMenu.add(this.saveImageItem);
        this.copyImageItem = this.makeCommandMenuItem(Messages.getString("MenuBase.copyImageItem"), 'M');
        this.fileMenu.add(this.copyImageItem);
        this.printItem = this.makeCommandMenuItem(Messages.getString("MenuBase.printItem"), 'P');
        this.fileMenu.add(this.printItem);
        this.fileMenu.addSeparator();
        this.loadPreferencesItem = this.makeCommandMenuItem(Messages.getString("MenuBase.loadPreferencesItem"), 'F');
        this.fileMenu.add(this.loadPreferencesItem);
        this.storePreferencesItem = this.makeCommandMenuItem(Messages.getString("MenuBase.storePreferencesItem"), 'T');
        this.fileMenu.add(this.storePreferencesItem);
        this.fileMenu.addSeparator();
        this.propertyItem = this.makeCommandMenuItem(Messages.getString("MenuBase.propertyItem"), 'I');
        this.fileMenu.add(this.propertyItem);
        this.fileMenu.addSeparator();
        this.closeItem = this.makeCommandMenuItem(Messages.getString("MenuBase.closeItem"), 'C');
        this.fileMenu.add(this.closeItem);
        this.quitItem = this.makeCommandMenuItem(Messages.getString("MenuBase.quitItem"), 'Q');
        this.fileMenu.add(this.quitItem);
    }

    protected void buildEditMenu() {
        this.editMenu = this.makeJMenu(Messages.getString("MenuBase.editMenu"), 'E');
        this.answerModeItem = this.makeCommandRadioButtonMenuItem(Messages.getString("MenuBase.answerModeItem"), 'A');
        this.editMenu.add(this.answerModeItem);
        this.problemEditModeItem = this.makeCommandRadioButtonMenuItem(Messages.getString("MenuBase.problemEditModeItem"), 'E');
        this.editMenu.add(this.problemEditModeItem);
        this.regionEditModeItem = this.makeCommandRadioButtonMenuItem(Messages.getString("MenuBase.regionEditModeItem"), 'G');
        this.editMenu.add(this.regionEditModeItem);
        this.editMenu.addSeparator();
        this.clearItem = this.makeCommandMenuItem(Messages.getString("MenuBase.clearItem"), 'C');
        this.editMenu.add(this.clearItem);
        if (this.trimAnswerItem != null) {
            this.editMenu.add(this.trimAnswerItem);
        }
        if (this.symmetricPlacementItem != null) {
            this.editMenu.addSeparator();
            this.editMenu.add(this.symmetricPlacementItem);
        }
        this.editMenu.addSeparator();
        this.undoItem = this.makeCommandMenuItem(Messages.getString("MenuBase.undoItem"), 'U');
        this.editMenu.add(this.undoItem);
        this.redoItem = this.makeCommandMenuItem(Messages.getString("MenuBase.redoItem"), 'R');
        this.editMenu.add(this.redoItem);
        this.playbackItem = this.makeCommandMenuItem(Messages.getString("MenuBase.playbackItem"), 'P');
        this.editMenu.add(this.playbackItem);
        this.editMenu.addSeparator();
        this.checkAnswerItem = this.makeCommandMenuItem(Messages.getString("MenuBase.checkAnswerItem"), 'H');
        this.editMenu.add(this.checkAnswerItem);
        this.immediateAnswerCheckItem = this.makeCheckBoxCommandMenuItem(Messages.getString("MenuBase.immediateAnswerCheckItem"), 'M', false);
        this.editMenu.add(this.immediateAnswerCheckItem);
        this.modeGroup = new ButtonGroup();
        this.modeGroup.add(this.answerModeItem);
        this.modeGroup.add(this.problemEditModeItem);
        this.modeGroup.add(this.regionEditModeItem);
        this.editMenu.addMenuListener(new EditMenuListener());
    }

    protected void buildViewMenu() {
        this.viewMenu = this.makeJMenu(Messages.getString("MenuBase.viewMenu"), 'V');
        this.colorMenu = this.makeJMenu(Messages.getString("MenuBase.colorMenu"), 'L');
        this.viewMenu.add(this.colorMenu);
        this.backgroundColorItem = this.addColorMenuItem(Messages.getString("MenuBase.backgroundColorItem"));
        this.gridColorItem = this.addColorMenuItem(Messages.getString("MenuBase.gridColorItem"));
        this.cellSizeItem = this.makeCommandMenuItem(Messages.getString("MenuBase.cellSizeItem"), 'S');
        this.viewMenu.add(this.cellSizeItem);
        this.indexItem = this.makeCheckBoxCommandMenuItem(Messages.getString("MenuBase.indexItem"), 'I', false);
        this.viewMenu.add(this.indexItem);
        this.gridStyleItem = this.makeCheckBoxCommandMenuItem(Messages.getString("MenuBase.gridStyleItem"), 'G', true);
        this.viewMenu.add(this.gridStyleItem);
        if (this.markStyleMenu != null) {
            this.viewMenu.add(this.markStyleMenu);
        }
        if (this.cursorItem != null) {
            this.viewMenu.add(this.cursorItem);
        }
        this.viewMenu.addSeparator();
        this.viewMenu.addMenuListener(new ViewMenuListener());
    }

    protected void buildColorMenuIcon() {
        int count = this.colorMenu.getMenuComponentCount();
        int i = 0;
        while (i < count) {
            JMenuItem item;
            Color color;
            Component component = this.colorMenu.getMenuComponent(i);
            if (component instanceof JMenuItem && (color = this.getColor(item = (JMenuItem)component)) != null) {
                this.setColorIcon(item, color);
            }
            ++i;
        }
    }

    protected void setColorIcon(JMenuItem item, Color color) {
        Icon icon = item.getIcon();
        if (icon != null && icon instanceof ColorIcon && ((ColorIcon)icon).getColor().equals(color)) {
            return;
        }
        item.setIcon(new ColorIcon(color, Color.BLACK, item.getFont().getSize(), item.getFont().getSize()));
    }

    protected void buildHelpMenu() {
        this.helpMenu = this.makeJMenu(Messages.getString("MenuBase.helpMenu"), 'H');
        this.aboutItem = this.makeCommandMenuItem(Messages.getString("MenuBase.aboutDialog"), 'A');
        this.helpMenu.add(this.aboutItem);
    }

    protected void buildRotationMenu() {
        this.makeRotationItem(Messages.getString("MenuBase.rotationItem1"), '1', 1);
        this.makeRotationItem(Messages.getString("MenuBase.rotationItem2"), '2', 2);
        this.makeRotationItem(Messages.getString("MenuBase.rotationItem3"), '3', 3);
        this.makeRotationItem(Messages.getString("MenuBase.rotationItem4"), '4', 4);
        this.makeRotationItem(Messages.getString("MenuBase.rotationItem5"), '5', 5);
        this.makeRotationItem(Messages.getString("MenuBase.rotationItem6"), '6', 6);
        this.makeRotationItem(Messages.getString("MenuBase.rotationItem7"), '7', 7);
    }

    protected void buildRotationMenu2() {
        this.makeRotationItem(Messages.getString("MenuBase.rotationItem4"), '4', 4);
    }

    protected void buildExportDataMenu() {
        this.makeDataExportItem(Messages.getString("MenuBase.exportItemKanpen"), 'K', IOController.DataFormat.KANPEN);
        this.makeDataExportItem(Messages.getString("MenuBase.exportItemPzprv3"), 'Z', IOController.DataFormat.PZPRV3);
    }

    protected void buildMarkStyleMenu(String text, char mnemonic, int[] styles) {
        this.markStyleMenu = this.makeJMenu(text, mnemonic);
        this.markStyleGroup = new ButtonGroup();
        int i = 1;
        while (i <= styles.length) {
            switch (styles[i - 1]) {
                case 0: {
                    this.makeMarkStyleItem(String.valueOf(i) + " " + Messages.getString("MenuBase.markStyle0"), (char)(48 + i), 0);
                    break;
                }
                case 1: {
                    this.makeMarkStyleItem(String.valueOf(i) + " " + Messages.getString("MenuBase.markStyle1"), (char)(48 + i), 1);
                    break;
                }
                case 2: {
                    this.makeMarkStyleItem(String.valueOf(i) + " " + Messages.getString("MenuBase.markStyle2"), (char)(48 + i), 2);
                    break;
                }
                case 3: {
                    this.makeMarkStyleItem(String.valueOf(i) + " " + Messages.getString("MenuBase.markStyle3"), (char)(48 + i), 3);
                    break;
                }
                case 4: {
                    this.makeMarkStyleItem(String.valueOf(i) + " " + Messages.getString("MenuBase.markStyle4"), (char)(48 + i), 4);
                    break;
                }
                case 5: {
                    this.makeMarkStyleItem(String.valueOf(i) + " " + Messages.getString("MenuBase.markStyle5"), (char)(48 + i), 5);
                }
            }
            ++i;
        }
    }

    protected void addNoPaintMarkStyleMenu() {
        this.buildMarkStyleMenu(Messages.getString("MenuBase.markStyleMenu"), 'N', new int[]{1, 2, 3, 4, 5});
    }

    private void setAccelerators() {
        this.newBoardItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.closeAndOpenItem.setAccelerator(KeyStroke.getKeyStroke(79, 3));
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.closeItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.checkAnswerItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.answerModeItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.problemEditModeItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.regionEditModeItem.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        if (this.renewColorItem != null) {
            this.renewColorItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        }
    }

    protected void removeChangeBoardSizeMenuItem() {
        this.fileMenu.remove(this.changeBoardSizeItem);
    }

    protected void addTrimAnswerMenuItem() {
        this.trimAnswerItem = this.makeCommandMenuItem(Messages.getString("MenuBase.trimAnswerItem"), 'T');
    }

    protected void addSymmetricPlacementMenuItem() {
        this.symmetricPlacementItem = this.makeCheckBoxCommandMenuItem(Messages.getString("MenuBase.symmetricPlacementItem"), 'S', false);
    }

    protected void addCursorMenuItem() {
        this.cursorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("MenuBase.cursorItem"), 'C', this.panel.isCursorMode());
    }

    protected void addRenewColorMenuItem() {
        this.renewColorItem = this.makeCommandMenuItem(Messages.getString("MenuBase.renewColorItem"), 'U');
        this.colorMenu.add(this.renewColorItem);
    }

    protected void addToViewMenu(JMenuItem item) {
        this.viewMenu.add(item);
    }

    protected JMenuItem makeRotationItem(String text, char mnemonic, int n) {
        JMenuItem rotationItem = new JMenuItem(text, mnemonic);
        rotationItem.addActionListener(this.rotationCommandAction);
        rotationItem.setActionCommand(Integer.toString(n));
        this.rotationMenu.add(rotationItem);
        return rotationItem;
    }

    protected JMenuItem makeDataExportItem(String text, char mnemonic, IOController.DataFormat f) {
        JMenuItem item = new JMenuItem(text, mnemonic);
        item.addActionListener(this.exportCommandAction);
        item.setActionCommand(f.toString());
        this.exportDataMenu.add(item);
        return item;
    }

    protected JRadioButtonMenuItem makeMarkStyleItem(String text, char mnemonic, int n) {
        JRadioButtonMenuItem markStyleItem = new JRadioButtonMenuItem(text);
        markStyleItem.setMnemonic(mnemonic);
        markStyleItem.addActionListener(this.markStyleAction);
        markStyleItem.setActionCommand(Integer.toString(n));
        this.markStyleGroup.add(markStyleItem);
        this.markStyleMenu.add(markStyleItem);
        return markStyleItem;
    }

    protected JMenuItem addColorMenuItem(String text) {
        JMenuItem item = new JMenuItem(text);
        item.addActionListener(this.changeColorAction);
        this.colorMenu.add(item);
        return item;
    }

    public Color getColor(JMenuItem target) {
        if (target == this.backgroundColorItem) {
            return this.getPanelBase().getBackgroundColor();
        }
        if (target == this.gridColorItem) {
            return this.getPanelBase().getGridColor();
        }
        return null;
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.backgroundColorItem) {
            this.getPanelBase().setBackgroundColor(color);
        } else if (target == this.gridColorItem) {
            this.getPanelBase().setGridColor(color);
        }
    }

    public void executeCommand(JMenuItem target) {
        if (target == this.newBoardItem) {
            this.command.newBoard();
        } else if (target == this.openItem) {
            this.command.open();
        } else if (target == this.closeAndOpenItem) {
            this.command.closeAndOpen();
        } else if (target == this.saveItem) {
            this.command.save();
        } else if (target == this.duplicateItem) {
            this.command.duplicate();
        } else if (target == this.changeBoardSizeItem) {
            this.command.changeBoardSize();
        } else if (target == this.saveImageItem) {
            this.command.saveImage();
        } else if (target == this.copyImageItem) {
            this.command.copyImage();
        } else if (target == this.printItem) {
            this.command.print();
        } else if (target == this.loadPreferencesItem) {
            this.command.loadPreferences();
            this.updateCurrentMenuSelection();
        } else if (target == this.storePreferencesItem) {
            this.command.storePreferences();
        } else if (target == this.propertyItem) {
            this.command.property();
        } else if (target == this.closeItem) {
            this.command.close();
        } else if (target == this.quitItem) {
            this.command.quit();
        } else if (target == this.aboutItem) {
            this.command.about();
        } else if (target == this.clearItem) {
            this.command.clear();
        } else if (target == this.trimAnswerItem) {
            this.command.trimAnswer();
        } else if (target == this.symmetricPlacementItem) {
            this.command.setSymmetricPlacementMode(target.isSelected());
        } else if (target == this.undoItem) {
            this.command.undo();
        } else if (target == this.redoItem) {
            this.command.redo();
        } else if (target == this.playbackItem) {
            this.command.playback();
        } else if (target == this.checkAnswerItem) {
            this.command.checkAnswer();
        } else if (target == this.immediateAnswerCheckItem) {
            this.command.setImmediateAnswerCheckMode(target.isSelected());
        } else if (target == this.renewColorItem) {
            this.command.renewColor();
        } else if (target == this.cursorItem) {
            this.command.setCursorMode(target.isSelected());
        } else if (target == this.answerModeItem) {
            this.command.setEditMode(PanelBase.ANSWER_INPUT_MODE);
        } else if (target == this.problemEditModeItem) {
            this.command.setEditMode(PanelBase.PROBLEM_INPUT_MODE);
        } else if (target == this.regionEditModeItem) {
            this.command.setEditMode(PanelBase.REGION_EDIT_MODE);
        } else if (target == this.indexItem) {
            this.command.setIndexMode(target.isSelected());
        } else if (target == this.gridStyleItem) {
            this.command.setGridStyle(target.isSelected());
        } else if (target == this.cellSizeItem) {
            this.command.cellSize();
        } else {
            this.executeCommand2(target);
        }
        this.panel.repaint();
    }

    public void executeCommand2(JMenuItem target) {
    }

    protected JMenuItem makeCommandMenuItem(String title, char mnumonic) {
        JMenuItem item = this.makeJMenuItem(title, mnumonic);
        item.addActionListener(this.commandAction);
        return item;
    }

    protected JMenuItem makeCommandRadioButtonMenuItem(String title, char mnumonic) {
        JMenuItem item = this.makeJRadioButtonMenuItem(title, mnumonic);
        item.addActionListener(this.commandAction);
        return item;
    }

    protected JCheckBoxMenuItem makeCheckBoxCommandMenuItem(String title, char mnumonic, boolean initial) {
        JCheckBoxMenuItem item = this.makeJCheckBoxMenuItem(title, mnumonic, initial);
        item.addActionListener(this.commandAction);
        return item;
    }

    public void updateCurrentMenuSelection() {
        this.indexItem.setSelected(this.getPanelBase().isIndexMode());
        this.gridStyleItem.setSelected(this.getPanelBase().getGridStyle() > 0);
        if (this.cursorItem != null) {
            this.cursorItem.setSelected(this.getPanelBase().isCursorMode());
        }
        if (this.symmetricPlacementItem != null) {
            this.symmetricPlacementItem.setSelected(this.getEventHandlerManager().isSymmetricPlacementMode());
        }
        if (this.immediateAnswerCheckItem != null) {
            this.immediateAnswerCheckItem.setSelected(this.getEventHandlerManager().isImmediateAnswerCheckMode());
        }
        if (this.markStyleMenu != null) {
            int s = this.getPanelBase().getMarkStyle();
            int i = 0;
            int count = this.markStyleMenu.getItemCount();
            while (i < count) {
                JRadioButtonMenuItem item = (JRadioButtonMenuItem)this.markStyleMenu.getItem(i);
                if (Integer.parseInt(item.getActionCommand()) == s) {
                    item.setSelected(true);
                    break;
                }
                ++i;
            }
        }
        this.buildColorMenuIcon();
    }

    public JMenu makeJMenu(String text, char mnemonic) {
        JMenu menu = new JMenu(text);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    public JMenuItem makeJMenuItem(String text, char mnemonic) {
        return new JMenuItem(text, mnemonic);
    }

    public JMenuItem makeJRadioButtonMenuItem(String text, char mnemonic) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(text);
        item.setMnemonic(mnemonic);
        return item;
    }

    public JCheckBoxMenuItem makeJCheckBoxMenuItem(String text, char mnemonic, boolean initial) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(text);
        item.setMnemonic(mnemonic);
        item.setSelected(initial);
        return item;
    }

    protected class EditMenuListener
    implements MenuListener {
        protected EditMenuListener() {
        }

        public void menuSelected(MenuEvent evt) {
            MenuBase.this.undoItem.setEnabled(MenuBase.this.command.canUndo());
            MenuBase.this.redoItem.setEnabled(MenuBase.this.command.canRedo());
            MenuBase.this.playbackItem.setEnabled(MenuBase.this.command.canUndo() || MenuBase.this.command.canRedo());
            int m = MenuBase.this.getPanelBase().getEditMode();
            if (m == PanelBase.ANSWER_INPUT_MODE) {
                MenuBase.this.answerModeItem.setSelected(true);
            } else if (m == PanelBase.PROBLEM_INPUT_MODE) {
                MenuBase.this.problemEditModeItem.setSelected(true);
            } else if (m == PanelBase.REGION_EDIT_MODE) {
                MenuBase.this.regionEditModeItem.setSelected(true);
            }
        }

        public void menuDeselected(MenuEvent evt) {
            MenuBase.this.undoItem.setEnabled(true);
            MenuBase.this.redoItem.setEnabled(true);
            MenuBase.this.playbackItem.setEnabled(true);
        }

        public void menuCanceled(MenuEvent evt) {
        }
    }

    protected class ViewMenuListener
    implements MenuListener {
        protected ViewMenuListener() {
        }

        public void menuSelected(MenuEvent evt) {
        }

        public void menuDeselected(MenuEvent evt) {
        }

        public void menuCanceled(MenuEvent evt) {
        }
    }
}

