/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import pencilbox.common.gui.Frame;
import pencilbox.common.gui.Messages;

public class DataExportDialog
extends JPanel {
    private JTextArea textArea;
    private JPanel buttonPanel;
    private JButton buttonOpen;
    private JButton buttonCancel;
    private JButton buttonCopy;
    private JDialog dialog;
    private int ret = -1;

    public DataExportDialog() {
        this.makeDialog();
    }

    protected void makeDialog() {
        this.setLayout(new BorderLayout());
        this.makeButtonPanel();
        this.assignKeys();
        this.makeMainPanel();
    }

    private void makeMainPanel() {
        JPanel mainPanel = new JPanel();
        this.textArea = new JTextArea(20, 40);
        this.textArea.setLineWrap(true);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.textArea.selectAll();
        mainPanel.add(this.textArea);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        this.add((Component)jScrollPane, "North");
    }

    public void setText(String s) {
        this.textArea.append(s);
        this.textArea.setSelectionStart(0);
        this.textArea.setSelectionEnd(s.length());
    }

    public String getText() {
        return this.textArea.getText();
    }

    private void makeButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonOpen = new JButton(Messages.getString("DataExportDialog.buttonOpen"));
        this.buttonCopy = new JButton(Messages.getString("DataExportDialog.buttonCopy"));
        this.buttonCancel = new JButton(Messages.getString("DataExportDialog.buttonCancel"));
        ActionListener buttonAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source == DataExportDialog.this.buttonOpen) {
                    DataExportDialog.this.open();
                } else if (source == DataExportDialog.this.buttonCancel) {
                    DataExportDialog.this.cancel();
                } else if (source == DataExportDialog.this.buttonCopy) {
                    DataExportDialog.this.copyToClipboard();
                }
            }
        };
        this.buttonOpen.addActionListener(buttonAction);
        this.buttonCancel.addActionListener(buttonAction);
        this.buttonCopy.addActionListener(buttonAction);
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add(this.buttonCancel);
        this.buttonPanel.add(this.buttonOpen);
        this.buttonPanel.add(this.buttonCopy);
        this.add((Component)this.buttonPanel, "South");
    }

    private void assignKeys() {
        InputMap imap = this.getInputMap(1);
        imap.put(KeyStroke.getKeyStroke(27, 0), "close");
        ActionMap amap = this.getActionMap();
        amap.put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (DataExportDialog.this.dialog != null) {
                    DataExportDialog.this.ret = -1;
                    DataExportDialog.this.dialog.setVisible(false);
                }
            }
        });
    }

    protected void open() {
        this.ret = 0;
        this.dialog.setVisible(false);
    }

    protected void cancel() {
        this.ret = 2;
        this.dialog.setVisible(false);
    }

    protected void copyToClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection str = new StringSelection(this.getText());
        clipboard.setContents(str, null);
    }

    public int showDialog(Component parent, String title) {
        Frame owner = null;
        owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        this.dialog = new JDialog((java.awt.Frame)owner, true);
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.getRootPane().setDefaultButton(this.buttonCancel);
        this.dialog.setTitle(title);
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.setVisible(true);
        return this.ret;
    }
}

