/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.factory;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import pencilbox.common.core.Size;
import pencilbox.common.factory.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PencilType {
    public static final PencilType KAKURO = new PencilType("kakuro", Messages.getString("PencilType.kakuro"), 12);
    public static final PencilType KURODOKO = new PencilType("kurodoko", Messages.getString("PencilType.kurodoko"), 9);
    public static final PencilType GOISHI = new PencilType("goishi", Messages.getString("PencilType.goishi"), 8);
    public static final PencilType SHIKAKU = new PencilType("shikaku", Messages.getString("PencilType.shikaku"), 10);
    public static final PencilType SUDOKU = new PencilType("sudoku", Messages.getString("PencilType.sudoku"), 9);
    public static final PencilType SLALOM = new PencilType("slalom", Messages.getString("PencilType.slalom"), 10);
    public static final PencilType SLITHERLINK = new PencilType("slitherlink", Messages.getString("PencilType.slitherlink"), 11);
    public static final PencilType TENTAISHO = new PencilType("tentaisho", Messages.getString("PencilType.tentaisho"), 10);
    public static final PencilType NUMBERLINK = new PencilType("numberlink", Messages.getString("PencilType.numberlink"), 10);
    public static final PencilType NURIKABE = new PencilType("nurikabe", Messages.getString("PencilType.nurikabe"), 10);
    public static final PencilType HAKYUKOKA = new PencilType("hakyukoka", Messages.getString("PencilType.hakyukoka"), 10);
    public static final PencilType HASHI = new PencilType("hashi", Messages.getString("PencilType.hashi"), 9);
    public static final PencilType BIJUTSUKAN = new PencilType("bijutsukan", Messages.getString("PencilType.bijutsukan"), 10);
    public static final PencilType HITORI = new PencilType("hitori", Messages.getString("PencilType.hitori"), 8);
    public static final PencilType FILLOMINO = new PencilType("fillomino", Messages.getString("PencilType.fillomino"), 10);
    public static final PencilType HEYAWAKE = new PencilType("heyawake", Messages.getString("PencilType.heyawake"), 10);
    public static final PencilType MASYU = new PencilType("masyu", Messages.getString("PencilType.masyu"), 10);
    public static final PencilType YAJILIN = new PencilType("yajilin", Messages.getString("PencilType.yajilin"), 10);
    public static final PencilType LITS = new PencilType("lits", Messages.getString("PencilType.lits"), 10);
    private static final PencilType[] pencilTypeList = new PencilType[]{KAKURO, KURODOKO, GOISHI, SHIKAKU, SUDOKU, SLALOM, SLITHERLINK, TENTAISHO, NUMBERLINK, NURIKABE, HAKYUKOKA, HASHI, BIJUTSUKAN, HITORI, FILLOMINO, HEYAWAKE, MASYU, YAJILIN, LITS};
    private String pencilName;
    private String title;
    private int defaultSize;

    public static final List<PencilType> getPencilTypeList() {
        return Collections.unmodifiableList(Arrays.asList(pencilTypeList));
    }

    public static PencilType getPencilType(String name) {
        int i = 0;
        while (i < pencilTypeList.length) {
            if (pencilTypeList[i].getPencilName().equals(name)) {
                return pencilTypeList[i];
            }
            ++i;
        }
        return null;
    }

    private PencilType() {
    }

    private PencilType(String pencilName, String title, int defaultSize) {
        this.pencilName = pencilName;
        this.title = title;
        this.defaultSize = defaultSize;
    }

    public String getPencilName() {
        return this.pencilName;
    }

    public String getTitle() {
        return this.title;
    }

    public Size getDefaultSize() {
        return new Size(this.defaultSize, this.defaultSize);
    }
}

