/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.UndoManager;
import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.Messages;
import pencilbox.common.core.SideAddress;
import pencilbox.common.core.Size;

public class BoardBase {
    private UndoManager undoManager;
    private Size size;
    public static final String COMPLETE_MESSAGE = Messages.getString("BoardBase.MessageComplete");

    public void setSize(Size size) {
        this.size = size;
        this.setup();
    }

    public void setSize(int r, int c) {
        this.size = new Size(r, c);
        this.setup();
    }

    protected void setup() {
    }

    public void setUndoManager(UndoManager u) {
        this.undoManager = u;
    }

    public Size getSize() {
        return this.size;
    }

    public final int rows() {
        return this.size.getRows();
    }

    public final int cols() {
        return this.size.getCols();
    }

    public boolean isOn(int r, int c) {
        return r >= 0 && r < this.rows() && c >= 0 && c < this.cols();
    }

    public boolean isOn(int r, int c, int adjustRow, int adjustCol) {
        return r >= 0 && r < this.rows() + adjustRow && c >= 0 && c < this.cols() + adjustCol;
    }

    public boolean isOn(Address position) {
        return this.isOn(position.r(), position.c());
    }

    public boolean isOnAll(Address ... positions) {
        Address[] addressArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (!this.isOn(p)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isSideOn(int d, int r, int c) {
        if (d == 0) {
            return r >= 0 && r < this.rows() && c >= 0 && c < this.cols() - 1;
        }
        if (d == 1) {
            return r >= 0 && r < this.rows() - 1 && c >= 0 && c < this.cols();
        }
        return false;
    }

    public boolean isSideOn(SideAddress position) {
        return this.isSideOn(position.d(), position.r(), position.c());
    }

    public boolean isSideOn(Address pos, int dir) {
        switch (dir) {
            case 0: {
                return this.isSideOn(1, pos.r() - 1, pos.c());
            }
            case 1: {
                return this.isSideOn(0, pos.r(), pos.c() - 1);
            }
            case 2: {
                return this.isSideOn(1, pos.r(), pos.c());
            }
            case 3: {
                return this.isSideOn(0, pos.r(), pos.c());
            }
        }
        return false;
    }

    public boolean isAreaOn(Area area) {
        for (Address pos : area) {
            if (this.isOn(pos)) continue;
            return false;
        }
        return true;
    }

    public Area getWholeBoardArea() {
        Area area = new Area();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                area.add(new Address(r, c));
                ++c;
            }
            ++r;
        }
        return area;
    }

    public void clearBoard() {
    }

    public void trimAnswer() {
    }

    public void initBoard() {
    }

    public boolean isOnPeriphery(int r, int c) {
        return r == 0 || r == this.rows() - 1 || c == 0 || c == this.cols() - 1;
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent e) {
        this.undoManager.undoableEditHappened(e);
    }

    public String checkAnswerString() {
        return Messages.getString("BoardBase.MessageUnavailable");
    }

    public int checkAnswerCode() {
        return 0;
    }
}

