/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.numberlink;

import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.numberlink.Link;
import pencilbox.numberlink.Messages;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int HORIZ = 1;
    static final int VERT = 0;
    static final int UNKNOWN = 0;
    static final int LINE = 1;
    static final int NOLINE = -1;
    static final int OUTER = -9;
    static final int UNDECIDED_NUMBER = -1;
    static final int BLANK = 0;
    private int[][] number;
    private int[][][] state;
    private List<Link> linkList;
    private Link[][][] link;
    private Link initializingLink;

    protected void setup() {
        super.setup();
        this.state = new int[2][][];
        this.number = new int[this.rows()][this.cols()];
        this.state[0] = new int[this.rows()][this.cols() - 1];
        this.state[1] = new int[this.rows() - 1][this.cols()];
        this.linkList = new LinkedList<Link>();
        this.link = new Link[2][][];
        this.link[0] = new Link[this.rows()][this.cols() - 1];
        this.link[1] = new Link[this.rows() - 1][this.cols()];
    }

    public void clearBoard() {
        super.clearBoard();
        ArrayUtil.initArrayInt3(this.state, 0);
        this.initBoard();
    }

    public void trimAnswer() {
        int d = 0;
        while (d <= 1) {
            int r = 0;
            while (r < this.rows()) {
                int c = 0;
                while (c < this.cols()) {
                    if (this.getState(d, r, c) == -1) {
                        this.setState(d, r, c, 0);
                    }
                    ++c;
                }
                ++r;
            }
            ++d;
        }
    }

    int[][] getNumber() {
        return this.number;
    }

    int[][][] getState() {
        return this.state;
    }

    public boolean isNumber(int r, int c) {
        return this.number[r][c] > 0 || this.number[r][c] == -1;
    }

    public boolean isNumber(Address pos) {
        return this.isNumber(pos.r(), pos.c());
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public void setNumber(int r, int c, int n) {
        if (this.isOn(r, c)) {
            this.number[r][c] = n;
        }
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public int getState(int d, int r, int c) {
        if (this.isSideOn(d, r, c)) {
            return this.state[d][r][c];
        }
        return -9;
    }

    public int getState(SideAddress pos) {
        return this.getState(pos.d(), pos.r(), pos.c());
    }

    public int getStateJ(Address pos, int d) {
        return this.getState(SideAddress.get(pos, d));
    }

    public void setState(int d, int r, int c, int st) {
        this.state[d][r][c] = st;
    }

    public void setState(SideAddress pos, int st) {
        this.setState(pos.d(), pos.r(), pos.c(), st);
    }

    public void setStateJ(Address pos, int d, int st) {
        this.setState(SideAddress.get(pos, d), st);
    }

    public boolean isLine(int d, int r, int c) {
        if (!this.isSideOn(d, r, c)) {
            return false;
        }
        return this.state[d][r][c] == 1;
    }

    public Link getLink(int d, int r, int c) {
        if (this.isSideOn(d, r, c)) {
            return this.link[d][r][c];
        }
        return null;
    }

    public Link getLink(SideAddress pos) {
        return this.link[pos.d()][pos.r()][pos.c()];
    }

    public Link getLink(int r, int c) {
        Link link = this.getLink(0, r, c - 1);
        if (link != null) {
            return link;
        }
        link = this.getLink(0, r, c);
        if (link != null) {
            return link;
        }
        link = this.getLink(1, r - 1, c);
        if (link != null) {
            return link;
        }
        link = this.getLink(1, r, c);
        if (link != null) {
            return link;
        }
        return null;
    }

    public Link getLink(Address pos) {
        return this.getLink(pos.r(), pos.c());
    }

    public void setLink(int d, int r, int c, Link l) {
        this.link[d][r][c] = l;
    }

    public void setLink(SideAddress pos, Link l) {
        this.link[pos.d()][pos.r()][pos.c()] = l;
    }

    public void changeState(int d, int r, int c, int st) {
        int previousState = this.getState(d, r, c);
        this.setState(d, r, c, st);
        if (previousState == 1) {
            this.cutLink(d, r, c);
        }
        if (st == 1) {
            this.connectLink(d, r, c);
        }
    }

    public void changeStateA(SideAddress pos, int st) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(pos.d(), pos.r(), pos.c(), this.getState(pos), st)));
        this.changeState(pos.d(), pos.r(), pos.c(), st);
    }

    public void initBoard() {
        this.initLinks();
    }

    void initLinks() {
        Link.resetId();
        this.linkList.clear();
        ArrayUtil.initArrayObject2(this.link[0], null);
        ArrayUtil.initArrayObject2(this.link[1], null);
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                this.initLink(r, c);
                ++c;
            }
            ++r;
        }
    }

    private void addNumberToLink(Link link, int d, int r, int c) {
        if (d == 0) {
            if (this.isNumber(r, c)) {
                link.setNumber(this.getNumber(r, c));
            }
            if (this.isNumber(r, c + 1)) {
                link.setNumber(this.getNumber(r, c + 1));
            }
        } else {
            if (this.isNumber(r, c)) {
                link.setNumber(this.getNumber(r, c));
            }
            if (this.isNumber(r + 1, c)) {
                link.setNumber(this.getNumber(r + 1, c));
            }
        }
    }

    private void addNumberToLink(Link link, int r, int c) {
        if (this.isNumber(r, c)) {
            link.setNumber(this.getNumber(r, c));
        }
    }

    void initLink(int r, int c) {
        this.initializingLink = new Link();
        this.addNumberToLink(this.initializingLink, r, c);
        this.initLink1(0, r, c - 1);
        this.initLink1(0, r, c);
        this.initLink1(1, r - 1, c);
        this.initLink1(1, r, c);
        if (!this.initializingLink.isEmpty()) {
            this.linkList.add(this.initializingLink);
        }
    }

    private void initLink1(int d, int r, int c) {
        if (!this.isSideOn(d, r, c)) {
            return;
        }
        if (!this.isLine(d, r, c)) {
            return;
        }
        if (this.getLink(d, r, c) != null) {
            return;
        }
        this.initializingLink.add(d, r, c);
        this.setLink(d, r, c, this.initializingLink);
        if (d == 0) {
            this.initLink1(0, r, c - 1);
            this.initLink1(0, r, c + 1);
            this.initLink1(1, r - 1, c);
            this.initLink1(1, r - 1, c + 1);
            this.initLink1(1, r, c);
            this.initLink1(1, r, c + 1);
        }
        if (d == 1) {
            this.initLink1(1, r - 1, c);
            this.initLink1(1, r + 1, c);
            this.initLink1(0, r, c - 1);
            this.initLink1(0, r + 1, c - 1);
            this.initLink1(0, r, c);
            this.initLink1(0, r + 1, c);
        }
        this.addNumberToLink(this.initializingLink, d, r, c);
    }

    void connectLink(int d, int r, int c) {
        Link newLink = null;
        Link link1 = null;
        Link link2 = null;
        if (d == 0) {
            link1 = this.getLink(r, c);
            link2 = this.getLink(r, c + 1);
        } else if (d == 1) {
            link1 = this.getLink(r, c);
            link2 = this.getLink(r + 1, c);
        }
        if (link1 == null && link2 == null) {
            newLink = new Link();
            this.linkList.add(newLink);
        } else if (link1 == null && link2 != null) {
            newLink = link2;
        } else if (link1 != null && link2 == null) {
            newLink = link1;
        } else if (link1 == link2) {
            newLink = link1;
        } else if (link1.size() >= link2.size()) {
            newLink = link1;
            newLink.addAll(link2);
            for (SideAddress joint : link2) {
                this.setLink(joint, newLink);
            }
            this.linkList.remove(link2);
        } else {
            newLink = link2;
            newLink.addAll(link1);
            for (SideAddress joint : link1) {
                this.setLink(joint, newLink);
            }
            this.linkList.remove(link1);
        }
        newLink.add(d, r, c);
        this.setLink(d, r, c, newLink);
        this.addNumberToLink(newLink, d, r, c);
    }

    void cutLink(int d, int r, int c) {
        Link oldLink = this.getLink(d, r, c);
        Link longerLink = null;
        for (SideAddress joint : oldLink) {
            this.setLink(joint, null);
        }
        this.linkList.remove(oldLink);
        if (d == 0) {
            this.initLink(r, c);
            longerLink = this.initializingLink;
            this.initLink(r, c + 1);
            if (this.initializingLink.size() > longerLink.size()) {
                longerLink = this.initializingLink;
            }
        } else if (d == 1) {
            this.initLink(r, c);
            longerLink = this.initializingLink;
            this.initLink(r + 1, c);
            if (this.initializingLink.size() > longerLink.size()) {
                longerLink = this.initializingLink;
            }
        }
        longerLink.setId(oldLink.getId());
    }

    public int countLine(int r, int c) {
        int no = 0;
        if (r < this.rows() - 1 && this.isLine(1, r, c)) {
            ++no;
        }
        if (c < this.cols() - 1 && this.isLine(0, r, c)) {
            ++no;
        }
        if (r > 0 && this.isLine(1, r - 1, c)) {
            ++no;
        }
        if (c > 0 && this.isLine(0, r, c - 1)) {
            ++no;
        }
        return no;
    }

    public int checkAnswerCode() {
        int result = 0;
        result |= this.checkBranch();
        return result |= this.checkConnection();
    }

    private int checkBranch() {
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                int l = this.countLine(r, c);
                if (this.isNumber(r, c)) {
                    if (l > 1) {
                        result |= 4;
                    } else if (l == 0) {
                        result |= 8;
                    }
                } else if (l > 2) {
                    result |= 1;
                } else if (l == 1) {
                    result |= 2;
                }
                ++c;
            }
            ++r;
        }
        return result;
    }

    private int checkConnection() {
        int result = 0;
        for (Link link : this.linkList) {
            int number = link.getNumber();
            if (number == -1) {
                result |= 0x10;
                continue;
            }
            if (number != 0) continue;
            result |= 0x20;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 4) == 4) {
            message.append(Messages.getString("Board.AnswerCheckMessage1"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("Board.AnswerCheckMessage2"));
        }
        if ((result & 1) == 1) {
            message.append(Messages.getString("Board.AnswerCheckMessage3"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("Board.AnswerCheckMessage4"));
        }
        if ((result & 0x10) == 16) {
            message.append(Messages.getString("Board.AnswerCheckMessage5"));
        }
        if ((result & 0x20) == 32) {
            message.append(Messages.getString("Board.AnswerCheckMessage6"));
        }
        return message.toString();
    }

    class Step
    extends AbstractUndoableEdit {
        private int direction;
        private int row;
        private int col;
        private int before;
        private int after;

        public Step(int d, int r, int c, int b, int a) {
            this.direction = d;
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            Board.this.changeState(this.direction, this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Board.this.changeState(this.direction, this.row, this.col, this.after);
        }
    }
}

