package pencilbox.yajilin;

import java.util.LinkedList;
import java.util.List;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SideAddress;
import pencilbox.util.ArrayUtil;

/**
 * uWvՖʃNX
 */
public class Board extends BoardBase {
	
	private static final int HORIZ = Direction.HORIZ;
	private static final int VERT = Direction.VERT;
	
	static final int UNKNOWN = 0;
	static final int LINE = 1;
	static final int NOLINE = -1; // GUIł͕sgp
	static final int BLANK = -3;
	static final int WHITE = -1;
	static final int BLACK = -2;
	static final int OUTER = -9;
	static final int UNDECIDED_NUMBER = -4;

	private int[][] number;  // }X̏
	private int[][][] state; // ӂ̏

	private List<Link> linkList;
	private Link[][][] link;
	private Link initializingLink;

	protected void setup() {
		super.setup();
		number = new int[rows()][cols()];
		ArrayUtil.initArrayInt2(number, BLANK);
		state = new int[2][][];
		state[VERT] = new int[rows()][cols() - 1];
		state[HORIZ] = new int[rows() - 1][cols()];
		linkList = new LinkedList<Link>();
		link = new Link[2][][];
		link[VERT] = new Link[rows()][cols() - 1];
		link[HORIZ] = new Link[rows() - 1][cols()];
	}
	
	/**
	 * ̍W}XǂB
	 * @param r sW
	 * @param c W
	 * @return }XȂ true ԂB
	 */
	public boolean isBlack(int r, int c) {
		return isOn(r,c) && number[r][c] == BLACK;
	}
	/**
	 * w肵}Xɐ}XC}XC}XC󔒃}X̏Ԃݒ肷
	 * @param r sW
	 * @param c W
	 * @param n ݒ肷
	 */
	public void setNumber(int r, int c, int n) {
		number[r][c] = n;
	}

	public void setNumber(Address pos, int n) {
		setNumber(pos.r(), pos.c(), n);
	}
	/**
	 * w肵}X̏Ԃ擾
	 * @param r sW
	 * @param c W
	 */
	public int getNumber(int r, int c) {
		return number[r][c]; 
	}

	public int getNumber(Address pos) {
		return getNumber(pos.r(), pos.c());
	}
	/**
	 * w肵}X݂̐̂ԂB}Xɑ΂ĎgpB
	 * @param r sW
	 * @param c W
	 * @return }X̐ԂB}XłȂ -1
	 */
	public int getArrowNumber(int r, int c) {
		return number[r][c] >=0 ? number[r][c] & 15 : -1; 
	}
	
	public int getArrowNumber(Address pos) {
		return getArrowNumber(pos.r(), pos.c());
	}
	/**
	 * w肵}Xɏ̐ݒ肷B
	 * @param r sW
	 * @param c W
	 */
	public void setArrowNumber(int r, int c, int n) {
		number[r][c] = n; 
	}
	
	public void setArrowNumber(Address pos, int n) {
		setArrowNumber(pos.r(), pos.c(), n);
	}
	/**
	 * w肵}X̖̕pԂB}Xɑ΂ĎgpB
	 * @param r sW
	 * @param c W
	 * @return ̕p萔ԂB}XłȂ -1
	 */
	public int getArrowDirection(int r, int c) {
		return number[r][c] >= 0 ? (number[r][c]>>4) & 3 : -1; 
	}
	
	public int getArrowDirection(Address pos) {
		return getArrowDirection(pos.r(), pos.c());
	}
	/**
	 * w肵}X̖̕pݒ肷B}Xɑ΂ĎgpB
	 * @param r sW
	 * @param c W
	 */
	public void setArrowDirection(int r, int c, int dir) {
		if (dir < 0 || dir > 3) return;
		number[r][c] &= ~(3 << 4);
		number[r][c] |= (dir << 4); 
	}
	
	public void setArrowDirection(Address pos, int dir) {
		setArrowDirection(pos.r(), pos.c(), dir);
	}
	/**
	 * w肵}X̖̌@とE ̏ɕύXB}Xɑ΂ĎgpB
	 * @param pos }XW
	 */
	public void toggleArrowDirection(Address pos) {
		int t = getArrowDirection(pos);
		if (t<0) return;
		t = (t+1)%4;
		setArrowDirection(pos, t);
	}
	/**
	 * }X
	 * @param r sW
	 * @param c W
	 * @return }XC萔}Xł true
	 */
	public boolean isNumber(int r, int c) {
		return number[r][c] >= 0 || number[r][c] == UNDECIDED_NUMBER;
	}
	
	public boolean isNumber(Address pos) {
		return isNumber(pos.r(), pos.c());
	}
	/**
	 * W̗2}Xꂩ}XȂ}Xǂ
	 * @param d
	 * @param r
	 * @param c
	 * @return W̗2}Xꂩ}XȂ}Xł true
	 */
	public boolean hasNumberOrBlack(int d, int r, int c) {
		if (d == VERT)
			return isNumber(r, c) || isNumber(r, c+1) || isBlack(r, c) || isBlack(r, c+1);
		else if (d == HORIZ)
			return isNumber(r, c) || isNumber(r+1, c) || isBlack(r, c) || isBlack(r+1, c);
		return false;
	}

	public boolean hasNumberOrBlack(SideAddress side) {
		return hasNumberOrBlack(side.d(), side.r(), side.c());
	}

	/**
	 * 󔒃}Xɂ
	 * @param r sW
	 * @param c W
	 */
	public void eraseNumber(int r, int c) {
		number[r][c] = BLANK;
	}
	
	public void eraseNumber(Address pos) {
		eraseNumber(pos.r(), pos.c());
	}
	/**
	 * ̓͂󂯕t
	 * ̐ƓłΖ̌ςB
	 * łȂΐVt̐ݒ肷B
	 * @param pos }XW
	 * @param n ͂ꂽ
	 */
	public void enterNumber(Address pos, int n) {
		if (getArrowNumber(pos) == n)
			toggleArrowDirection(pos);
		else {
			eraseLinesAround(pos);
			setArrowNumber(pos, n);
		}
	}

	/**
	 * @return Returns the state.
	 */
	int[][][] getState() {
		return state;
	}
	/**
	 * ӏԂ̎擾
	 * @param d
	 * @param r
	 * @param c
	 * @return ӂ̏ԂԂ
	 */
	public int getState(int d, int r, int c) {
		if (isSideOn(d,r,c))
			return state[d][r][c];
		else
			return OUTER;
	}

	public int getState(SideAddress pos) {
		return getState(pos.d(), pos.r(), pos.c());
	}
	/**
	 * ӏԂ̎擾B}XƌōWw肷B
	 * @param pos
	 * @param d
	 * @return
	 */
	public int getStateJ(Address pos, int d) {
		return getState(SideAddress.get(pos, d));
	}
	/**
	 * ӏԂ̐ݒ
	 * @param d
	 * @param r
	 * @param c
	 * @param st
	 */
	public void setState(int d, int r, int c, int st) {
		if (isSideOn(d, r, c))
			state[d][r][c] = st;
	}

	public void setState(SideAddress pos, int st) {
		setState(pos.d(), pos.r(), pos.c(), st);
	}

	/**
	 * ӏԂ̐ݒB}XƌōWw肷B
	 * @param pos
	 * @param d
	 * @param st
	 */
	public void setStateJ(Address pos, int d, int st) {
		setState(SideAddress.get(pos, d), st);
	}

	public boolean isLine(int d, int r, int c) {
		if (!isSideOn(d,r,c))
			return false;
		return
		state[d][r][c] == LINE;
	}

	public Link getLink(int d, int r, int c) {
		if (isSideOn(d,r,c) ) return link[d][r][c];
		else return null;
	}
	public Link getLink(SideAddress pos) {
		return link[pos.d()][pos.r()][pos.c()];
	}
	/**
	 * ̃}X܂ Link Ԃ
	 */
	public Link getLink(int r, int c) {
		Link link;
		link = getLink(VERT, r, c - 1);
		if (link != null) return link;
		link = getLink(VERT, r, c);
		if (link != null) return link;
		link = getLink(HORIZ, r - 1, c);
		if (link != null) return link;
		link = getLink(HORIZ, r, c);
		if (link != null) return link;
		return null;
	}
	public void setLink(int d, int r, int c, Link l) {
		link[d][r][c] =  l;
	}
	public void setLink(SideAddress pos, Link l) {
		link[pos.d()][pos.r()][pos.c()] =  l;
	}
	/**
	 * Ֆʂ Link 邩
	 * @return@Link Ȃ true
	 */
	public boolean hasMultipleLinks() {
		return linkList.size() > 1;
	}
	
	/**
	 * }X㉺E4ɈĂ
	 * }X}X␔}XɕύXꂽꍇɐ邽߂Ɏgp
	 * @param pos }X̍W
	 */
	void eraseLinesAround(Address pos) {
		for (int d = 0; d <= 3; d++) {
			SideAddress side = SideAddress.get(pos, d);
			if (getState(side) == LINE) {
				changeState(side, UNKNOWN);
			}
		}
	}

	void eraseLinesAroundA(Address pos) {
		for (int d = 0; d <= 3; d++) {
			SideAddress side = SideAddress.get(pos, d);
			if (getState(side) == LINE) {
				changeStateA(side, UNKNOWN);
			}
		}
	}
	/**
	 * ՖʏԂύXCAhDXi[ɕύXʒmD
	 * @param pos
	 * @param st
	 */
	public void changeStateA(Address pos, int st) {
		fireUndoableEditUpdate(
			new UndoableEditEvent(this, new PaintStep(pos.r(), pos.c(), getNumber(pos), st)));
		setNumber(pos, st);	
	}
	/**
	 * ӂ̏Ԃw肵ԂɕύX
	 * @param d c
	 * @param r sW
	 * @param c W
	 * @param st ύX̏
	 */
	public void changeState(int d, int r, int c, int st) {
		int previousState = getState(d,r,c);
		setState(d,r,c,st);
		if (previousState == LINE) {
			cutLink(d,r,c);
		}
		if (st == LINE) {
			connectLink(d,r,c);
		}
	}

	public void changeState(SideAddress pos, int st) {
		changeState(pos.d(), pos.r(), pos.c(), st);
	}

	/**
	 * ӂ̏Ԃw肵ԂɕύX
	 * AhDXi[ɕύXʒm
	 * @param pos ӍW
	 * @param st ύX̏
	 */
	public void changeStateA(SideAddress pos, int st) {
		fireUndoableEditUpdate(
			new UndoableEditEvent(this, new LineStep(pos.d(), pos.r(), pos.c(), getState(pos), st)));
		changeState(pos, st);
	}

	public void clearBoard() {
		super.clearBoard();
		ArrayUtil.initArrayInt3(state, UNKNOWN);
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (!isNumber(r,c)) {
					number[r][c] = BLANK;
				}
			}
		}
		initBoard();
	}
	
	public void trimAnswer() {
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (getNumber(r, c) == WHITE)
					setNumber(r, c, BLANK);
				}
		}
	}

	public void initBoard() {
		initLinks();
	}
	
	void initLinks() {
		Link.resetId();
		linkList.clear();
		ArrayUtil.initArrayObject2(link[0],null);
		ArrayUtil.initArrayObject2(link[1],null);
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				initLink(r, c);
			}
		}
	}
	
	/**
	 * ̃}X̏㉺E̗אڂS}Xɍ}X邩ǂ𒲂ׂ
	 * @param r
	 * @param c
	 * @return ㉺Eɍ}XЂƂł true
	 */
	boolean isBlock(int r, int c) {
		if (isBlack(r-1, c) || isBlack(r+1, c) || isBlack(r, c-1) || isBlack(r, c+1))
			return true;
		return false;
	}

	boolean isBlock(Address pos) {
		return isBlock(pos.r(), pos.c());
	}

	/**
	 * }X܂ Link ̏
	 * link[][][] ͏Ă̂Ƃ
	 * @param r Link̋N_}X̍sW
	 * @param c Link̋N_}X̗W
	 */	
	void initLink (int r, int c) {
		initializingLink = new Link();
		initLink1(VERT , r  , c-1);
		initLink1(VERT , r  , c  );
		initLink1(HORIZ, r-1, c  );
		initLink1(HORIZ, r  , c  );
		if (!initializingLink.isEmpty())
			linkList.add(initializingLink);
//		printLink(d,r,c);
	}
	private void initLink1(int d, int r, int c) {
		if (!isSideOn(d,r,c)) return;
		if (!isLine(d,r,c)) return;
		if (getLink(d,r,c) != null) return;
		initializingLink.add(d,r,c);
		setLink(d, r, c, initializingLink);
		if (d==VERT) {
			initLink1(VERT , r  , c-1);
			initLink1(VERT , r  , c+1);
			initLink1(HORIZ, r-1, c  );
			initLink1(HORIZ, r-1, c+1);
			initLink1(HORIZ, r  , c  );
			initLink1(HORIZ, r  , c+1);
		}
		if (d==HORIZ) {
			initLink1(HORIZ, r-1, c  );
			initLink1(HORIZ, r+1, c  );
			initLink1(VERT , r  , c-1);
			initLink1(VERT , r+1, c-1);
			initLink1(VERT , r  , c  );
			initLink1(VERT , r+1, c  );
		}
	}
	/**
	 * Link 
	 */	
	void connectLink(int d, int r, int c) {
		Link newLink = null;
		Link link1 = null;
		Link link2 = null;
		if (d==VERT) {
			link1 = getLink(r,c);
			link2 = getLink(r,c+1);
		} else if (d==HORIZ) {
			link1 = getLink(r,c);
			link2 = getLink(r+1,c);
		}
		if (link1==null && link2 == null) {
			newLink = new Link();
			linkList.add(newLink);
		} else if (link1==null && link2!=null) {
			newLink = link2;
		} else if (link1!=null && link2==null) {
			newLink = link1;
		} else if (link1==link2) {
			newLink = link1;
		} else {
			if (link1.size() >= link2.size()) {
				newLink = link1;
				newLink.addAll(link2);
				for(SideAddress joint : link2) {
					setLink(joint, newLink);
				}
				linkList.remove(link2);
			}
			else {
				newLink = link2;
				newLink.addAll(link1);
				for(SideAddress joint : link1) {
					setLink(joint, newLink);
				}
				linkList.remove(link1);
			}
		}
		newLink.add(d,r,c);
		setLink(d,r,c, newLink);
//		printLink(d,r,c);
	}


	/**
	 * Link ؒf
	 */	
	void cutLink(int d, int r, int c) {
		Link oldLink = getLink(d,r,c);
		Link longerLink = null;
		for (SideAddress joint : oldLink) {
			setLink(joint, null);
		}
		linkList.remove(oldLink);
		if (d==VERT) {
			initLink(r  , c  );
			longerLink = initializingLink;
			initLink(r  , c+1);
			if (initializingLink.size() > longerLink.size()) longerLink = initializingLink;
		}
		else if (d==HORIZ) {
			initLink(r  , c  );
			longerLink = initializingLink;
			initLink(r+1, c  );
			if (initializingLink.size() > longerLink.size()) longerLink = initializingLink;
		}
		longerLink.setId(oldLink.getId());
	}

	/**
	 * }X̏㉺E4̂CݐĂ鐔Ԃ
	 * @param r }X̍sW
	 * @param c }X̗W
	 * @return }X̏㉺EɈĂ̐
	 */
	public int countLine(int r, int c) {
		int no = 0;
		if (r < rows() - 1 && isLine(HORIZ, r, c))
			no++;
		if (c < cols() - 1 && isLine(VERT, r, c))
			no++;
		if (r > 0 && isLine(HORIZ, r - 1, c))
			no++;
		if (c > 0 && isLine(VERT, r, c - 1))
			no++;
		return no;
	}
	
	public int countLine(Address pos) {
		return countLine(pos.r(), pos.c());
	}

	private int checkLinks() {
		int result = 0;
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				int l = countLine(r,c);
				if (l > 2) {
					result |= 1;
				} else if ( l == 1 ) {
					result |= 2; 
				}
				if (isBlack(r,c) && (l > 0))
					result |= 64;
				if (!isNumber(r,c) && !isBlack(r,c) && (l == 0))
					result |= 8;
			}
		}
		if (hasMultipleLinks())
			result |= 4;
		return result;
	}
	
	private int checkArrows() {
		int result = 0;
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (getNumber(r, c) >= 0) {
					result |= checkArrow(r,c);
				}
				if (isBlack(r, c)) {
					if (isBlock(r, c)) {
						result |= 32;
					}
				}
			}
		}
		return result;
	}
	
	int checkArrow(int r, int c) {
		int result = 0;
		int blackCount = 0;
		int dir = getArrowDirection(r,c);
		int number = getArrowNumber(r,c);
		Address pos = new Address(r,c);
		pos.move(dir);
		while (isOn(pos)) {
			if (isBlack(pos.r(),pos.c()))
				blackCount++;
			pos.move(dir);
		}
		if (number == blackCount)
			result = 0;
		else
			result = 16;
		return result;
	}

	public int checkAnswerCode() {
		int result = 0;
		result |= checkLinks();
		result |= checkArrows();
		return result;
	}

	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result == 0)
			return COMPLETE_MESSAGE; 
		StringBuffer message = new StringBuffer();
		if ((result & 1) == 1)
			message.append(Messages.getString("Board.AnswerCheckMessage1")); //$NON-NLS-1$
		if ((result & 2) == 2)
			message.append(Messages.getString("Board.AnswerCheckMessage2")); //$NON-NLS-1$
		if ((result & 4) == 4)
			message.append(Messages.getString("Board.AnswerCheckMessage3")); //$NON-NLS-1$
		if ((result & 8) == 8)
			message.append(Messages.getString("Board.AnswerCheckMessage4")); //$NON-NLS-1$
		if ((result & 64) == 64)
			message.append(Messages.getString("Board.AnswerCheckMessage7")); //$NON-NLS-1$
		if ((result & 32) == 32)
			message.append(Messages.getString("Board.AnswerCheckMessage6")); //$NON-NLS-1$
		if ((result & 16) == 16)
			message.append(Messages.getString("Board.AnswerCheckMessage5")); //$NON-NLS-1$
		return message.toString();
	}

	/**
	 * P̑\NX
	 * UNDO, REDO ł̕ҏW̒PʂƂȂ
	 */
	class Step extends AbstractUndoableEdit {
	}

	/**
	 * P̑\NX
	 * UNDO, REDO ł̕ҏW̒PʂƂȂ
	 */
	  class LineStep extends Step {

		  private int direction;
		  private int row;
		  private int col;
		  private int before;
		  private int after;
		  /**
		   * RXgN^
		   * @param d c
		   * @param r ύXꂽ}X̍sW
		   * @param c ύXꂽ}X̗W
		   * @param b ύXȌ
		   * @param a ύX̏
		   */
		  public LineStep(int d, int r, int c, int b, int a) {
			  super();
				  direction = d;
			  row = r;
			  col = c;
			  before = b;
			  after = a;
		  }
		  public void undo() throws CannotUndoException {
			  super.undo();
			  changeState(direction, row, col, before);
		  }
		  public void redo() throws CannotRedoException {
			  super.redo();
			  changeState(direction, row, col, after);
		  }
	  }
	/**
	 * P̑\NX
	 * UNDO, REDO ł̕ҏW̒PʂƂȂ
	 */
	  class PaintStep extends Step {

		  private int row;
		  private int col;
		  private int before;
		  private int after;
		  /**
		   * RXgN^
		   * @param r ύXꂽ}X̍sW
		   * @param c ύXꂽ}X̗W
		   * @param b ύXȌ
		   * @param a ύX̏
		   */
		  public PaintStep(int r, int c, int b, int a) {
			  super();
			  row = r;
			  col = c;
			  before = b;
			  after = a;
		  }
		  public void undo() throws CannotUndoException {
			  super.undo();
			  setNumber(row, col, before);
		  }
		  public void redo() throws CannotRedoException {
			  super.redo();
			  setNumber(row, col, after);
		  }
	  }

}
