package pencilbox.kakuro;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.gui.PanelEventHandlerBase;


  /**
   * uJbNv}EX^L[쏈NX
   */
public class PanelEventHandler extends PanelEventHandlerBase {

	private Board board;

	/**
	 * 
	 */
	public PanelEventHandler() {
	}

	protected void setBoard(BoardBase aBoard) {
		board = (Board) aBoard; 
		setMaxInputNumber(9);
	}

	/*
	 * [hɂ͉\قȂB
	 */
	protected int getMaxInputNumber() {
		if (isProblemEditMode())
			return 45;
		else
			return 9;
	}

	/*
	 * uJbNv}EX
	 */
	protected void leftPressed(Address pos) {
		if (!isCursorOn() || getCellCursor().isAt(pos)) {
			if (!board.isWall(pos)) {
				int n = board.getNumber(pos);
				if (n >= board.getMaxNumber())
					board.enterNumberA(pos, 0); 
				else if (n >= 0)
					board.enterNumberA(pos, n + 1);
			}
		}
	}
	
	protected void rightPressed(Address pos) {
		if (!isCursorOn() || getCellCursor().isAt(pos)) {
			if (!board.isWall(pos)) {
				int n = board.getNumber(pos);
				if (n == 0) 
					board.enterNumberA(pos, board.getMaxNumber()); 
				else if (n > 0)
					board.enterNumberA(pos, n - 1);
			}
		}
	}
	/*
	 * uJbNvL[
	 */
	protected void arrowKeyEntered(int direction) {
		super.arrowKeyEntered(direction);
		if (direction == Direction.LT)
			getKKCursor().setStair(KakuroCursor.UPPER);
		else if (direction == Direction.UP)
			getKKCursor().setStair(KakuroCursor.LOWER);
	}
	
	protected void numberEntered(Address pos, int num) {
		if (isProblemEditMode()) {
			if (getKKCursor().getStair() == KakuroCursor.LOWER)
				board.setSum(pos, Direction.VERT, num);
			else if (getKKCursor().getStair() == KakuroCursor.UPPER)
				board.setSum(pos, Direction.HORIZ, num);
			if (isSymmetricPlacementMode()) {
				Address posS = getSymmetricPosition(pos);
				if (isOn(posS))
					if (!board.isWall(posS))
						board.setWall(posS, 0, 0);
			}
		} else if (isCursorOn()){
			if (!board.isWall(pos))
				board.enterNumberA(pos, num);
		}
	}
	
	protected void spaceEntered(Address pos) {
		if (isProblemEditMode()) {
			if (pos.r() ==0 || pos.c() == 0)
				return;
			board.removeWall(pos);
			if (isSymmetricPlacementMode()) {
				Address posS = getSymmetricPosition(pos);
				if (isOn(posS))
					if (board.isWall(posS))
						board.removeWall(posS);
			}
		} else if (isCursorOn()){
			if (!board.isWall(pos))
				board.enterNumberA(pos, 0);
		}
	}
	
	protected void minusEntered(Address pos) {
		if (isProblemEditMode()) {
			if (getKKCursor().getStair() == KakuroCursor.LOWER)
				board.setSum(pos, Direction.VERT, 0);
			else if (getKKCursor().getStair() == KakuroCursor.UPPER)
				board.setSum(pos, Direction.HORIZ, 0);
			if (isSymmetricPlacementMode()) {
				Address posS = getSymmetricPosition(pos);
				if (isOn(posS) && !posS.equals(pos))
					if (!board.isWall(posS))
						board.setWall(posS, 0, 0);
			}
		}
	}

	/**
	 * @return the KakuroCursor
	 */
	KakuroCursor getKKCursor() {
		return (KakuroCursor) getCellCursor();
	}

	/**
	 * _Ώ̈ʒu̍W擾B JbNpB
	 * @param pos@W
	 * @return posƓ_Ώ̂Ȉʒu̍W
	 */
	public Address getSymmetricPosition(Address pos) {
		return new Address(board.rows()-pos.r(), board.cols()-pos.c());
	}
}
