package pencilbox.tentaisho;

import java.util.*;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.*;

import pencilbox.common.core.*;
import pencilbox.util.*;


/**
 *  uṼV[vՖʃNX
 */
public class Board extends BoardBase {
	
	/** Ȃ */
	static final int NOSTAR = 0;
	/**  */
	static final int WHITESTAR = 1;
	/**  */
	static final int BLACKSTAR = 2;

	private int[][] star;
	private Area[][] area;
	private List<Area> areaList;

	protected void setup () {
		super.setup();
		star = new int[rows()*2-1][cols()*2-1];
		area = new Area[rows()][cols()];
		areaList = new LinkedList<Area>();
	}


	public void clearBoard() {
		super.clearBoard();
		areaList.clear();
		ArrayUtil.initArrayObject2(area, null);
	}

	public void initBoard() {
		initAreas();
	}

	/**
	 * Ֆʏ̗̈̏s
	 */
	public void initAreas() {
		for (Area a : areaList) {
			initArea(a);
		}
	}
	
	/**
	 * @return Ֆʂ̐̐
	 */
	public int nStar() {
		int nStar = 0;
		for (int r = 0; r < rows()*2-1; r++)
			for (int c = 0; c < cols()*2-1; c++)
				if (hasStar(r,c)) nStar ++;
		return nStar;
	}
	/**
	 * @return the star
	 */
	int[][] getStar() {
		return star;
	}
	/**
	 * ̍W̐擾
	 * @param r
	 * @param c
	 * @return 
	 */
	public int getStar(int r, int c) {
		return star[r][c];
	}
	/**
	 * ̍Wɐݒ肷
	 * @param r
	 * @param c
	 * @param st
	 */
	public void setStar(int r, int c, int st) {
		star[r][c] = st;
	}
	/**
	 * ɗ^ꂽWɐ͂邩
	 * @param r
	 * @param c
	 * @return  true
	 */
	public boolean hasStar(int r, int c) {
		return star[r][c] > 0;
	}
	/**
	 * ̐WՏɂ邩
	 * 0<=r<rows*2-1, 0<=c<cols*2-1 łΔՏł
	 * @param r
	 * @param c
	 * @return@Տɂ true
	 */
	public boolean isOnStar(int r, int c) {
		return (r>=0 && r<rows()*2-1 && c>=0 && c<cols()*2-1);
	}
	/**
	 * ̃}Xꂩ̗̈Ɋ܂܂Ă邩ǂ
	 * @param r
	 * @param c
	 * @return ܂܂Ă true
	 */
	public boolean isCovered(int r, int c) {
		return area[r][c] != null;
	}
	/**
	 * ɗ^ꂽ}X̏̈擾
	 * @param r
	 * @param c
	 * @return }X̏̈
	 */
	public Area getArea(int r, int c) {
		return area[r][c];
	}

	public Area getArea(Address pos) {
		return getArea(pos.r(), pos.c());
	}
	/**
	 * Տ̃}XɁC̃}X̏̈ݒ肷
	 * @param r Row coordinate of the cell.
	 * @param c Colmun coordinate of the cell.
	 * @param a The area to set.
	 */
	public void setArea(int r, int c, Area a) {
		area[r][c] = a;
	}

	public void setArea(Address pos, Area a) {
		setArea(pos.r(), pos.c(), a);
	}
	/**
	 * ՖʂɐV̈ǉ
	 * @param newArea ǉ̈
	 */
	public void addArea(Area newArea) {
		for (Address pos : newArea) {
			setArea(pos.r(), pos.c(), newArea);
		}
		areaList.add(newArea);
	}

	/**
	 * ̈폜
	 * @param oldArea
	 */
	public void removeArea(Area oldArea) {
		for (Address pos : oldArea) {
			if (getArea(pos.r(), pos.c()) == oldArea)
				setArea(pos.r(), pos.c(), null);
		}
		areaList.remove(oldArea);
	}

	void addCellToAreaA(int r, int c, Area area) {
		fireUndoableEditUpdate(
			new UndoableEditEvent(this, new Step(r, c, area, Step.ADDED)));
		addCellToArea(r, c, area);
	}

	void removeCellFromAreaA(int r, int c, Area area) {
		fireUndoableEditUpdate(
			new UndoableEditEvent(this, new Step(r, c, area, Step.REMOVED)));
		removeCellFromArea(r, c, area);
	}
	/**
	 * }Ẍɒǉ
	 * @param r ǉ}X̍sW
	 * @param c ǉ}X̗W
	 * @param area ǉ̈
	 */
	public void addCellToArea(int r, int c, Area area) {
		if (area.isEmpty()) {
			areaList.add(area);
		}
		setArea(r, c, area);
		area.add(r, c);
		initArea(area);
	}

	public void addCellToArea(Address pos, Area area) {
		addCellToArea(pos.r(), pos.c(), area);
	}
	/**
	 * }Ẍ悩菜
	 * @param r 菜}X̍sW
	 * @param c 菜}X̗W
	 * @param area 菜̈
	 */
	public void removeCellFromArea(int r, int c, Area area) {
		setArea(r, c, null);
		area.remove(r, c);
		if (area.isEmpty()) {
			areaList.remove(area);
		} else {
			initArea(area);
		}
	}

	public void removeCellFromArea(Address pos, Area area) {
		removeCellFromArea(pos.r(), pos.c(), area);
	}
	/**
	 * VK쐬̈Ɋ܂܂鐯ݒ肷
	 * @param newArea
	 */
	void initArea(Area newArea) {
		int nStar = 0;
		StarAddress starPos = new StarAddress();
		for (Address pos : newArea) {
			for (int i=2*pos.r()-1; i<=2*pos.r()+1; i++) {
				for (int j=2*pos.c()-1; j<=2*pos.c()+1; j++) {
					if (isOnStar(i, j) && hasStar(i, j)) {
						if (nStar == 0) {
							nStar = getStar(i, j);
							starPos.set(i,j);
						} else if (nStar == 1 || nStar == 2) {
							if (!starPos.equals(i, j)) {
								nStar = -1;
								starPos.setNowhere();
							}
						} 
					}
				}
			}
		}
		newArea.setStarType(nStar);
		newArea.setStarPos(starPos);
	}
	
	public int checkAnswerCode() {
		int result = 0;
		for (Area a : areaList) {
			if (a.isPointSymmetry() == false) {
				result |= 1;
			} 
		}
		for (int r = 0; r < rows(); r++)
			for (int c = 0; c < cols(); c++)
				if (area[r][c] == null) result |= 2;
	
		return result;
	}

	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result ==0 )
			return COMPLETE_MESSAGE;
		StringBuffer message = new StringBuffer();
		if ((result&1) == 1)
			message.append("Ȃ̈悪\n");
		else if ((result&2) == 2)
			message.append("\n");
		return message.toString();
	}
	/**
	 * @return Returns the areaList.
	 */
	List<Area> getAreaList() {
		return areaList;
	}
	/**
	 * @return Returns the domain.
	 */
	Area[][] getArea() {
		return area;
	}
	/**
	 * P̑\NX
	 * UNDO, REDO ł̕ҏW̒PʂƂȂ
	 */
	class Step extends AbstractUndoableEdit {

		static final int ADDED = 1;
		static final int REMOVED = 0;
		static final int CHANGED = 2;
		
		private int r;
		private int c;
		private Area area;
		private int operation;

		/**
		 * RXgN^
		 * @param r ύXꂽ}X̍sW
		 * @param c ύXꂽ}X̗W
		 * @param area ύXꂽ̈
		 * @param operation ̎ށF̈Ƀ}Xǉꂽ̂C̈悩}Xꂽ̂Bj
		 */
		public Step(int r, int c, Area area, int operation) {
			super();
			this.r = r;
			this.c = c;
			this.area = area;
			this.operation = operation;
		}
		
		public void undo() throws CannotUndoException {
			super.undo();
			if (operation == ADDED) {
				removeCellFromArea(r, c, area);
			} else if (operation == REMOVED) {
				addCellToArea(r, c, area);
			}
		}

		public void redo() throws CannotRedoException {
			super.redo();
			if (operation == ADDED) {
				addCellToArea(r, c, area);
			} else if (operation == REMOVED) {
				removeCellFromArea(r, c, area);
			}
		}
	}

}

