package pencilbox.common.core;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.UndoManager;



/**
 * eՖʃNX̐eNX
 */
public class BoardBase {

	private UndoManager undoManager;
	private Size size;
	
	/**
	 * ՖʃTCYāCBoard ̏s
	 * @param size Ֆʂ̍sTCY
	 */
	public void setSize(Size size){
		this.size = size;
		setup();
	}
	/**
	 * Board ̏
	 * z񐶐Ȃǂ̏s
	 * eTuNXŃI[o[Ch
	 */
	protected void setup(){
	}	
	/**
	 * UndoManager ݒ肷
	 * @param u UndoManager
	 */
	public void setUndoManager(UndoManager u) {
		undoManager = u;
	}
	/**
	 * Ֆ Size 擾
	 * @return ՖʂSize
	 */
	public Size getSize() {
		return size;
	}
	/**
	 * Ֆʂ̍s擾
	 * @return s
	 */
	public final int rows() {
		return size.getRows();
	}
	/**
	 * Ֆʂ̗񐔂擾
	 * @return 
	 */
	public final int cols() {
		return size.getCols();
	}
	/**
	 * ōW^ꂽ}XՏɂ邩ǂ
	 * @param r sW
	 * @param c W
	 * @return Տɂ true
	 */
	public boolean isOn(int r, int c) {
		return (r >= 0 && r < rows() && c >= 0 && c < cols());
	}
	/**
	 * ōW^ꂽ}XՏɂ邩ǂ
	 * ՖʃTCY adjustRow, adjustCol ̒l̕␳
	 * 0 <= r < rows()+adjustRow, 0 <= c < col()+adjustCol ̂Ƃ true Ԃ
	 * @param r sW
	 * @param c W
	 * @param adjustRow s̕␳l
	 * @param adjustCol ̕␳l
	 * @return Տɂ true
	 */
	public boolean isOn(int r, int c, int adjustRow, int adjustCol) {
		return (r >= 0 && r < rows()+adjustRow && c >= 0 && c < cols()+adjustCol);
	}
	/**
	 * ōW^ꂽ}XՏɂ邩ǂ
	 * @param position ׂW
	 * @return Տɂ true
	 */
	public boolean isOn(Address position) {
		return isOn(position.r(), position.c());
	}
	/**
	 * ōW^ꂽ}XՏɂ邩ǂ
	 * @param position ׂW
	 * @return Տɂ true
	 */
	public boolean isOnAll(Address... positions) {
		for (Address p : positions)
			if (! isOn(p))
				return false;
		return true;
	}
	/**
	 * ōW^ꂽӂՏɂ邩ǂ
	 * @param d c
	 * @param r sW
	 * @param c W
	 * @return Տɂ true
	 */
	public boolean isSideOn(int d, int r, int c) {
		if (d==Direction.VERT)
			return (r >= 0 && r < rows() && c >= 0 && c < cols()-1);
		else if (d==Direction.HORIZ)
			return (r >= 0 && r < rows()-1 && c >= 0 && c < cols());
		else
			return false;
	}
	/**
	 * ōW^ꂽӂՏɂ邩ǂ
	 * @param position
	 * @return Տɂ true
	 */
	public boolean isSideOn(SideAddress position) {
		return isSideOn(position.d(), position.r(), position.c());
	}

	/**
	 * ōW^ꂽӂՏɂ邩ǂ
	 * @param position
	 * @return Տɂ true
	 */
	public boolean isSideOn(Address pos, int dir) {
		switch (dir) {
		case Direction.UP :
			return isSideOn(Direction.HORIZ, pos.r()-1, pos.c());
		case Direction.LT :
			return isSideOn(Direction.VERT, pos.r(), pos.c()-1);
		case Direction.DN :
			return isSideOn(Direction.HORIZ, pos.r(), pos.c());
		case Direction.RT :
			return isSideOn(Direction.VERT, pos.r(), pos.c());
		default :
			return false;
		}
	}
	/**
	 * ŗ^ꂽ̈ŜՓɂ邩
	 * @param area ̈
	 * @return ̈ŜՓɂ true, łȂ false ԂB
	 */
	public boolean isAreaOn(Area area) {
		for (Address pos : area) {
			if (!isOn(pos))
				return false;
		}
		return true;
	}
	/**
	 * 𓚂C̏Ֆʂɖ߂
	 * eTuNXŎ
	 */
	public void clearBoard() {
	}
	/**
	 * 𓚂Ֆʂ甒}X~Ȃǂ̕⏕I͂
	 * iCjeTuNXŎ
	 */
	public void trimAnswer() {
	}
	/**
	 * Ֆʐݒ肵ƂɌĂсCՖʏԂ
	 * eTuNXŕKvȏLq
	 */
	public void initBoard() {
	}
	/**
	 * ōW^ꂽ}XՏ̍ŊO}Xł邩ǂ
	 * @param r sW
	 * @param c W
	 * @return ŊO}XȂ true
	 */
	public boolean isOnPeriphery(int r, int c) {
		return (r == 0 || r == rows() - 1 || c == 0 || c == cols() - 1);
	}
	/**
	 * AhDCxgXi[ɃCxg̔ʒm
	 * AhDΏۂ̑삪ƂɌĂ
	 * @param e the event AhDΏۂ̑ƂȂCxg
	 */
	protected void fireUndoableEditUpdate(UndoableEditEvent e) {
		undoManager.undoableEditHappened(e);
	}
	/**
	 * `FbNŊ̏ꍇ̃Rg
	 */
	public static final String COMPLETE_MESSAGE = "ł";
	
	/**
	 * `FbNCʂ𕶎ŕԂ
	 * @return ʂ\
	 */
	public String checkAnswerString() {
		return "@\܂";
	}
	/**
	 * `FbNCʂ𐔒lŕԂ
	 * @return Ȃ 0
	 */
	public int checkAnswerCode() {
		return 0;
	}
}
