package pencilbox.common.gui;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import javax.swing.JOptionPane;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SideAddress;

/**
 * plɑ΂}EXCL[{[h̃CxgsNX
 */
public class PanelEventHandlerBase implements KeyListener, MouseListener, MouseMotionListener {

	private PanelBase panel;
	private BoardBase board;

	private int maxInputNumber = 99;
	private int previousInput = 0;
	private int symmetricPlacementMode = 0;
	private int immediateAnswerCheckMode = -1; // -1:OFF, 0:ON, 1:ALREADY_CHECKED

	private Address oldPos = new Address(-1, -1);
	private Address newPos = new Address(-1, -1);
	private SideAddress sidePos = new SideAddress();

	/**
	 * PanelEventHandler𐶐
	 */
	public PanelEventHandlerBase() {
	}

	public void setup(PanelBase panel, BoardBase board) {
		this.panel = panel;
		panel.addKeyListener(this);
		panel.addMouseListener(this);
		panel.addMouseMotionListener(this);
		setup(board);
	}

	public void setup(BoardBase board) {
		this.board = board;
		setBoard(board);
		resetPreviousInput();
		resetImmediateAnswerCheckMode();
	}

	/**
	 * ʃNX̃plɌʃNX̔Ֆʂݒ肷邽߂̃\bh
	 * eʃNXŃI[o[Ch
	 * @param board Ֆ
	 */
	protected void setBoard(BoardBase board) {
	}

	public PanelBase getPanel() {
		return panel;
	}

	/**
	 * @return the symmetricPlacementMode
	 */
	public boolean isSymmetricPlacementMode() {
		return symmetricPlacementMode == 1 ? true : false;
	}
	/**
	 * @param b the symmetricPlacementMode to set
	 */
	public void setSymmetricPlacementMode(boolean b) {
		this.symmetricPlacementMode = b ? 1 : 0;
	}

	/**
	 * @return the immediateAnswerCheckMode
	 */
	public boolean isImmediateAnswerCheckMode() {
		return this.immediateAnswerCheckMode >= 0 ? true : false;
	}
	/**
	 * @param b the immediateAnswerCheckMode to set
	 */
	public void setImmediateAnswerCheckMode(boolean b) {
		this.immediateAnswerCheckMode = b ? 0 : -1;
	}
	/**
	 * 𔻒胂[h̏ꍇɁCςݏԂ疢Ԃɖ߂B
	 */
	public void resetImmediateAnswerCheckMode() {
		if (immediateAnswerCheckMode == 1)
			immediateAnswerCheckMode = 0;
	}
	/**
	 * ͉\ȍő吔擾B
	 */
	protected int getMaxInputNumber() {
		return maxInputNumber;
	}
	/**
	 * ͉\ȍő吔ݒ肷
	 * @param number ݒ肷鐔l
	 */
	protected void setMaxInputNumber(int number) {
		maxInputNumber = number;
	}
	/**
	 * ͐̈ꎞLNA
	 */
	public void resetPreviousInput() {
		previousInput = 0;
	}

	public int getCellSize() {
		return panel.getCellSize();
	}

	public int getHalfCellSize() {
		return panel.getHalfCellSize();
	}

	public int getOffsetx() {
		return panel.getOffsetx();
	}

	public int getOffsety() {
		return panel.getOffsety();
	}

	public boolean isProblemEditMode() {
		return panel.isProblemEditMode();
	}

	public void setProblemEditMode(boolean b) {
		panel.setProblemEditMode(b);
		resetPreviousInput();
		if (b == false)
			resetImmediateAnswerCheckMode();
	}

	public CellCursor getCellCursor() {
		return panel.getCellCursor();
	}

	public boolean isCursorOn() {
		return panel.isCursorMode();
	}

	public void repaint() {
		panel.repaint();
	}

	public boolean isOn(Address position) {
		return board.isOn(position);
	}

//	public boolean isOn(int r, int c, int adjustRow, int adjustCol) {
//		return board.isOn(r, c, adjustRow, adjustCol);
//	}

	public boolean isSideOn(SideAddress position) {
		return board.isSideOn(position);
	}

	/**
	 * J[\WՖʏɂ邩B
	 * ʏ #isOn(Address) ƓʂԂB
	 * SL, TS J[\̍WnقȂ^Cvł́CTuNXōĒ`B
	 * @param position J[\W
	 * @return J[\WՖʏɂ true
	 */
	public boolean isCursorOnBoard(Address position) {
		return board.isOn(position);
	}

	/**
	 * PanelxsNZWPanel̗}XWɕϊ
	 * @param x Panel̃sNZWx
	 * @return xPanelWɕϊl
	 */
	public final int toC(int x) {
		return (x + getCellSize() - getOffsetx()) / getCellSize() - 1;
	}
	/**
	 * Panel̂sNZWPanel̍s}XWɕϊ
	 * @param y Panel̃sNZWy
	 * @return yPanelWɕϊl
	 */
	public final int toR(int y) {
		return (y + getCellSize() - getOffsety()) / getCellSize() - 1;
	}

	/**
	 * _Ώ̈ʒu̍W擾B
	 * @param pos@W
	 * @return posƓ_Ώ̂Ȉʒu̍W
	 */
	public Address getSymmetricPosition(Address pos) {
		return new Address(board.rows()-1-pos.r(), board.cols()-1-pos.c());
	}

	/*
	 * L[Xi[
	 */
	public void keyPressed(KeyEvent e) {
		int keyCode = e.getKeyCode();
		switch (keyCode) {
		case KeyEvent.VK_SLASH:
		case KeyEvent.VK_DIVIDE:
			slashKeyEntered();
			break;
		case KeyEvent.VK_LEFT: // 0x25
			arrowKeyEntered(Direction.LT);
			break;
		case KeyEvent.VK_UP: // 0x26
			arrowKeyEntered(Direction.UP);
			break;
		case KeyEvent.VK_RIGHT: // 0x27
			arrowKeyEntered(Direction.RT);
			break;
		case KeyEvent.VK_DOWN: // 0x28
			arrowKeyEntered(Direction.DN);
			break;
		case KeyEvent.VK_SPACE:
		case KeyEvent.VK_PERIOD:
		case KeyEvent.VK_DECIMAL:
			spaceKeyEntered();
			break;
		case KeyEvent.VK_MINUS:
		case KeyEvent.VK_SUBTRACT:
			minusKeyEntered();
			break;
		case KeyEvent.VK_SEMICOLON:
		case KeyEvent.VK_ADD:
			break;
		case KeyEvent.VK_COLON:
		case KeyEvent.VK_MULTIPLY:
			break;
		case KeyEvent.VK_0:
		case KeyEvent.VK_NUMPAD0:
			numberKeyEntered(0);
			break;
		case KeyEvent.VK_1:
		case KeyEvent.VK_NUMPAD1:
			numberKeyEntered(1);
			break;
		case KeyEvent.VK_2:
		case KeyEvent.VK_NUMPAD2:
			numberKeyEntered(2);
			break;
		case KeyEvent.VK_3:
		case KeyEvent.VK_NUMPAD3:
			numberKeyEntered(3);
			break;
		case KeyEvent.VK_4:
		case KeyEvent.VK_NUMPAD4:
			numberKeyEntered(4);
			break;
		case KeyEvent.VK_5:
		case KeyEvent.VK_NUMPAD5:
			numberKeyEntered(5);
			break;
		case KeyEvent.VK_6:
		case KeyEvent.VK_NUMPAD6:
			numberKeyEntered(6);
			break;
		case KeyEvent.VK_7:
		case KeyEvent.VK_NUMPAD7:
			numberKeyEntered(7);
			break;
		case KeyEvent.VK_8:
		case KeyEvent.VK_NUMPAD8:
			numberKeyEntered(8);
			break;
		case KeyEvent.VK_9:
		case KeyEvent.VK_NUMPAD9:
			numberKeyEntered(9);
			break;
		}
		repaint();
	}

	public void keyTyped(KeyEvent e) {
	}

	public void keyReleased(KeyEvent e) {
		checkAnswer();
	}

	/**
	 * L[͂B ̕ɃJ[\ړB
	 */
	protected void arrowKeyEntered(int direction) {
		if (!isProblemEditMode() && !isCursorOn())
			return;
		Address pos = getCellCursor().getPosition();
		pos.move(direction);
		if (isCursorOnBoard(pos)) {
			getCellCursor().setPosition(pos);
			resetPreviousInput();
		}
	}
	/**
	 * L[͂B 
	 * 0-9 ̐L[͂ꂽƂɁC󋵂ɉ2̐ɂ numberEntered\bhɓn
	 */
	protected void numberKeyEntered(int number) {
		int maxInput = getMaxInputNumber();
		if (previousInput * 10 + number <= maxInput) {
			number = previousInput * 10 + number;
		}
		if (number <= maxInput) {
			Address pos = getCellCursor().getPosition();
			numberEntered(pos, number);
			previousInput = number;
		}
	}
	/**
	 * ͂B
	 * eTuNXŎB
	 * @param pos ͂}X̍W
	 * @param num ͂
	 */
	protected void numberEntered(Address pos, int num) {
	}
	/**
	 * sIhL[̓͂B
	 * eTuNXŎB
	 * @param pos ̓}X̍W
	 */
	protected void spaceEntered(Address pos) {
	}

	protected void spaceKeyEntered() {
		Address pos = getCellCursor().getPosition();
		spaceEntered(pos);
		resetPreviousInput();
	}

	/**
	 * }CiXL[̓͂B
	 * eTuNXŎB
	 * @param pos ̓}X̍W
	 */
	protected void minusEntered(Address pos) {
	}

	protected void minusKeyEntered() {
		Address pos = getCellCursor().getPosition();
		minusEntered(pos);
	}

	/**
	 * XbVL[̓͂B
	 * u̓[hvƁu𓚃[hv؂ւ
	 */
	protected void slashKeyEntered() {
		if (isProblemEditMode())
			board.initBoard();
		setProblemEditMode(!isProblemEditMode());
	}

	/*
	 * }EXXi[
	 */
	public void mousePressed(MouseEvent e) {
		newPos.set(toR(e.getY()), toC(e.getX()));
		if (!isOn(newPos))
			return;
		int modifier = e.getModifiers();
		if ((modifier & InputEvent.BUTTON1_MASK) != 0) {
			if ((e.getModifiersEx() & InputEvent.SHIFT_DOWN_MASK) != 0)
				leftPressedShift(newPos);
			else
				leftPressed(newPos);
		} else if ((modifier & InputEvent.BUTTON3_MASK) != 0) {
			rightPressed(newPos);
		}
		moveCursor(newPos);
		oldPos.set(newPos); // ݈ʒuXV
		repaint();
	}

	public void mouseDragged(MouseEvent e) {
		newPos.set(toR(e.getY()), toC(e.getX()));
		if (!isOn(newPos)) {
			oldPos.setNowhere();
			return;
		}
		if (newPos.equals(oldPos))
			return; // }XɎ~܂Cxg͖
		// if (!newPos.isNextTo(oldPos)) return; // אڃ}XȊÕCxg͖
		// if (dragIneffective(oldPos, newPos)) return; // אڃ}XȊÕCxg͖
		if ((e.getModifiers() & InputEvent.BUTTON1_MASK) != 0) {
			leftDragged(oldPos, newPos);
		} else if ((e.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {
			rightDragged(oldPos, newPos);
		}
		moveCursor(newPos);
		oldPos.set(newPos); // ݈ʒuXV
		repaint();
	}

	public void mouseReleased(MouseEvent e) {
		if (!isOn(oldPos)) {
			dragFailed();
			repaint();
			return;
		}
		if ((e.getModifiers() & InputEvent.BUTTON1_MASK) != 0) {
			leftDragFixed(oldPos);
		} else if ((e.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {
			rightDragFixed(oldPos);
		}
		repaint();
		checkAnswer();
	}

	public void mouseExited(MouseEvent e) {
	}

	public void mouseEntered(MouseEvent e) {
	}

	public void mouseClicked(MouseEvent e) {
		mouseClicked1(e);
		mouseClicked2(e);
		repaint();
		checkAnswer();
	}

	public void mouseClicked1(MouseEvent e) {
		if (!isOn(newPos))
			return;
		int modifier = e.getModifiers();
		if ((modifier & InputEvent.BUTTON1_MASK) != 0) {
			if ((e.getModifiersEx() & InputEvent.SHIFT_DOWN_MASK) != 0)
				leftClickedShift(newPos);
			else
				leftClicked(newPos);
		} else if ((modifier & InputEvent.BUTTON3_MASK) != 0) {
			rightClicked(newPos);
		}
	}
	/**
	 * ӂ̈ʒũNbNB
	 * @param e
	 */
	public void mouseClicked2(MouseEvent e) {
		setSidePosition(e);
		if (!isSideOn(sidePos))
			return;
		int modifier = e.getModifiers();
		if ((modifier & InputEvent.BUTTON1_MASK) != 0) {
			if ((e.getModifiersEx() & InputEvent.SHIFT_DOWN_MASK) != 0)
				leftClickedShiftEdge(sidePos);
			else
				leftClickedEdge(sidePos);
		} else if ((modifier & InputEvent.BUTTON3_MASK) != 0) {
			rightClickedEdge(sidePos);
		}
	}

	/**
	 * }EXʒuɍł߂ӍWݒ肷B
	 * @param e
	 */
	public void setSidePosition(MouseEvent e) {
		int r = toR(e.getY());
		int c = toC(e.getX());
		int resx = e.getX() - getOffsetx() - getCellSize() * c;
		int resy = e.getY() - getOffsety() - getCellSize() * r;
		if (resx + resy < getCellSize()) {
			if (resx < resy)
				sidePos.set(Direction.VERT, r, c-1);
			else
				sidePos.set(Direction.HORIZ, r-1, c);
		} else {
			if (resy < resx)
				sidePos.set(Direction.VERT, r, c);
			else
				sidePos.set(Direction.HORIZ, r, c);
		}
	}

	public void mouseMoved(MouseEvent e) {
		// movePos.set(toR(e.getY()), toC(e.getX()));
		// if (!isOn(movePos))
		// return;
		// mouseMovedTo(movePos);
		// repaint();
	}

	/**
	 * {^ꂽƂɌĂ΂B
	 * TuNXőI[o[ChD
	 * @param position
	 */
	protected void leftPressed(Address position) {
	}

	protected void leftPressedShift(Address position) {
	}

	protected void leftClicked(Address position) {
	}

	protected void leftClickedShift(Address position) {
	}
	/**
	 * hbO܂܂V}XɈړƂɌĂ΂D
	 * KvɉăTuNXőI[o[ChD
	 * @param position
	 */
	protected void leftDragged(Address position) {
		// leftPressed(position);
	}

	protected void leftDragged(Address oldPos, Address position) {
		leftDragged(position);
	}

	/**
	 * }EX{^𗣂čhbOm肵ƂɌĂ΂B
	 * TuNXŃI[o[ChB
	 * @param dragEnd
	 */
	protected void leftDragFixed(Address dragEnd) {
	}
	/**
	 * E{^ꂽƂCEhbO܂܂V}XɈړƂɌĂ΂B
	 * TuNXőI[o[ChB
	 * @param position
	 */
	protected void rightPressed(Address position) {
	}

	protected void rightClicked(Address position) {
	}
	/**
	 * EhbO܂܂V}XɈړƂɌĂ΂B 
	 * TuNXőI[o[ChD
	 * @param position
	 */
	protected void rightDragged(Address position) {
		// rightPressed(position);
	}

	protected void rightDragged(Address oldPos, Address position) {
		rightDragged(position);
	}
	/**
	 * E}EX{^𗣂ĉEhbOm肵ƂɌĂ΂B
	 * TuNXŃI[o[ChB
	 * @param dragEnd
	 */
	protected void rightDragFixed(Address dragEnd) {
	}
	/**
	 * ՓŃhbOJnՊOŃhbOIƂɌĂ΂B
	 * KvɉTuNXŃhbǑnB
	 */
	protected void dragFailed() {
	}

	/**
	 * }EXŃJ[\ړB
	 * @param position
	 */
	protected void moveCursor(Address position) {
		getCellCursor().setPosition(position);
		resetPreviousInput();
	}

	/**
	 * ӂ̈ʒuNbNƂ̓߂B
	 * @param position
	 */
	protected void leftClickedEdge(SideAddress position) {
	}
	/**
	 * ӂ̈ʒuVtgNbNƂ̓߂BsgpB
	 * @param position
	 */
	protected void leftClickedShiftEdge(SideAddress position) {
	}
	/**
	 * ӂ̈ʒuENbNƂ̓߂B
	 * @param position
	 */
	protected void rightClickedEdge(SideAddress position) {
	}

	/**
	 * 	𔻒
	 */
	public void checkAnswer() {
		if (isProblemEditMode())
			return;
		if (immediateAnswerCheckMode == 0) {
			if (board.checkAnswerCode() == 0) {
				JOptionPane.showMessageDialog(panel, board.checkAnswerString(),
						"𔻒", JOptionPane.INFORMATION_MESSAGE);
				immediateAnswerCheckMode = 1;
			}
		}
	}

}
