package pencilbox.common.factory;


/**
 * NX⏕\bhW߂NX
 */
public class ClassUtil {

	public static final String BOARD_CLASS = "Board";
	public static final String MENU_CLASS = "Menu";
	public static final String PANEL_CLASS = "Panel";
	public static final String PANEL_EVENT_HANDLER_CLASS = "PanelEventHandler";
	public static final String PROBLEM_COPIER_CLASS = "ProblemCopier";
	public static final String PREFERENCES_COPIER_CLASS = "PreferencesCopier";
	public static final String TXTREADER_CLASS = "TxtReader";
	public static final String TXTWRITER_CLASS = "TxtWriter";
	public static final String XMLREADER_CLASS = "XmlReader";
	public static final String XMLWRITER_CLASS = "XmlWriter";
	public static final String PCLREADER_CLASS = "PclReader";
	public static final String PCLWRITER_CLASS = "PclWriter";

	/**
	 * ʃpYpbP[W className NX̃CX^X𐶐
	 * @param pencilType pY̎
	 * @param className NX̖O̕
	 * @return NX̃CX^X
	 * @throws PencilBoxClassException
	 */
	public static final Object createInstance(PencilType pencilType, String className)
			throws PencilBoxClassException {
		return createInstance(Constants.ROOT_PACKAGE_NAME + '.'
				+ pencilType.getPencilName() + '.' + className);
	}

	/**
	 * pbP[W className NX̃CX^X𐶐
	 * @param c NX
	 * @param className NX̖O̕
	 * @return NX̃CX^X
	 * @throws PencilBoxClassException
	 */
	public static final Object createInstance(Class c, String className)
			throws PencilBoxClassException {
		return createInstance(c.getPackage().getName() + '.' + className);
	}

	/** NXCX^X𐶐B
	 *  eOPencilBoxClassException ɕϊB
	 * @param fullClassName pbP[W݂̃NX
	 * @return NX̃CX^X
	 * @throws PencilBoxClassException
	 */
	public static final Object createInstance(String fullClassName)
			throws PencilBoxClassException {
		try {
			Class cls = Class.forName(fullClassName);
			return cls.newInstance();
		} catch (ClassNotFoundException e) {
			throw new PencilBoxClassException(e);
		} catch (InstantiationException e) {
			throw new PencilBoxClassException(e);
		} catch (IllegalAccessException e) {
			throw new PencilBoxClassException(e);
		}
	}
}
	
