/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.masyu;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.masyu.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;

    public PanelEventHandler() {
        this.setMaxInputNumber(2);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftClickedEdge(SideAddress pos) {
        this.board.toggleState(pos.d(), pos.r(), pos.c(), 1);
    }

    protected void rightClickedEdge(SideAddress pos) {
        this.board.toggleState(pos.d(), pos.r(), pos.c(), -1);
    }

    protected void leftDragged(Address dragStart, Address dragEnd) {
        if (dragStart.r() == dragEnd.r() || dragStart.c() == dragEnd.c()) {
            this.board.determineInlineState(dragStart, dragEnd, 1);
        }
    }

    protected void rightDragged(Address dragStart, Address dragEnd) {
        if (dragStart.r() == dragEnd.r() || dragStart.c() == dragEnd.c()) {
            this.board.determineInlineState(dragStart, dragEnd, 0);
        }
    }

    protected void numberEntered(Address pos, int n) {
        if (this.isProblemEditMode() && (n == 1 || n == 2)) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), n);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), 3);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), 0);
            if (this.isSymmetricPlacementMode() && this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), 0);
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), 3);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), 3);
            }
        }
    }
}

