/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hakyukoka;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.hakyukoka.Area;
import pencilbox.hakyukoka.Board;
import pencilbox.hakyukoka.Panel;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(9);
    }

    private void setSelectedNumber(int n) {
        ((Panel)this.getPanel()).setSelectedNumber(n);
    }

    Area getDraggingArea() {
        return ((Panel)this.getPanel()).getDraggingArea();
    }

    void setDraggingArea(Area draggingArea) {
        ((Panel)this.getPanel()).setDraggingArea(draggingArea);
    }

    protected void leftPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Area area = this.board.getArea(pos.r(), pos.c());
            if (area == null) {
                area = new Area();
                this.board.addCellToArea(pos.r(), pos.c(), area);
            }
            this.setDraggingArea(area);
        } else {
            if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos.r(), pos.c()))) {
                this.board.increaseNumber(pos.r(), pos.c());
            }
            this.setSelectedNumber(this.board.getNumber(pos.r(), pos.c()));
        }
    }

    protected void leftDragged(Address pos) {
        if (this.isProblemEditMode()) {
            Area draggingArea = this.getDraggingArea();
            if (draggingArea == null) {
                return;
            }
            Area oldArea = this.board.getArea(pos.r(), pos.c());
            if (oldArea != null && oldArea != draggingArea) {
                this.board.removeCellFromArea(pos.r(), pos.c(), oldArea);
                this.board.addCellToArea(pos.r(), pos.c(), draggingArea);
            } else if ((oldArea == null || oldArea != draggingArea) && oldArea == null) {
                this.board.addCellToArea(pos.r(), pos.c(), draggingArea);
            }
        } else {
            if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos.r(), pos.c()))) {
                this.board.increaseNumber(pos.r(), pos.c());
            }
            this.setSelectedNumber(this.board.getNumber(pos.r(), pos.c()));
        }
    }

    protected void rightPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Area oldArea = this.board.getArea(pos.r(), pos.c());
            if (oldArea != null) {
                this.board.removeCellFromArea(pos.r(), pos.c(), oldArea);
            }
        } else {
            if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos.r(), pos.c()))) {
                this.board.decreaseNumber(pos.r(), pos.c());
            }
            this.setSelectedNumber(this.board.getNumber(pos.r(), pos.c()));
        }
    }

    protected void rightDragged(Address pos) {
        if (this.isProblemEditMode()) {
            this.rightPressed(pos);
        }
    }

    protected void leftDragFixed(Address dragEnd) {
        this.setDraggingArea(null);
    }

    protected void dragFailed() {
        this.setDraggingArea(null);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            if (num > 0) {
                Address posS;
                this.board.changeNumber(pos.r(), pos.c(), num);
                this.board.setState(pos.r(), pos.c(), 1);
                if (this.isSymmetricPlacementMode() && !this.board.isStable((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                    this.board.setState(posS.r(), posS.c(), 1);
                    this.board.changeNumber(posS.r(), posS.c(), 0);
                }
            }
        } else if (this.isCursorOn() && num > 0 && !this.board.isStable(pos.r(), pos.c())) {
            this.board.enterNumberA(pos.r(), pos.c(), num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), 0);
            this.board.setState(pos.r(), pos.c(), 0);
            if (this.isSymmetricPlacementMode() && this.board.isStable((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setState(posS.r(), posS.c(), 0);
                this.board.changeNumber(posS.r(), posS.c(), 0);
            }
        } else if (this.isCursorOn() && !this.board.isStable(pos.r(), pos.c())) {
            this.board.enterNumberA(pos.r(), pos.c(), 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), 0);
            this.board.setState(pos.r(), pos.c(), 1);
            if (this.isSymmetricPlacementMode() && !this.board.isStable((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setState(posS.r(), posS.c(), 1);
                this.board.changeNumber(posS.r(), posS.c(), 0);
            }
        }
    }
}

