/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kurodoko;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.kurodoko.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean showNumberHint = false;
    private boolean warnWrongWall = false;
    private Color paintColor = Color.BLUE;
    private Color circleColor = Color.MAGENTA;
    private Color successColor = new Color(65280);
    private Color errorColor = new Color(0xFF0000);
    private Color errorColor2 = new Color(0xFFFF00);

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    public boolean isWarnWrongWall() {
        return this.warnWrongWall;
    }

    public void setWarnWrongWall(boolean warnWrongWall) {
        this.warnWrongWall = warnWrongWall;
    }

    public boolean isShowNumberHint() {
        return this.showNumberHint;
    }

    public void setShowNumberHint(boolean showNumberHint) {
        this.showNumberHint = showNumberHint;
    }

    public void drawPanel(Graphics2D g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    protected void drawBoard(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int st = this.board.getState(r, c);
                if (st == -2) {
                    g.setColor(this.paintColor);
                    this.paintCell(g, r, c);
                } else if (st == -1) {
                    g.setColor(this.circleColor);
                    this.placeCircle(g, r, c);
                } else if (st > 0) {
                    g.setColor(this.getNumberColor());
                    this.placeLargeCircle(g, r, c);
                    this.placeNumber(g, r, c, st);
                } else if (st == Board.UNDECIDED_NUMBER) {
                    g.setColor(this.getNumberColor());
                    this.placeLargeCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    public void paintCell(Graphics2D g, int r, int c) {
        if (this.isWarnWrongWall() && this.board.isBlock(r, c)) {
            g.setColor(this.errorColor);
        } else if (this.isWarnWrongWall() && this.board.getChain(r, c) < 0) {
            g.setColor(this.errorColor);
        } else {
            g.setColor(this.paintColor);
        }
        super.paintCell(g, r, c);
    }

    public void placeNumber(Graphics2D g, int r, int c, int num) {
        if (!this.isShowNumberHint()) {
            super.placeNumber(g, r, c, num);
        } else {
            int nSpace = this.board.getSumSpace(r, c);
            int nWhite = this.board.getSumWhite(r, c);
            if (nSpace < num) {
                g.setColor(this.errorColor);
                this.placeLargeFilledCircle(g, r, c);
                g.setColor(this.getNumberColor());
                this.placeLargeCircle(g, r, c);
                super.placeNumber(g, r, c, num);
            } else if (nSpace == num) {
                g.setColor(this.successColor);
                this.placeLargeFilledCircle(g, r, c);
                g.setColor(this.getNumberColor());
                this.placeLargeCircle(g, r, c);
                super.placeNumber(g, r, c, num);
            } else if (nWhite > num) {
                g.setColor(this.errorColor2);
                this.placeLargeFilledCircle(g, r, c);
                g.setColor(this.getNumberColor());
                this.placeLargeCircle(g, r, c);
                super.placeNumber(g, r, c, num);
            } else if (nSpace > num) {
                g.setColor(this.getNumberColor());
                this.placeLargeCircle(g, r, c);
                super.placeNumber(g, r, c, num);
            }
        }
    }
}

