/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.CellCursor;
import pencilbox.common.gui.HintDot;
import pencilbox.common.gui.PanelBase;
import pencilbox.kakuro.Board;
import pencilbox.kakuro.KakuroCursor;

public class Panel
extends PanelBase {
    private Board board;
    private boolean warnWrongNumber = false;
    private boolean showAllowedNumberDot = false;
    private Color inputColor = Color.BLUE;
    private Color wallColor = new Color(0xC0C0C0);
    private Color separationColor = Color.BLACK;
    private Color errorColor = Color.RED;
    private Font smallFont = new Font("SansSerif", 0, 13);
    private Address wallPos = new Address();
    private HintDot hintDot = new HintDot();

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setCursorOn(true);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.hintDot.setDot(this, 3, this.getCellSize());
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public boolean isShowAllowedNumberDot() {
        return this.showAllowedNumberDot;
    }

    public void setShowAllowedNumberDot(boolean showAllowedNumberDot) {
        this.showAllowedNumberDot = showAllowedNumberDot;
    }

    public boolean isWarnWrongNumber() {
        return this.warnWrongNumber;
    }

    public void setWarnWrongNumber(boolean warnWrongNumber) {
        this.warnWrongNumber = warnWrongNumber;
    }

    public void setDisplaySize(int size) {
        super.setDisplaySize(size);
        this.smallFont = new Font("SansSerif", 0, this.getCellSize() / 2);
        this.hintDot.setDotSize(this.getCellSize());
    }

    public CellCursor createCursor() {
        return new KakuroCursor();
    }

    public void drawPanel(Graphics2D g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    protected void drawBoard(Graphics2D g) {
        int c;
        g.setFont(this.smallFont);
        int r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                if (this.board.isWall(r, c)) {
                    this.drawWall(g, r, c, this.board.getSumH(r, c), this.board.getSumV(r, c));
                }
                ++c;
            }
            ++r;
        }
        g.setFont(this.getNumberFont());
        g.setColor(this.inputColor);
        r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                int state = this.board.getNumber(r, c);
                if (state > 0) {
                    if (this.isWarnWrongNumber() && this.board.isMultipleNumber(r, c)) {
                        g.setColor(this.errorColor);
                    } else {
                        g.setColor(this.inputColor);
                    }
                    this.placeNumber(g, r, c, state);
                } else if (this.isShowAllowedNumberDot()) {
                    this.placeNumberHint(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    void drawWall(Graphics2D g, int r, int c, int a, int b) {
        g.setColor(this.wallColor);
        this.wallPos.set(r, c);
        int statusA = this.board.getWordStatus(r, c, 1);
        int statusB = this.board.getWordStatus(r, c, 0);
        g.fillRect(this.toX(this.wallPos.c()) + 1, this.toY(this.wallPos.r()) + 1, this.getCellSize() - 1, this.getCellSize() - 1);
        g.setColor(this.separationColor);
        g.drawLine(this.toX(this.wallPos.c()), this.toY(this.wallPos.r()), this.toX(this.wallPos.c() + 1), this.toY(this.wallPos.r() + 1));
        FontMetrics metrics = g.getFontMetrics();
        String numS = Integer.toString(b);
        if (b > 0) {
            if (this.isWarnWrongNumber() && statusB == -1) {
                g.setColor(this.errorColor);
            } else {
                g.setColor(this.separationColor);
            }
            g.drawString(numS, this.toX(this.wallPos.c()) + (this.getHalfCellSize() - metrics.stringWidth(numS)) / 2 + 1, this.toY(this.wallPos.r()) + (this.getHalfCellSize() - metrics.getHeight()) / 2 + metrics.getAscent() + this.getHalfCellSize());
        }
        numS = Integer.toString(a);
        if (a > 0) {
            if (this.warnWrongNumber && statusA == -1) {
                g.setColor(this.errorColor);
            } else {
                g.setColor(this.separationColor);
            }
            g.drawString(numS, this.toX(this.wallPos.c()) + (this.getHalfCellSize() - metrics.stringWidth(numS)) / 2 + this.getHalfCellSize(), this.toY(this.wallPos.r()) + (this.getHalfCellSize() - metrics.getHeight()) / 2 + metrics.getAscent() + 1);
        }
        g.setColor(this.separationColor);
        if (this.board.isWall(r, c + 1)) {
            g.drawLine(this.toX(this.wallPos.c() + 1), this.toY(this.wallPos.r()), this.toX(this.wallPos.c() + 1), this.toY(this.wallPos.r() + 1));
        }
        if (this.board.isWall(r + 1, c)) {
            g.drawLine(this.toX(this.wallPos.c()), this.toY(this.wallPos.r() + 1), this.toX(this.wallPos.c() + 1), this.toY(this.wallPos.r() + 1));
        }
    }

    public void drawCursor(Graphics2D g) {
        super.drawCursor(g);
        if (this.isProblemEditMode()) {
            KakuroCursor kcursor = (KakuroCursor)this.getCellCursor();
            g.drawRect(this.toX(kcursor.c()) + kcursor.getStair() * this.getHalfCellSize(), this.toY(kcursor.r()) + (kcursor.getStair() ^ 1) * this.getHalfCellSize(), this.getHalfCellSize(), this.getHalfCellSize());
        }
    }

    void placeNumberHint(Graphics2D g, int r, int c) {
        if (this.board.getRemNo(r, c) == 0) {
            this.hintDot.placeHintCross(g, r, c);
        } else {
            this.hintDot.placeHintDot(g, r, c, this.board.getRemPattern(r, c));
        }
    }
}

