/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import pencilbox.kakuro.Board;
import pencilbox.kakuro.HintTbl;

public class DigitPatternHint {
    static final int HORIZ = 1;
    static final int VERT = 0;
    private Board board;
    private int[][] horizPattern;
    private int[][] vertPattern;
    private int[][] remPattern;
    private int[][] remNo;

    int getRemNo(int r, int c) {
        return this.remNo[r][c];
    }

    int getRemPattern(int r, int c) {
        return this.remPattern[r][c];
    }

    void init(Board board) {
        this.board = board;
        int rows = board.rows();
        int cols = board.cols();
        this.horizPattern = new int[rows][cols];
        this.vertPattern = new int[rows][cols];
        this.remPattern = new int[rows][cols];
        this.remNo = new int[rows][cols];
        this.helpReCalc();
    }

    void helpCheck(int r, int c) {
        this.helpCheckHoriz(r, c);
        this.helpCheckVert(r, c);
    }

    void helpCheckHoriz(int r, int c) {
        int sumPos = this.board.getWordHead(r, c, 1);
        int sum = this.board.getWordSum(r, c, 1);
        if (sum == 0) {
            return;
        }
        int no = this.board.getWordSize(r, c, 1);
        if (no > 9) {
            return;
        }
        int curSum = 0;
        int remNo = 0;
        int usedDigit = 0;
        int i = 0;
        while (i < no) {
            int n = this.board.getNumber(r, sumPos + 1 + i);
            if (n == 0) {
                ++remNo;
            } else {
                curSum += n;
                usedDigit |= 1 << n;
            }
            ++i;
        }
        if (remNo == 0) {
            return;
        }
        int remPat = HintTbl.getRemainingDigit(sum - curSum, remNo, usedDigit);
        int i2 = 0;
        while (i2 < no) {
            this.horizPattern[r][sumPos + 1 + i2] = remPat;
            this.setRem(r, sumPos + 1 + i2);
            ++i2;
        }
    }

    void helpCheckVert(int r, int c) {
        int sumPos = this.board.getWordHead(r, c, 0);
        int sum = this.board.getWordSum(r, c, 0);
        if (sum == 0) {
            return;
        }
        int no = this.board.getWordSize(r, c, 0);
        if (no > 9) {
            return;
        }
        int curSum = 0;
        int remNo = 0;
        int usedDigit = 0;
        int i = 0;
        while (i < no) {
            int n = this.board.getNumber(sumPos + 1 + i, c);
            if (n == 0) {
                ++remNo;
            } else {
                curSum += n;
                usedDigit |= 1 << n;
            }
            ++i;
        }
        if (remNo == 0) {
            return;
        }
        int remPat = HintTbl.getRemainingDigit(sum - curSum, remNo, usedDigit);
        int i2 = 0;
        while (i2 < no) {
            this.vertPattern[sumPos + 1 + i2][c] = remPat;
            this.setRem(sumPos + 1 + i2, c);
            ++i2;
        }
    }

    void setRem(int r, int c) {
        int pat;
        this.remPattern[r][c] = pat = this.horizPattern[r][c] & this.vertPattern[r][c];
        int n = 0;
        int i = 0;
        while (i < 9) {
            if ((pat & HintTbl.D_ARRAY[i]) != 0) {
                ++n;
            }
            ++i;
        }
        this.remNo[r][c] = n;
    }

    void helpReCalc() {
        int c;
        int r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                this.remNo[r][c] = 1;
                this.vertPattern[r][c] = 1022;
                this.horizPattern[r][c] = 1022;
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                if (this.board.isWall(r, c)) {
                    if (this.board.getSumH(r, c) != 0) {
                        this.helpCheck(r, c + 1);
                    }
                    if (this.board.getSumV(r, c) != 0) {
                        this.helpCheck(r + 1, c);
                    }
                }
                ++c;
            }
            ++r;
        }
    }
}

